//---------------------------------------------------------------------
// C  Program From Sparatan CapSense USB Demo
//----------------------------------------------------------------------
#include <m8c.h>
#include "PSoCAPI.h"

void NewLine(void); 
void PrintInt(int iVal);
void PrintChar(char cVal);
void ClearScreen(void);
BYTE CheckForSpacebar(void);
void PrintHeader( void);
void CursorHome(void);
//--------------------------------------------------------------------
void main(){
unsigned char bP; 
   M8C_EnableGInt;                        //Initialize                       
   USBUART_Start( USBUART_3V_OPERATION ); //USBUART UM Init
   while( !USBUART_Init() );                     
   CSD_Start();                           //CSD UM Init
   CSD_InitializeBaselines();
   CSD_SetDefaultFingerThresholds();

   while(1){
//      unsigned char bP;
   
      CSD_ScanAllSensors();              //ReadAllSensors
      CSD_UpdateAllBaselines();
      CSD_bIsAnySensorActive();

      for(bP = 1; bP < 0x10 ;bP *= 2){
         if(CSD_baSnsOnMask[0] & bP) PrintChar('1');
         else PrintChar('0');
         PrintChar(' ');
      }
      NewLine();

      while( !( INT_CLR0 & 0x40 ) );     //Wait for sleep tick   
      INT_CLR0 &= ~0x40;            
   }
}
//----------------------------------------------------------------------
void NewLine(void){
   while( !USBUART_bTxIsReady() );
   USBUART_PutCRLF();
}
//------------------------------------------------------------
void ClearScreen(void){
   PrintChar( 0x1B );
   while( !USBUART_bTxIsReady() );
   USBUART_PutChar( '[' );
   while( !USBUART_bTxIsReady() );
   USBUART_PutChar( '2' );
   while( !USBUART_bTxIsReady() );
   USBUART_PutChar( 'J' );
}
//------------------------------------------------------------
void PrintInt(int iVal){
   while(!USBUART_bTxIsReady());
   USBUART_PutSHexInt(iVal);
}
//------------------------------------------------------------
void PrintChar(char bVal){
   while(!USBUART_bTxIsReady());
   USBUART_PutChar(bVal);
}
//------------------------------------------------------------




















BYTE CheckForSpacebar(void){
   unsigned int iData;
   unsigned char bKey;
   unsigned char bStatus;
   
   bStatus = 0;                     //Default returns is 0
   while(USBUART_bGetRxCount()){
      iData = USBUART_ReadChar();
      bKey  = iData % 256;          //Strip off upper metadata byte
      if( bKey == ' ' )bStatus = 1; //Return 1 for spacebar
   }
   return bStatus;
}
//---------------------------------------------------------------
void PrintHeader(void){
   CursorHome();
   PrintChar('E');
   PrintChar('F');
   PrintChar('1');
   PrintChar(',');
   PrintChar('E');
   PrintChar('F');
   PrintChar('2');
   PrintChar(',');
   PrintChar('E');
   PrintChar('F');
   PrintChar('3');
   PrintChar(','); 
   PrintChar('E');
   PrintChar('F');
   PrintChar('4' );
   NewLine();
}
//-----------------------------------------------------------------
void CursorHome(void)
{
   PrintChar( 0x1B );
   PrintChar( '[' );
   PrintChar( 'H' );
}