;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: USBUART_cls_cdc.asm
;;  Version: 1.0, Updated on 2008/04/07 at 12:05:03
;; Generated by PSoC Designer ???
;;
;;  DESCRIPTION: Communication Device Class (CDC) request implementation
;;               for the CY8C24090 and CY7C64215 family of devices
;;
;;  Copyright (c) Cypress Semiconductor 2006 - 2007. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "USBUART_macros.inc"
include "USBUART.inc"
include "memory.inc"

IF (USBUART_bSerialNumberType & 1)   ;if serial number automatic
AREA SSCParmBlk(RAM,ABS)
SSCParameterBlk:              blk      8     ; reserve 8 bytes: F8 - FF for supervisory operation
ENDIF

AREA InterruptRAM (RAM,REL,CON)

DummyBuffer:
	BLK 8	; dummy buffer for SEND_ENCAPSULATED_COMMAND and GET_ENCAPSULATED_RESPONSE requests

IF (USBUART_bSerialNumberType & 1)   ;if serial number automatic
EXPORT USBUART_SerialString
USBUART_SerialString:
    BLK 1   ; bLength
    BLK 1   ; bDescriptorType = 3 (STRING)
    BLK 24  ; 12 symbols in unicode
ENDIF

EXPORT USBUART_LineCoding
EXPORT _USBUART_LineCoding
USBUART_LineCoding:
_USBUART_LineCoding:
	BLK	4	;dwDTERate		Data terminal rate, in bits per second
	BLK 1	;bCharFormat		Stop bits (0 = 1 stop bit, 1 = 1.5 stop bit, 2 = 2 stop bit)
	BLK	1	;bParityType		Parity (0 = none, 1 = odd, 2 = even, 3 = mark, 4 = space)
	BLK 1	;bDataBits			Data bits (5,6,7,8 or 16)

EXPORT USBUART_LineControlBitmap
EXPORT _USBUART_LineControlBitmap
USBUART_LineControlBitmap::
_USBUART_LineControlBitmap:
    BLK 2   ; Line control bitmap
    		;	D15..D2 - reserved
    		;   D1 - RTS (0 = deactivate carrier, 1 = activate carrier)
    		;	D0 - DTR (0 = not present, 1 = present)

AREA UserModules (ROM, REL)

.LITERAL
GetSetEncapsulatedCommand:
	TD_START_TABLE	1
	TD_ENTRY		USB_DS_RAM, 8, DummyBuffer, NULL_PTR

GetSetLineCodingTable:
    TD_START_TABLE  1
    TD_ENTRY        USB_DS_RAM, 7, USBUART_LineCoding, NULL_PTR
.ENDLITERAL

;-----------------------------------------------------------------------------
;  USB 2nd Tier Dispatch Jump Tables for CDC Requests (based on bRequest)
;-----------------------------------------------------------------------------
;  FUNCTION NAME: ;  USB 2nd Tier Dispatch Jump Table
;
;  DESCRIPTION:   The following tables dispatch to the Class request handler
;                 functions.  (Assumes bmRequestType(5:6) is 1, Class)
;-----------------------------------------------------------------------------
USBUART_DT_h2d_cls_ifc:
    jmp     USBUART_CB_h2d_cls_ifc_00			;00
    jmp     USBUART_Not_Supported_Local1		;01
    jmp     USBUART_Not_Supported_Local1		;02
    jmp     USBUART_Not_Supported_Local1		;03
    jmp     USBUART_Not_Supported_Local1		;04
    jmp     USBUART_Not_Supported_Local1		;05
    jmp     USBUART_Not_Supported_Local1		;06
    jmp     USBUART_Not_Supported_Local1		;07
    jmp     USBUART_Not_Supported_Local1		;08
    jmp     USBUART_Not_Supported_Local1		;09
    jmp     USBUART_Not_Supported_Local1		;0A
    jmp     USBUART_Not_Supported_Local1		;0B
    jmp     USBUART_Not_Supported_Local1		;0C
    jmp     USBUART_Not_Supported_Local1		;0D
    jmp     USBUART_Not_Supported_Local1		;0E
    jmp     USBUART_Not_Supported_Local1		;0F
    jmp     USBUART_Not_Supported_Local1		;10
    jmp     USBUART_Not_Supported_Local1		;11
    jmp     USBUART_Not_Supported_Local1		;12
    jmp     USBUART_Not_Supported_Local1		;13
    jmp     USBUART_Not_Supported_Local1		;14
    jmp     USBUART_Not_Supported_Local1		;15
    jmp     USBUART_Not_Supported_Local1		;16
    jmp     USBUART_Not_Supported_Local1		;17
    jmp     USBUART_Not_Supported_Local1		;18
    jmp     USBUART_Not_Supported_Local1		;19
    jmp     USBUART_Not_Supported_Local1		;1A
    jmp     USBUART_Not_Supported_Local1		;1B
    jmp     USBUART_Not_Supported_Local1		;1C
    jmp     USBUART_Not_Supported_Local1		;1D
    jmp     USBUART_Not_Supported_Local1		;1E
    jmp     USBUART_Not_Supported_Local1		;1F
    jmp     USBUART_CB_h2d_cls_ifc_20			;20
    jmp     USBUART_Not_Supported_Local1		;21
    jmp     USBUART_CB_h2d_cls_ifc_22			;22
USBUART_DT_h2d_cls_ifc_End:
USBUART_DT_h2d_cls_ifc_Size: equ (USBUART_DT_h2d_cls_ifc_End-USBUART_DT_h2d_cls_ifc) / 2

USBUART_DT_h2d_cls_ifc_Dispatch::
    mov   A, REG[USBUART_EP0DATA + bRequest]       ; Get the request number
    DISPATCHER USBUART_DT_h2d_cls_ifc, USBUART_DT_h2d_cls_ifc_Size, USBUART_Not_Supported_Local1

;-----------------------------------------------------------------------------
USBUART_DT_d2h_cls_ifc:
    jmp     USBUART_Not_Supported_Local1		;00
    jmp     USBUART_CB_d2h_cls_ifc_01			;01
    jmp     USBUART_Not_Supported_Local1		;02
    jmp     USBUART_Not_Supported_Local1		;03
    jmp     USBUART_Not_Supported_Local1		;04
    jmp     USBUART_Not_Supported_Local1		;05
    jmp     USBUART_Not_Supported_Local1		;06
    jmp     USBUART_Not_Supported_Local1		;07
    jmp     USBUART_Not_Supported_Local1		;08
    jmp     USBUART_Not_Supported_Local1		;09
    jmp     USBUART_Not_Supported_Local1		;0A
    jmp     USBUART_Not_Supported_Local1		;0B
    jmp     USBUART_Not_Supported_Local1		;0C
    jmp     USBUART_Not_Supported_Local1		;0D
    jmp     USBUART_Not_Supported_Local1		;0E
    jmp     USBUART_Not_Supported_Local1		;0F
    jmp     USBUART_Not_Supported_Local1		;10
    jmp     USBUART_Not_Supported_Local1		;11
    jmp     USBUART_Not_Supported_Local1		;12
    jmp     USBUART_Not_Supported_Local1		;13
    jmp     USBUART_Not_Supported_Local1		;14
    jmp     USBUART_Not_Supported_Local1		;15
    jmp     USBUART_Not_Supported_Local1		;16
    jmp     USBUART_Not_Supported_Local1		;17
    jmp     USBUART_Not_Supported_Local1		;18
    jmp     USBUART_Not_Supported_Local1		;19
    jmp     USBUART_Not_Supported_Local1		;1A
    jmp     USBUART_Not_Supported_Local1		;1B
    jmp     USBUART_Not_Supported_Local1		;1C
    jmp     USBUART_Not_Supported_Local1		;1D
    jmp     USBUART_Not_Supported_Local1		;1E
    jmp     USBUART_Not_Supported_Local1		;1F
    jmp     USBUART_Not_Supported_Local1		;20
    jmp     USBUART_CB_d2h_cls_ifc_21			;21
USBUART_DT_d2h_cls_ifc_End:
USBUART_DT_d2h_cls_ifc_Size: equ (USBUART_DT_d2h_cls_ifc_End-USBUART_DT_d2h_cls_ifc) / 2

USBUART_DT_d2h_cls_ifc_Dispatch::
    mov   A, REG[USBUART_EP0DATA + bRequest]       ; Get the request number
    DISPATCHER USBUART_DT_d2h_cls_ifc, USBUART_DT_d2h_cls_ifc_Size, USBUART_Not_Supported_Local1

;-----------------------------------------------------------------------------
; FUNCTION NAME: USBUART_CB_h2d_cls_ifc_00
;-----------------------------------------------------------------------------
; CDC INTERFACE REQUEST: Send_Encapsulated_Command
;-----------------------------------------------------------------------------
; bmRequestType  : (H2D | CLASS | INTERFACE)      		= 21h
; bRequest       : SET_ENCAPSULATED_COMMAND		     	= 00h
; wValue         : Zero		                    		= 0000h
; wIndex         : INTERFACE                      		= --xxh
; wLength        : Amount of data, in bytes associated with recipient
; Data			 : Control protocol-based command (Dummy buffer)
;-----------------------------------------------------------------------------
USBUART_CB_h2d_cls_ifc_00:
    mov   A, REG[USBUART_EP0DATA+wIndexLo] ; Get the interface number
    cmp   A, 2                           ; Only for CDC interfaces (1 and 2)
    jnc   USBUART_Not_Supported_Local1
    mov   [USBUART_t2], A                  ; Selector
    mov   A,>GetSetEncapsulatedCommand   ; Get the ROM Address MSB
    mov   X,<GetSetEncapsulatedCommand   ; Get the ROM Address LSB
    ljmp   USBUART_GetTableEntry

;-----------------------------------------------------------------------------
; FUNCTION NAME: USBUART_CB_h2d_cls_ifc_20
;-----------------------------------------------------------------------------
; CDC INTERFACE REQUEST: Set_Line_Coding
;-----------------------------------------------------------------------------
; bmRequestType  : (H2D | CLASS | INTERFACE)      		= 21h
; bRequest       : SET_LINE_CODING				     	= 20h
; wValue         : Zero		                    		= 0000h
; wIndex         : INTERFACE                      		= --xxh
; wLength        : Report Size                    		= 0007h
; Data			 : Line Coding Structure
;-----------------------------------------------------------------------------
USBUART_CB_h2d_cls_ifc_20:
    mov   A, REG[USBUART_EP0DATA+wIndexLo] ; Get the interface number
    cmp   A, 2                           ; Only for CDC interfaces (1 and 2)
    jnc   USBUART_Not_Supported_Local1
    mov   [USBUART_t2], A                  ; Selector
    mov   A,>GetSetLineCodingTable       ; Get the ROM Address MSB
    mov   X,<GetSetLineCodingTable       ; Get the ROM Address LSB
    ljmp   USBUART_GetTableEntry

;-----------------------------------------------------------------------------
; FUNCTION NAME: USBUART_CB_h2d_cls_ifc_22
;-----------------------------------------------------------------------------
; CDC INTERFACE REQUEST: Set_Control_Line_State
;-----------------------------------------------------------------------------
; bmRequestType  : (H2D | CLASS | INTERFACE)      		= 21h
; bRequest       : SET_CONTROL_LINE_STATE		     	= 22h
; wValue         : Control Signal Bitmap           		= xxxxh
; wIndex         : INTERFACE                      		= --xxh
; wLength        : Report Size                    		= 0000h
; Data			 : Line Coding Structure
;-----------------------------------------------------------------------------
USBUART_CB_h2d_cls_ifc_22:
    mov   A, REG[USBUART_EP0DATA+wIndexLo] ; Get the interface number
    cmp   A, 2                           ; Only for CDC interfaces (1 and 2)
    jnc   USBUART_Not_Supported_Local1
    mov   A, REG[USBUART_EP0DATA+wValueLo] ; Get the bitmap
    mov   [USBUART_LineControlBitmap+1], A
    ljmp   USBUART_NoDataStageControlTransfer

;-----------------------------------------------------------------------------
;  FUNCTION NAME: USBUART_CB_d2h_cls_ifc_01
;-----------------------------------------------------------------------------
; CDC INTERFACE REQUEST: Get_Encapsulated_Response
;-----------------------------------------------------------------------------
; bmRequestType  : (D2H | CLASS | INTERFACE)      		= A1h
; bRequest       : GET_ENCAPSULATED_RESPONSE	     	= 01h
; wValue         : Zero		               				= 0000h
; wIndex         : INTERFACE                      		= --xxh
; wLength        : Amount of data, in bytes associated with recipient
; Data			 : Control protocol-based data (Dummy buffer)
;-----------------------------------------------------------------------------
USBUART_CB_d2h_cls_ifc_01:
    mov   A, REG[USBUART_EP0DATA+wIndexLo] ; Get the interface number
    cmp   A, 2                           ; Only for CDC interfaces (1 and 2)
    jnc   USBUART_Not_Supported_Local1
    mov   [USBUART_t2], A                  ; Selector
    mov   A,>GetSetEncapsulatedCommand   ; Get the ROM Address MSB
    mov   X,<GetSetEncapsulatedCommand   ; Get the ROM Address LSB
    ljmp   USBUART_GetTableEntry

;-----------------------------------------------------------------------------
;  FUNCTION NAME: USBUART_CB_d2h_cls_ifc_21
;-----------------------------------------------------------------------------
; CDC INTERFACE REQUEST: Get_Line_Coding
;-----------------------------------------------------------------------------
; bmRequestType  : (D2H | CLASS | INTERFACE)      		= A1h
; bRequest       : GET_LINE_CODING				     	= 21h
; wValue         : Zero		               				= 0000h
; wIndex         : INTERFACE                      		= --xxh
; wLength        : Report Size                    		= 0007h
; Data			 : Line Coding Structure
;
;-----------------------------------------------------------------------------
USBUART_CB_d2h_cls_ifc_21:

    mov   A, REG[USBUART_EP0DATA+wIndexLo] ; Get the interface number
    cmp   A, 2                           ; Only for CDC interfaces (1 and 2)
    jnc   USBUART_Not_Supported_Local1
    mov   [USBUART_t2], A                  ; Selector
    mov   A,>GetSetLineCodingTable       ; Get the ROM Address MSB
    mov   X,<GetSetLineCodingTable       ; Get the ROM Address LSB
    ljmp   USBUART_GetTableEntry

;-----------------------------------------------------------------------------
;  FUNCTION NAME: USBUART_Not_Supported_Local1
;-----------------------------------------------------------------------------
;  Handle requests that are not supported
;-----------------------------------------------------------------------------
USBUART_Not_Supported_Local1:
	ljmp USBUART_Not_Supported
