;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: USBUART.inc
;;  Version: 1.0, Updated on 2008/04/07 at 12:05:03
;;  Generated by PSoC Designer ???
;;
;;  DESCRIPTION:    Assembler declarations for the USB user module interface
;;                  for the CY8C24090 and CY7C64215 family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2006 - 2007. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

;--------------------------------------------------
; Constants for interrupt regs and masks
;--------------------------------------------------
USBUART_INT_REG:                           equ 0xDF
USBUART_INT_RESET_MASK:                    equ 0x01
USBUART_INT_SOF_MASK:                      equ 0x02
USBUART_INT_EP0_MASK:                      equ 0x04
USBUART_INT_EP1_MASK:                      equ 0x08
USBUART_INT_EP2_MASK:                      equ 0x10
USBUART_INT_EP3_MASK:                      equ 0x20
USBUART_INT_EP4_MASK:                      equ 0x40
USBUART_INT_WAKEUP_MASK:                   equ 0x80

;--------------------------------------------------
; Constants for USBUART API's.
;--------------------------------------------------
USBUART_3V_OPERATION:              EQU 0x02
USBUART_5V_OPERATION:              EQU 0x03

USBUART_1_STOPBIT:                 EQU 0x00
USBUART_1_5_STOPBIT:               EQU 0x01
USBUART_2_STOPBIT:                 EQU 0x02

USBUART_PARITY_NONE:               EQU 0x00
USBUART_PARITY_ODD:                EQU 0x01
USBUART_PARITY_EVEN:               EQU 0x02
USBUART_PARITY_MARK:               EQU 0x03
USBUART_PARITY_SPACE:              EQU 0x04

USBUART_DTR:                       EQU 0x01
USBUART_RTS:                       EQU 0x02

USBUART_DCD:                       EQU 0x01
USBUART_DSR:                       EQU 0x02
USBUART_BREAK:                     EQU 0x04
USBUART_RING:                      EQU 0x08
USBUART_FRAMING_ERR:               EQU 0x10
USBUART_PARITY_ERR:                EQU 0x20
USBUART_OVERRUN:                   EQU 0x40

USBUART_SERIAL_NONE:               EQU 0x00
USBUART_SERIAL_AUTO:               EQU 0x01
USBUART_SERIAL_MANUAL:             EQU 0x02
USBUART_bSerialNumberType:         EQU 0


USB_NUM_ENDPOINTS:                          EQU 5
USB_MAX_EP_NUMBER:                          EQU (USB_NUM_ENDPOINTS - 1)


;--------------------------------------------------
; Registers for USBUART API's.
;--------------------------------------------------

USBUART_ADDR:                               EQU 0x4a
USBUART_USBIO_CR0:                          EQU 0x4b
USBUART_USBIO_CR1:                          EQU 0x4c
USBUART_USB_CR1:                            EQU 0xc1

USBUART_EP0MODE:                            EQU 0x56
USBUART_EP0CNT:                             EQU 0x57
USBUART_EP0DATA:                            EQU 0x58
USBUART_EP1MODE:                            EQU 0xc4
USBUART_EP1CNT0:                            EQU 0x4f
USBUART_EP1CNT1:                            EQU 0x4e
USBUART_EP2MODE:                            EQU 0xc5
USBUART_EP2CNT0:                            EQU 0x51
USBUART_EP2CNT1:                            EQU 0x50
USBUART_EP3MODE:                            EQU 0xc6
USBUART_EP3CNT0:                            EQU 0x53
USBUART_EP3CNT1:                            EQU 0x52
USBUART_EP4MODE:                            EQU 0xc7
USBUART_EP4CNT0:                            EQU 0x55
USBUART_EP4CNT1:                            EQU 0x54

;--------------------------------------------------
; Endpoint 0 offsets (Table 9-2)
;--------------------------------------------------
bmRequestType:                              EQU 0
bRequest:                                   EQU 1
wValue:                                     EQU 2
wValueHi:                                   EQU 3
wValueLo:                                   EQU 2
wIndex:                                     EQU 4
wIndexHi:                                   EQU 5
wIndexLo:                                   EQU 4
wLength:                                    EQU 6
wLengthHi:                                  EQU 7
wLengthLo:                                  EQU 6

;--------------------------------------------------
; Request Types (Table 9-4)
;--------------------------------------------------
USB_GET_STATUS:                             EQU    0x00
USB_CLEAR_FEATURE:                          EQU    0x01
USB_SET_FEATURE:                            EQU    0x03
USB_SET_ADDRESS:                            EQU    0x05
USB_GET_DESCRIPTOR:                         EQU    0x06
USB_SET_DESCRIPTOR:                         EQU    0x07
USB_GET_CONFIGURATION:                      EQU    0x08
USB_SET_CONFIGURATION:                      EQU    0x09
USB_GET_INTERFACE:                          EQU    0x0A
USB_SET_INTERFACE:                          EQU    0x0B
USB_SYNCH_FRAME:                            EQU    0x0C

;--------------------------------------------------
; Descriptor Types (Table 9-5)
;--------------------------------------------------
DESCR_TYPE_DEVICE:                          EQU     1
DESCR_TYPE_CONFIG:                          EQU     2
DESCR_TYPE_STRING:                          EQU     3
DESCR_TYPE_INTERFACE:                       EQU     4
DESCR_TYPE_ENDPOINT:                        EQU     5
DESCR_TYPE_DEVICE_QUALIFIER:                EQU     6
DESCR_TYPE_OTHER_SPEED:                     EQU     7
DESCR_TYPE_INTERFACE_POWER:                 EQU     8

;--------------------------------------------------
; Feature Selectors (Table 9-6)
;--------------------------------------------------
USB_DEVICE_REMOTE_WAKEUP:                   EQU    0x01
USB_ENDPOINT_HALT:                          EQU    0x00
USB_TEST_MODE:                              EQU    0x02

;--------------------------------------------------
; USB Device Status (Figure 9-4)
;--------------------------------------------------
USB_DEVICE_STATUS_BUS_POWERED:              EQU   0x00
USB_DEVICE_STATUS_SELF_POWERED:             EQU   0x01
USB_DEVICE_STATUS_REMOTE_WAKEUP:            EQU   0x02

;--------------------------------------------------
; USB Endpoint Status (Figure 9-4)
;--------------------------------------------------
USB_ENDPOINT_STATUS_HALT:                   EQU    0x01

;--------------------------------------------------
; USB Endpoint Directions
;--------------------------------------------------
USB_DIR_IN:                                 EQU    0x80
USB_DIR_OUT:                                EQU    0x00
USB_DIR_UNUSED:                             EQU    0x7F

;--------------------------------------------------
; USB Endpoint Address Symbols
;--------------------------------------------------
EP0:                                        EQU    0x00
EP1:                                        EQU    0x01
EP2:                                        EQU    0x02
EP3:                                        EQU    0x03
EP4:                                        EQU    0x04

;--------------------------------------------------
; Control Endpoint States--These act as JACC jump values
;--------------------------------------------------
USB_TRANS_STATE_IDLE:                       EQU     0x00         ;
USB_TRANS_STATE_CONTROL_READ:               EQU     0x02         ;
USB_TRANS_STATE_CONTROL_WRITE:              EQU     0x04         ;
USB_TRANS_STATE_NO_DATA_CONTROL:            EQU     0x06         ;

;--------------------------------------------------
; Control Write flag values to indicate pending data changes
;--------------------------------------------------
USB_ADDRESS_CHANGE_PENDING:     EQU     0x01

;--------------------------------------------------
; Register Constants for USBUART
;--------------------------------------------------
USB_ADDR_ENABLE:                             EQU    0x80
USB_CNT_VALID:                               EQU    0x40
USB_CNT_TOGGLE:                              EQU    0x80
USB_PULLUP_ENABLE:                          EQU    0x04
USB_AUTO_DPDM:                               EQU    0x00
USB_REG_ENABLE:                              EQU    0x03
USB_PASS_THRU:                               EQU    0x02
USB_BUS_ACTIVITY:                            EQU    0x04

USB_MODE_DISABLE:                            EQU 0x00
USB_MODE_NAK_IN_OUT:                         EQU 0x01
USB_MODE_STATUS_OUT_ONLY:                    EQU 0x02
USB_MODE_STALL_IN_OUT:                       EQU 0x03
USB_MODE_RESERVED_0100:                      EQU 0x04
USB_MODE_ISO_OUT:                            EQU 0x05
USB_MODE_STATUS_IN_ONLY:                     EQU 0x06
USB_MODE_ISO_IN:                             EQU 0x07
USB_MODE_NAK_OUT:                            EQU 0x08
USB_MODE_ACK_OUT:                            EQU 0x09
USB_MODE_RESERVED_1010:                      EQU 0x0A
USB_MODE_ACK_OUT_STATUS_IN:                  EQU 0x0B
USB_MODE_NAK_IN:                             EQU 0x0C
USB_MODE_ACK_IN:                             EQU 0x0D
USB_MODE_RESERVED_1110:                      EQU 0x0E
USB_MODE_ACK_IN_STATUS_OUT:                  EQU 0x0F
USB_MODE_STALL_DATA_EP:                      EQU 0x80

;--------------------------------------------------
; LoadInEP Count Toggle (Argument values)
;--------------------------------------------------
USB_NO_TOGGLE:                               EQU 0x00
USB_TOGGLE:                                  EQU 0x01

;--------------------------------------------------
; FORCE J/K/SE0 (Argument values)
;--------------------------------------------------
USB_FORCE_J:                                 EQU 0xA0
USB_FORCE_K:                                 EQU 0x80
USB_FORCE_SE0:                               EQU 0xC0
USB_FORCE_NONE:                              EQU 0x00
USB_FORCE_STATE:                             EQU 0x01

;-----------------------------------------------
; Endpoint event flags
;-----------------------------------------------
NO_EVENT_ALLOWED:       equ               2
EVENT_PENDING:      equ               1
NO_EVENT_PENDING:   equ               0

IN_BUFFER_FULL:     equ               NO_EVENT_PENDING
IN_BUFFER_EMPTY:    equ               EVENT_PENDING
OUT_BUFFER_FULL:    equ               EVENT_PENDING
OUT_BUFFER_EMPTY:   equ               NO_EVENT_PENDING

;--------------------------------------------------
; USB Request Dispatch Functions, including overrides
;--------------------------------------------------
USB_NOT_SUPPORTED:  EQU 0x01
USB_UM_SUPPLIED:    EQU 0x02
USB_APP_SUPPLIED:   EQU 0x04

;--------------------------------------------------
; Device to host (d2h) Standard (std) Device (dev)
;--------------------------------------------------
USB_CB_SRC_d2h_std_dev_00: equ USB_UM_SUPPLIED
USB_CB_SRC_d2h_std_dev_01: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_dev_02: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_dev_03: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_dev_04: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_dev_05: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_dev_06: equ USB_UM_SUPPLIED
USB_CB_SRC_d2h_std_dev_07: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_dev_08: equ USB_UM_SUPPLIED

;--------------------------------------------------
; Host to device (h2d) Standard (std) Device (dev)
;--------------------------------------------------
USB_CB_SRC_h2d_std_dev_00: equ USB_NOT_SUPPORTED
USB_CB_SRC_h2d_std_dev_01: equ USB_UM_SUPPLIED
USB_CB_SRC_h2d_std_dev_02: equ USB_NOT_SUPPORTED
USB_CB_SRC_h2d_std_dev_03: equ USB_UM_SUPPLIED
USB_CB_SRC_h2d_std_dev_04: equ USB_NOT_SUPPORTED
USB_CB_SRC_h2d_std_dev_05: equ USB_UM_SUPPLIED
USB_CB_SRC_h2d_std_dev_06: equ USB_NOT_SUPPORTED
USB_CB_SRC_h2d_std_dev_07: equ USB_NOT_SUPPORTED
USB_CB_SRC_h2d_std_dev_08: equ USB_NOT_SUPPORTED
USB_CB_SRC_h2d_std_dev_09: equ USB_UM_SUPPLIED

;--------------------------------------------------
; Device to host (d2h) Standard (std) Interface (ifc)
;--------------------------------------------------
USB_CB_SRC_d2h_std_ifc_00: equ USB_UM_SUPPLIED
USB_CB_SRC_d2h_std_ifc_01: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_ifc_02: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_ifc_03: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_ifc_04: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_ifc_05: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_ifc_06: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_ifc_07: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_ifc_08: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_ifc_09: equ USB_NOT_SUPPORTED
USB_CB_SRC_d2h_std_ifc_10: equ USB_UM_SUPPLIED

;--------------------------------------------------
; Host to device (h2d) Standard (std) Interface (ifc)
;--------------------------------------------------
USB_CB_SRC_h2d_std_ifc_00: equ USB_NOT_SUPPORTED

;--------------------------------------------------
; Device to host (d2h) Standard (std) Endpoint (ep)
;--------------------------------------------------
USB_CB_SRC_d2h_std_ep_00: equ USB_UM_SUPPLIED

;--------------------------------------------------
; Host to device (h2d) Standard (std) Endpoint (ep)
;--------------------------------------------------
USB_CB_SRC_h2d_std_ep_00: equ USB_NOT_SUPPORTED
USB_CB_SRC_h2d_std_ep_01: equ USB_UM_SUPPLIED
USB_CB_SRC_h2d_std_ep_02: equ USB_NOT_SUPPORTED
USB_CB_SRC_h2d_std_ep_03: equ USB_UM_SUPPLIED

;-----------------------------------------------
; 1st Tier Dispatch--Standard Requests
;-----------------------------------------------
USB_CB_h2d_std_dev: equ 1
USB_CB_h2d_std_ifc: equ 1
USB_CB_h2d_std_ep:  equ 1
USB_CB_h2d_std_oth: equ 0
USB_CB_d2h_std_dev: equ 1
USB_CB_d2h_std_ifc: equ 1
USB_CB_d2h_std_ep:  equ 1
USB_CB_d2h_std_oth: equ 0

;-----------------------------------------------
; 1st Tier Dispatch--Class Requests
;-----------------------------------------------
USB_CB_h2d_cls_dev: equ 0
USB_CB_h2d_cls_ifc: equ 1
USB_CB_h2d_cls_ep:  equ 0
USB_CB_h2d_cls_oth: equ 0
USB_CB_d2h_cls_dev: equ 0
USB_CB_d2h_cls_ifc: equ 1
USB_CB_d2h_cls_ep:  equ 0
USB_CB_d2h_cls_oth: equ 0

;-----------------------------------------------
; 1st Tier Dispatch--Vendor Specific Requests
;-----------------------------------------------
USB_CB_h2d_vnd_dev: equ 0
USB_CB_h2d_vnd_ifc: equ 0
USB_CB_h2d_vnd_ep:  equ 0
USB_CB_h2d_vnd_oth: equ 0
USB_CB_d2h_vnd_dev: equ 0
USB_CB_d2h_vnd_ifc: equ 0
USB_CB_d2h_vnd_ep:  equ 0
USB_CB_d2h_vnd_oth: equ 0

;-----------------------------------------------
; 1st Tier Dispatch--Reserved Requests
;-----------------------------------------------
USB_CB_h2d_rsv_dev: equ 0
USB_CB_h2d_rsv_ifc: equ 0
USB_CB_h2d_rsv_ep:  equ 0
USB_CB_h2d_rsv_oth: equ 0
USB_CB_d2h_rsv_dev: equ 0
USB_CB_d2h_rsv_ifc: equ 0
USB_CB_d2h_rsv_ep:  equ 0
USB_CB_d2h_rsv_oth: equ 0

;-----------------------------------------------
; Transfer Completion Notification
;-----------------------------------------------
USB_XFER_IDLE:         equ      0x00
USB_XFER_STATUS_ACK:   equ      0x01
USB_XFER_PREMATURE:    equ      0x02
USB_XFER_ERROR:        equ      0x03

; This macro is used to allocate a completion status block
; for all Requests.  The macro parameter is used
; to prefix the two data elements.
USB_XFER_STATUS:       equ      0
USB_XFER_LENGTH:       equ      1
MACRO    USB_XFER_STATUS_BLOCK
    BLK    1    ; Completion Status
    BLK    2    ; Transfer Length
ENDM

;-----------------------------------------------
; Modify the supported requests by redefining
; them within the custom code area below
;-----------------------------------------------

   ;@PSoC_UserCode_BODY_1@ (Do not change this line.)
   ;---------------------------------------------------
   ; Insert your custom code below this banner
   ;---------------------------------------------------
   ;   NOTE: interrupt service routines must preserve
   ;   the values of the A and X CPU registers.

   ;---------------------------------------------------
   ; Insert your custom code above this banner
   ;---------------------------------------------------
   ;@PSoC_UserCode_END@ (Do not change this line.)

;-----------------------------------------------
; Has the user enabled any of the Vendor Specific Requests
;-----------------------------------------------
USBUART_VSR_SUPPORT: EQU 0
IF USB_CB_h2d_vnd_dev
USBUART_VSR_SUPPORT: EQU 1
ENDIF
IF USB_CB_h2d_vnd_ifc
USBUART_VSR_SUPPORT: EQU 1
ENDIF
IF USB_CB_h2d_vnd_ep
USBUART_VSR_SUPPORT: EQU 1
ENDIF
IF USB_CB_h2d_vnd_oth
USBUART_VSR_SUPPORT: EQU 1
ENDIF
IF USB_CB_d2h_vnd_dev
USBUART_VSR_SUPPORT: EQU 1
ENDIF
IF USB_CB_d2h_vnd_ifc
USBUART_VSR_SUPPORT: EQU 1
ENDIF
IF USB_CB_d2h_vnd_ep
USBUART_VSR_SUPPORT: EQU 1
ENDIF
IF USB_CB_d2h_vnd_oth
USBUART_VSR_SUPPORT: EQU 1
ENDIF

; end of file USBUART.inc
