;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: CSDINT.asm
;;  Version: 1.2, Updated on 2008/02/28 at 09:57:56
;;  Generated by PSoC Designer ver 4.3  b1884 : 29 July, 2006
;;
;;  DESCRIPTION: CSD User Module ISR implementation file for the
;;               21xxx PSoC family of devices.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "memory.inc"
include "CSD.inc"

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------

export _CSD_CMP_ISR
export _CSD_CNT_ISR

AREA InterruptRAM (RAM,REL,CON)

;@PSoC_UserCode_INIT@ (Do not change this line.)
;---------------------------------------------------
; Insert your custom declarations below this banner
;---------------------------------------------------

;------------------------
; Includes
;------------------------


;------------------------
;  Constant Definitions
;------------------------


;------------------------
; Variable Allocation
;------------------------


;---------------------------------------------------
; Insert your custom declarations above this banner
;---------------------------------------------------
;@PSoC_UserCode_END@ (Do not change this line.)

LSB:  equ  1
MSB:  equ  0

AREA UserModules (ROM, REL)
.LITERAL

CSD_MaxADC_Table:                               ; High (2^resolution-1)
  DB    0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF

.ENDLITERAL


;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_CMP_ISR
;
;  DESCRIPTION:
;  Interrupt Service Routine for the Analog Column.  If the interrupt is
;  enabled and the comparator trips the code execution will vector to this
;  ISR.
;
;-----------------------------------------------------------------------------
;
_CSD_CMP_ISR:

IF (CSD_WITH_PWM + CSD_WITH_PRS8)
    push    A

    mov     A, [CSD_bResolution]
    index   CSD_MaxADC_Table
    mov     [CSD_wADC_Result+MSB], A
    mov     [CSD_wADC_Result+LSB], 0xFF

    mov     A, reg[DEC_DH]
    push    A
    mov     A, reg[DEC_DL]
    sub     [CSD_wADC_Result+LSB], A
    pop     A
    sbb     [CSD_wADC_Result+MSB], A
    jnc     .End
    mov     [CSD_wADC_Result+MSB], 0
    mov     [CSD_wADC_Result+LSB], 0

.End:
    mov     [CSD_bADCStatus], 01h
    pop     A
ENDIF
   ;@PSoC_UserCode_BODY_2@ (Do not change this line.)
   ;---------------------------------------------------
   ; Insert your custom code below this banner
   ;---------------------------------------------------
   ;   NOTE: interrupt service routines must preserve
   ;   the values of the A and X CPU registers.


   ;---------------------------------------------------
   ; Insert your custom code above this banner
   ;---------------------------------------------------
   ;@PSoC_UserCode_END@ (Do not change this line.)

    reti

;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_CNT_ISR
;
;  DESCRIPTION:
;  Interrupt Service Routine for the Counter.
;
;-----------------------------------------------------------------------------
;
_CSD_CNT_ISR:

IF (CSD_WITH_PWM + CSD_WITH_PRS8)
ELSE
    dec     [CSD_bState]
if1:
    jc      endif1 ; no underflow
    reti
endif1:
    cmp     [CSD_fMode], 0
if2:
    jnz     endif2  ;leaving reset mode
    push    A                            ;read decimator
    mov     A, reg[DEC_DL]
    mov     [CSD_wADC_Result + LSB], A
    mov     A, reg[DEC_DH]
    mov     [CSD_wADC_Result + MSB], A
    mov     [CSD_fMode], 1
    mov     A, [CSD_bResolution]
    index   CSD_MaxADC_Table
    mov     [CSD_bState], A
    pop     A
    reti
endif2:
    ;This code runs at end of integrate
    push    A
    mov     A, reg[DEC_DL]
    sub     [CSD_wADC_Result + LSB], A
    mov     A, reg[DEC_DH]
    sbb     [CSD_wADC_Result + MSB], A

    mov     A, [CSD_bResolution]
    index   CSD_MaxADC_Table
    add     [CSD_wADC_Result + LSB], 0xFF
    adc     [CSD_wADC_Result + MSB], A

    mov     [CSD_bADCStatus], 01h

    pop     A
ENDIF
   ;@PSoC_UserCode_BODY_3@ (Do not change this line.)
   ;---------------------------------------------------
   ; Insert your custom code below this banner
   ;---------------------------------------------------
   ;   NOTE: interrupt service routines must preserve
   ;   the values of the A and X CPU registers.


   ;---------------------------------------------------
   ; Insert your custom code above this banner
   ;---------------------------------------------------
   ;@PSoC_UserCode_END@ (Do not change this line.)

   reti


;-----------------------------------------------------------------------------
; end of file CSDINT.asm
