;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   CSD.inc
;;  Version: 1.2, Updated on 2008/02/28 at 09:57:56
;;  Generated by PSoC Designer ???
;;
;;  DESCRIPTION:
;;    Assembler declarations for the CSD user module interface for the 24x94
;;    PSoC family of devices.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2006-2007. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

CSD_WITH_PWM:                          equ 00h
CSD_WITH_PRS8:                         equ 00h
CSD_REF_VALUE:                         equ 0x4
CSD_FEEDBACK_PIN:                      equ 0x10
CSD_FEEDBACK_P1_1:                     equ 0
CSD_FEEDBACK_P3_1:                     equ 1
CSD_FEEDBACK_P1_5:                     equ 2
CSD_FEEDBACK_P3_5:                     equ 4
CSD_FEEDBACK_P5_1:                     equ 8
CSD_FEEDBACK_P5_5:                     equ 0x10

CSD_CAPACITOR_PIN:                     equ 2
CSD_CAPACITOR_P0_5:                    equ 1
CSD_CAPACITOR_P0_7:                    equ 2

CSD_AUTORESET:                         equ 1

;--------------------------------------------------
; Constants for Scan Speed values
;--------------------------------------------------
CSD_FAST_SPEED:                        equ 0x01
CSD_NORMAL_SPEED:                      equ 0x02
CSD_SLOW_SPEED:                        equ 0x03

;--------------------------------------------------
; Constants for Resolution values
;--------------------------------------------------
CSD_MIN_RESOLUTION:                    equ 9
CSD_MAX_RESOLUTION:                    equ 16

;--------------------------------------------------
; Constants for CSD API's
;--------------------------------------------------

CSD_ButtonCount:                       equ 4h
CSD_SliderCount:                       equ 0h
CSD_TotalSensorCount:                  equ 4h

CSD_BUTTONS_EXIST:                     equ 4h
CSD_SLIDERS_EXIST:                     equ 0h

CSD_HYSTERESIS:                                  equ ah
CSD_Debounce:                                    equ 3h
CSD_LowBaselineReset:                            equ 32h

CSD_FINGER_THRESHOLD:                            equ 96h
CSD_NOISE_THRESHOLD:                             equ 14h
CSD_NEGATIVE_NOISE_THRESHOLD:                    equ 14h
CSD_BASELINE_UPDATE_THRESHOLD:                   equ 64h

;--------------------------------------------------
; Registers Address Constants for CSD
;--------------------------------------------------

CSD_CNT_FUNC_REG:                      equ 20h              ; CNT Function Reg
CSD_CNT_IN_REG:                        equ 21h              ; CNT Input Reg
CSD_CNT_OUT_REG:                       equ 22h              ; CNT Output Reg
CSD_CNT_COUNTER_REG:                   equ 20h              ; CNT Counter Reg
CSD_CNT_PERIOD_REG:                    equ 21h              ; CNT Period Reg
CSD_CNT_COMPARE_REG:                   equ 22h              ; CNT Compare Reg
CSD_CNT_CONTROL_REG:                   equ 23h              ; CNT Control Reg

CSD_PRS_FUNC_LSB_REG:                  equ 24h              ; PRS LSB Function Reg
CSD_PRS_IN_LSB_REG:                    equ 25h              ; PRS LSB Input Reg
CSD_PRS_OUT_LSB_REG:                   equ 26h              ; PRS LSB Output Reg
CSD_PRS_CONTROL_LSB_REG:               equ 27h              ; PRS LSB Control Reg
CSD_PRS_SHIFT_LSB_REG:                 equ 24h              ; PRS LSB Shift Reg
CSD_PRS_POLY_LSB_REG:                  equ 25h              ; PRS LSB Polynomial Reg
CSD_PRS_SEED_LSB_REG:                  equ 26h              ; PRS LSB Seed Reg

CSD_PRS_FUNC_MSB_REG:                  equ 28h              ; PRS MSB Function Reg
CSD_PRS_IN_MSB_REG:                    equ 29h              ; PRS MSB Input Reg
CSD_PRS_OUT_MSB_REG:                   equ 2ah              ; PRS MSB Output Reg
CSD_PRS_CONTROL_MSB_REG:               equ 2bh              ; PRS MSB Control Reg
CSD_PRS_SHIFT_MSB_REG:                 equ 28h              ; PRS MSB Shift Reg
CSD_PRS_POLY_MSB_REG:                  equ 29h              ; PRS MSB Polynimial Reg
CSD_PRS_SEED_MSB_REG:                  equ 2ah              ; PRS MSB Seed Reg

CSD_ACB_CONTROL0_REG:                  equ 75h              ; CMP Function Reg
CSD_ACB_CONTROL1_REG:                  equ 76h              ; CMP Function Reg
CSD_ACB_CONTROL2_REG:                  equ 77h              ; CMP Function Reg
CSD_ACB_CONTROL3_REG:                  equ 74h              ; CMP Function Reg



DR_OFFSET:                             equ 00h
DM0_OFFSET:                            equ 00h              ; Bank 1
DM1_OFFSET:                            equ 01h              ; Bank 1
DM2_OFFSET:                            equ 03h              ; Bank 0
MUX_OFFSET:                            equ MUX_CR0          ; Bank 1

;--------------------------------------------------
; CSD Macro 'Functions'
;--------------------------------------------------
macro CSD_EnableInt_M
   M8C_ClearIntFlag  INT_CLR1, CSD_CNT_INT_MASK ;   Clear posted interrupt
   M8C_EnableIntMask CSD_CNT_INT_REG, CSD_CNT_INT_MASK
endm

macro CSD_DisableInt_M
   M8C_DisableIntMask CSD_CNT_INT_REG, CSD_CNT_INT_MASK
endm
;--------------------------------------------------
macro CSD_Counter_Start_M
   or    reg[CSD_CNT_CONTROL_REG],  CSD_CNT_CONTROL_REG_START_BIT
endm

macro CSD_Counter_Stop_M
   and   reg[CSD_CNT_CONTROL_REG], ~CSD_CNT_CONTROL_REG_START_BIT
endm

macro CSD_Counter_EnableInt_M
   M8C_EnableIntMask CSD_CNT_INT_REG, CSD_CNT_INT_MASK
endm

macro CSD_Counter_DisableInt_M
   M8C_DisableIntMask CSD_CNT_INT_REG, CSD_CNT_INT_MASK
endm

;--------------------------------------------------
; Constants for CSD_CMP API's
;--------------------------------------------------
CSD_CMP_CMPIntReg:                     equ  0e0h
CSD_CMP_CMPIntMask:                    equ  04h

CSD_CMP_OFF:                           equ  0
CSD_CMP_ON:                            equ  1

;--------------------------------------------------
; Constants for CSD_Counter API's.
;--------------------------------------------------

CSD_CNT_CONTROL_REG_START_BIT:         equ 0x01             ; Control register start bit
CSD_CNT_INT_REG:                       equ 0x0e1
CSD_CNT_INT_MASK:                      equ 0x01

;--------------------------------------------------
; Constants for CSD_Counter user defined values
;--------------------------------------------------

CSD_CNT_PERIOD:                        equ 0xff
CSD_CNT_COMPARE_VALUE:                 equ 0x00

; end of file CSD.inc
