;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: CSD.asm
;;  Version: 1.2, Updated on 2008/02/28 at 09:57:56
;;  Generated by PSoC Designer ???
;;
;;  DESCRIPTION: CS User Module software implementation file
;;               for the 24x94 PSoC family of devices.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2006-2007. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "memory.inc"
include "GlobalParams.inc"
include "CSD.inc"

;-----------------------------------------------
;  Global Labels
;-----------------------------------------------

; Exported functions
export _CSD_Start
export  CSD_Start
export _CSD_Stop
export  CSD_Stop
export _CSD_SetScanMode
export  CSD_SetScanMode
export _CSD_ClearSensors
export  CSD_ClearSensors
export _CSD_wReadSensor
export  CSD_wReadSensor
export _CSD_wGetPortPin
export  CSD_wGetPortPin
export _CSD_EnableSensor
export  CSD_EnableSensor
export _CSD_DisableSensor
export  CSD_DisableSensor
export _CSD_ScanSensor
export  CSD_ScanSensor
export _CSD_ScanAllSensors
export  CSD_ScanAllSensors
export _CSD_SetRefValue
export  CSD_SetRefValue

; Exported variables
export  CSD_bSensorNum
export _CSD_bSensorNum
export  CSD_waSnsResult
export _CSD_waSnsResult
export  CSD_wADC_Result
export _CSD_wADC_Result
export  CSD_bResolution
export _CSD_bResolution

export  CSD_bADCStatus
export _CSD_bADCStatus

IF (CSD_WITH_PWM + CSD_WITH_PRS8)
ELSE
export _CSD_bState
export  CSD_bState
export _CSD_fMode
export  CSD_fMode
ENDIF

AREA bss

;@PSoC_UserCode_INIT@ (Do not change this line.)
;---------------------------------------------------
; Insert your custom declarations below this banner
;---------------------------------------------------

;------------------------
; User Includes
;------------------------


;------------------------
; User Constant Definitions
;------------------------


;------------------------
; User Variable Allocation
;------------------------


;---------------------------------------------------
; Insert your custom declarations above this banner
;---------------------------------------------------
;@PSoC_UserCode_END@ (Do not change this line.)


;-----------------------------------------------
; Variable Allocation
;-----------------------------------------------
AREA bss
_CSD_waSnsResult:                               ; Current raw results
 CSD_waSnsResult:                       BLK  (2*CSD_TotalSensorCount)

AREA InterruptRAM (RAM, REL, CON)

 CSD_wADC_Result:
_CSD_wADC_Result:                       BLK 2

 CSD_bADCStatus:
_CSD_bADCStatus:                        BLK 1

IF (CSD_WITH_PWM + CSD_WITH_PRS8)
ELSE
 CSD_bState:
_CSD_bState:                            BLK  1 ;State value of ADC count
 CSD_fMode:
_CSD_fMode:                             BLK  1 ;Integrate and reset mode.
ENDIF

 CSD_bBitMask:                          BLK  1 ; Temp bitmask byte
_CSD_bSensorNum:                               ; Current sensor to scan
 CSD_bSensorNum:                        BLK  1
_CSD_bResolution:
 CSD_bResolution:                       BLK  1


AREA UserModules (ROM, REL, CON)

LSB:  equ  1
MSB:  equ  0

;@PSoC_UserCode_BODY1@ (Do not change this line.)

;---------------------------------
; Tables for Scan Speed and Resolution
;---------------------------------
IF (CSD_WITH_PWM + CSD_WITH_PRS8)

CSD_PRS8_Poly:     equ     CSD_Poly

ELSE
.LITERAL

CSD_PRS_Poly_Table:
  DW    0x0D34, 0x0D34, 0x0D34, 0x13C8, 0x3DAE, 0x3DAE, 0x4400, 0xFD80, 0xFD80, 0xFD80, 0xFD80, 0xFD80  ;  PRS16 polynomials table

.ENDLITERAL
ENDIF


;@PSoC_UserCode_END@ (Do not change this line.)

.LITERAL

CSD_VC1_Table:
  DB    0x13, 0x13, 0x33, 0x73

CSD_MUX_Table:                                  ; Analog Mux Enables Register address
  DB    MUX_CR0, MUX_CR1, MUX_CR2, MUX_CR3, MUX_CR4, MUX_CR5

.ENDLITERAL


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_Start(void)
;
;  DESCRIPTION:
;  Connects external cap; sets up comparator
;  disables all possible analog mux bus
;  connections; shunts all sensor pins to ground.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    None
;
;  RETURNS:      None.
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_Start:
_CSD_Start:

    RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR 0 ; direct access ram will always be in interrupt ram area

    mov     [CSD_bNoiseThreshold], CSD_NOISE_THRESHOLD
    mov     [CSD_bNegativeNoiseThreshold], CSD_NEGATIVE_NOISE_THRESHOLD
    mov     [CSD_bBaselineUpdateThreshold], CSD_BASELINE_UPDATE_THRESHOLD
    mov     [CSD_bHysteresis], CSD_HYSTERESIS
    mov     [CSD_bDebounce], CSD_Debounce
    mov     [CSD_bLowBaselineReset], CSD_LowBaselineReset

IF (CSD_CAPACITOR_PIN & CSD_CAPACITOR_P0_5)
    or      reg[AMUXCFG], 0x17      ; Capacitor on P0.5  and muxbus clocked from Row0Broadcast
    mov     X, 00h                  ; Wizard bug workaround: connect modulator capacitor manually
    mov     A, 20h
    call    CSD_EnableSensor
ELSE
    or      reg[AMUXCFG], 0x27		; Capacitor on P0.7  and muxbus clocked from Row0Broadcast
    mov     X, 00h                  ; Wizard bug workaround: connect modulator capacitor manually
    mov     A, 80h
    call    CSD_EnableSensor
ENDIF

    M8C_SetBank1
IF  (CSD_FEEDBACK_PIN & (CSD_FEEDBACK_P1_5 | CSD_FEEDBACK_P3_5 | CSD_FEEDBACK_P5_5))
    mov     reg[CMP_GO_EN], 0x80		; CMP_Bus 1 -> GOO5
ELSE
    mov     reg[CMP_GO_EN], 0x40		; CMP_Bus 1 -> GOO1
ENDIF

    M8C_SetBank0

    or      reg[CSD_ACB_CONTROL1_REG], 0x40          ; Enable CompBus for CMP
    or      reg[CSD_ACB_CONTROL3_REG], 0x08          ; Start low power analog comparator

    mov     A, 2
    mov     X, 0xc
    call    CSD_SetScanMode

    M8C_SetBank1

IF (CSD_FEEDBACK_PIN)
IF (CSD_FEEDBACK_PIN & CSD_FEEDBACK_P3_1)
    or      reg[PRT3DM0], 0x02
    or      reg[PRT3DM1], 0x02
    M8C_SetBank0
    or      reg[PRT3DM2], 0x02
ENDIF
IF (CSD_FEEDBACK_PIN & CSD_FEEDBACK_P1_5)
    or      reg[PRT1DM0], 0x20
    or      reg[PRT1DM1], 0x20
    M8C_SetBank0
    or      reg[PRT1DM2], 0x20
ENDIF
IF (CSD_FEEDBACK_PIN & CSD_FEEDBACK_P3_5)
    or      reg[PRT3DM0], 0x20
    or      reg[PRT3DM1], 0x20
    M8C_SetBank0
    or      reg[PRT3DM2], 0x20
ENDIF
IF (CSD_FEEDBACK_PIN & CSD_FEEDBACK_P5_1)
    or      reg[PRT5DM0], 0x02
    or      reg[PRT5DM1], 0x02
    M8C_SetBank0
    or      reg[PRT5DM2], 0x02
ENDIF
IF (CSD_FEEDBACK_PIN & CSD_FEEDBACK_P5_5)
    or      reg[PRT5DM0], 0x20
    or      reg[PRT5DM1], 0x20
    M8C_SetBank0
    or      reg[PRT5DM2], 0x20
ENDIF
ELSE                              ; R at P1.1
    or      reg[PRT1DM0], 0x02
    or      reg[PRT1DM1], 0x02
    M8C_SetBank0
    or      reg[PRT1DM2], 0x02
ENDIF

    mov     A, CSD_REF_VALUE
    call    CSD_SetRefValue                        ; Set Ref Value

IF (CSD_WITH_PWM)
    mov     reg[CSD_PWM_PERIOD_REG], CSD_PWM_PERIOD ; Set PWM period
    or      reg[CSD_PWM_CONTROL_REG], 0x01         ; Start PWM
ENDIF

IF (CSD_WITH_PWM + CSD_WITH_PRS8)
ELSE
    mov     reg[CSD_CNT_PERIOD_REG], 0xFF
    or      reg[CSD_CNT_CONTROL_REG], 0x01         ; Start Counter
ENDIF

    call    CSD_ClearSensors                          ; Loop through all sensors and deactivates them

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_SetScanMode
;
;  DESCRIPTION:
;  Set clocking (VC1, VC2 etc)  accordig to required Scan Speed and Resolution
;  INPUT:
;  A - BYTE bSpeed  - scan speed code from 0 to 3
;  X - BYTE bResolution - resolution [9..14]
;
;  RETURNS:      None.
;  SIDE EFFECTS:
;    Uses CSD_wADC_Result variable as temporary registers
;
;-----------------------------------------------------------------------------
_CSD_SetScanMode:
 CSD_SetScanMode:

    RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR  0
    cmp     A, CSD_SLOW_SPEED + 1          ; if (bSpeed > SLOW_SPEED)  bSpeed = SLOW_SPEED
    jc      .SpeedOk
    mov     A, CSD_SLOW_SPEED
.SpeedOk:
    mov     [CSD_wADC_Result], A           ; _wADC_Result := bSpeed
    swap    A, X                                        ; A := bResolution
    cmp     A, CSD_MAX_RESOLUTION + 1      ; if (bResolution > MAX_RESOLUTION)  bResolution = MAX_RESOLUTION
    jc      .ResolutionOk
    mov     A, CSD_MAX_RESOLUTION
.ResolutionOk:
    sub     A, 8                                        ; Remove offset - now Resolution code is from 0 (or 1)
IF (CSD_WITH_PWM + CSD_WITH_PRS8)
    and     A, ~0x01                                    ; resolution could be even number only (for PWM conf)
ENDIF
    mov     [CSD_bResolution], A           ; store bResolution

IF (CSD_WITH_PWM + CSD_WITH_PRS8)
    add     A, 3                                        ; resolution 8 correspnds to decimation ratio code 3 (DEC_CR2)
    mov     [CSD_wADC_Result+1], A         ; save temporary
    M8C_SetBank1
    mov     A, reg[DEC_CR2]
    and     A, ~0x07
    or      A, [CSD_wADC_Result+1]
    mov     reg[DEC_CR2], A

    M8C_SetBank0
    and     reg[CSD_PRS_CONTROL_REG], ~0x01    ; stop the PRS8
    mov     reg[CSD_PRS_SEED_REG], 0x01        ; Seed := 1
    mov     reg[CSD_PRS_POLY_REG], CSD_PRS8_Poly
    or      reg[CSD_PRS_CONTROL_REG], 0x01     ; start the PRS8

ELSE
    M8C_SetBank0
    and     reg[CSD_PRS_CONTROL_LSB_REG], ~0x01    ;stop the PRS16
    mov     reg[CSD_PRS_SEED_LSB_REG], 0x01        ; Seed := 1
    mov     reg[CSD_PRS_SEED_MSB_REG], 0x00

    add     A, [CSD_wADC_Result]           ; A := Resolution + Speed
    asl     A                                           ; A := byte offset in PRS Poly table
    push    A
    inc     A
    index   CSD_PRS_Poly_Table             ; A := LSB poly
    mov     reg[CSD_PRS_POLY_LSB_REG], A
    pop     A
    index   CSD_PRS_Poly_Table             ; A := MSB poly
    mov     reg[CSD_PRS_POLY_MSB_REG], A

    or      reg[CSD_PRS_CONTROL_LSB_REG], 0x01    ;start the PRS16
ENDIF

    M8C_SetBank1

    mov     A, [CSD_wADC_Result]           ; A := bSpeed
    index   CSD_VC1_Table

IF (CSD_WITH_PWM + CSD_WITH_PRS8)
    and     A, 0xF0
    mov     [CSD_wADC_Result], A
    mov     A, reg[OSC_CR1]                             ; Set VC1
    and     A, 0x0F
    or      A, [CSD_wADC_Result]
ENDIF

    mov     reg[OSC_CR1], A


    M8C_SetBank0

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

.ENDSECTION


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_SetRefValue
;
;  DESCRIPTION:
;  Set reference voltage by adjusting compare value for PRS or PWM
;  INPUT:
;  A - BYTE bRefValue  - Ref voltage code from 0 to 8
;                        0 -> Ref = 1/4 * Vcc
;                        8 -> Ref = 3/4 * Vcc
;
;  RETURNS:      None.
;  SIDE EFFECTS:
;    Uses CSD_wADC_Result variable as temporary registers
;
;-----------------------------------------------------------------------------
_CSD_SetRefValue:
 CSD_SetRefValue:

    RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR 0

    cmp     A, 9
    jc      .ValueOk
    mov     A, 8
.ValueOk:
    add     A, 3
    asl     A
    asl     A
    asl     A
    asl     A
    mov     [CSD_wADC_Result], A
    mov     A, reg[CSD_ACB_CONTROL0_REG]
    and     A, 0x0F
    or      A, [CSD_wADC_Result]
    mov     reg[CSD_ACB_CONTROL0_REG], A

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_ClearSensors(void)
;
;  DESCRIPTION:
;    Clears all sensor connections to the analog mux bus and shunts all sensor
;    pins to ground.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      None
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_ClearSensors:
_CSD_ClearSensors:
   RAM_PROLOGUE RAM_USE_CLASS_4
   mov   A,CSD_TotalSensorCount
   dec   A
.InitLoop:                                              ; Loop through all sensors and deactivate
   push  A
   call  CSD_wGetPortPin
   call  CSD_DisableSensor
   pop   A
   dec   A
   jnc   .InitLoop
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_Stop(void)
;
;  DESCRIPTION:
;  Disables RO interrupt; disables the relaxation oscillator circuitry;
;  clears scan active flag; disables all sensors and shunts them to ground.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      Nothing.
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_Stop:
_CSD_Stop:
    RAM_PROLOGUE RAM_USE_CLASS_4

    M8C_SetBank1

IF  (CSD_FEEDBACK_PIN & (CSD_FEEDBACK_P1_5 | CSD_FEEDBACK_P3_5 | CSD_FEEDBACK_P5_5))
    and     reg[CMP_GO_EN], ~0x80       ; Disconnect CMP bus from GOO
ELSE
    and     reg[CMP_GO_EN], ~0x40
ENDIF

    M8C_SetBank0

IF (CSD_WITH_PWM)
    and     reg[CSD_PWM_CONTROL_REG], ~0x01                          ; Stop PWM
    and     reg[CSD_PRS_CONTROL_REG], ~0x01                          ; stop the PRS8
ENDIF

IF (CSD_WITH_PWM + CSD_WITH_PRS8)
ELSE
    and     reg[CSD_PRS_CONTROL_LSB_REG], ~0x01                      ; Stop the PRS16
ENDIF

    call    CSD_ClearSensors                                         ; Loop through all keys and deactivate

    and     reg[CSD_ACB_CONTROL1_REG], ~0x40                         ; Disable CompBus for CMP
    and     reg[CSD_ACB_CONTROL3_REG], ~0x08                         ; Stop LP analog comparator

    and     reg[AMUXCFG], 0xC0                                         ; Disable external cap

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_wGetPortPin(BYTE bSensor)
;
;  DESCRIPTION:
;      Returns the port and pin mask from a given key number.  This function
;      uses the table CSD_Sensor_Table to retreive this
;      information.
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;        A => Sensor Number  ( 0 to n )
;  RETURNS:
;        A  <=  Sensor Bitmap
;        X  <=  Port Number
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_wGetPortPin:
_CSD_wGetPortPin:

  RAM_PROLOGUE RAM_USE_CLASS_1
   asl    A                                      ; multiply key by 2 since table is 2 bytes per key
   mov    X,A                                    ; Copy index*2 in x for next value
   index  CSD_Sensor_Table                       ; A contains the port value
   swap   A,X                                    ; Place port value in X and index*2 in A
   inc    A                                      ; Advance to next value (bitMask)
   index  CSD_Sensor_Table                       ; A contains bitMask, X has port number

   RAM_EPILOGUE RAM_USE_CLASS_1
   ret

.ENDSECTION


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_EnableSensor(BYTE bSensorMask, BYTE bPort)
;
;  DESCRIPTION:
;    Configures sensor to be an input to be measure duirng next measurement
;    cycle.  This function does not clear the last sensor.
;    Place key port in Analog Hi-Z mode and enables the correct mux input.
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;          X =>  Port Number for given key
;          A =>  Bit mask for given sensor
;
;  RETURNS:      none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;

 CSD_EnableSensor:
_CSD_EnableSensor:
	RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR 0
                                                 ; Setup Mux for sensor
    mov  [CSD_bBitMask],A                        ; Store bit mask in temp location
    push X
    mov  A,X                                     ; Multiply port number by four for registor addresses
    asl  A
    asl  A
    mov  X,A                                     ; Restore Port address in X
                                                 ; Set mode do 110  (Hi-Z Analog)
    mov  A,reg[X+DM2_OFFSET]                     ; Set DM2 to 1
    or   A,[CSD_bBitMask]
    mov  reg[X+DM2_OFFSET],A
   	M8C_SetBank1
    mov  A,reg[X+DM1_OFFSET]                     ; Set DM1 to 1
    or   A,[CSD_bBitMask]
    mov  reg[X+DM1_OFFSET],A
    xor  [CSD_bBitMask],FFh                      ; Invert bitmask
    mov  A,reg[X+DM0_OFFSET]                     ; Clear DM0 bit to 0
    and  A,[CSD_bBitMask]
    mov  reg[X+DM0_OFFSET],A

    pop  A
    index CSD_MUX_Table
    mov  X, A
    xor  [CSD_bBitMask],FFh                      ; Invert bitmask
    mov  A,reg[X]
    or   A,[CSD_bBitMask]
    mov  reg[X],A
	M8C_SetBank0

	RAM_EPILOGUE RAM_USE_CLASS_4
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_DisableSensor(BYTE bMask, BYTE bPort)
;
;  DESCRIPTION:
;    Disconnects the desired sensor from the analog mux bus and shunts to
;    ground.
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;          X =>  Port Number for given key
;          A =>  Bit mask for given sensor
;
;  RETURNS:      none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_DisableSensor:
_CSD_DisableSensor:
	RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR 0

    push X                                       ; Store Port Number
                                                 ; Disconnect sensor from mux
    cpl  A                                       ; Invert bitmask
    mov  [CSD_bBitMask],A                        ; Store bit mask in temp location
   	M8C_SetBank1
    mov  A, X
    index  CSD_MUX_Table
    mov  X, A
    mov  A,reg[X]
    and  A,[CSD_bBitMask]
    mov  reg[X],A
   	M8C_SetBank0

    pop  A                                       ; restore Port Number
    asl  A                                       ; Multiply port number by for for registor addresses
    asl  A
    mov  X,A                                     ; Restore Port address in X

                                                 ; Set mode do 001  (Digital Strong)
    mov  A,reg[X+DM2_OFFSET]                     ; Set DM2 to 0
    and  A,[CSD_bBitMask]
    mov  reg[X+DM2_OFFSET],A

   	M8C_SetBank1
    mov  A,reg[X+DM1_OFFSET]                     ; Set DM1 to 0
    and  A,[CSD_bBitMask]
    mov  reg[X+DM1_OFFSET],A

    xor  [CSD_bBitMask],FFh                      ; Invert bitmask back to normal
    mov  A,reg[X+DM0_OFFSET]                     ; Set DM0 bit to 1
    or   A,[CSD_bBitMask]
    mov  reg[X+DM0_OFFSET],A
	M8C_SetBank0

	RAM_EPILOGUE RAM_USE_CLASS_4
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_ScanSensor(BYTE bStrtIdx)
;
;  DESCRIPTION:
;  Uses the CapSense switching circuitry to charge to the starting voltage.
;  Then a fixed slope ramp is used to measure the starting voltage with a
;  16 bit timer.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;      A  => Sensor Index
;
;  RETURNS:      None
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_ScanSensor:
_CSD_ScanSensor:
    RAM_PROLOGUE RAM_USE_CLASS_3
    RAM_SETPAGE_CUR 0
    RAM_X_POINTS_TO_INDEXPAGE

    mov     [CSD_bSensorNum], A
    call    CSD_wGetPortPin
    call    CSD_EnableSensor

    mov     A, 0
    mov     [CSD_bADCStatus], A

IF (CSD_WITH_PWM + CSD_WITH_PRS8)
ELSE
    mov     [CSD_fMode], A
    mov     [CSD_bState], A
    M8C_SetBank1
    and     reg[DEC_CR2], 3Fh
    or      reg[DEC_CR2], 40h                      ; set to incremental Mode
ENDIF
    M8C_SetBank0

    CSD_EnableInt_M

IF (CSD_WITH_PWM + CSD_WITH_PRS8)
    mov     X, 2                                   ; skip 2 measurements
ELSE
    mov     X, A                                   ; do not skip measurements
ENDIF

.L1:
    mov     A, [CSD_bADCStatus]
    jz      .L1
    mov     [CSD_bADCStatus], 0
    dec     X
    jnc     .L1

    CSD_DisableInt_M

    mov     A, [CSD_bSensorNum]
    asl     A                                        ; Multiply by two since results are INTs
    mov     X, A

    RAM_SETPAGE_IDX >CSD_waSnsResult
    mov     A,[CSD_wADC_Result + LSB]
    mov     [X+(CSD_waSnsResult+LSB)], A

    mov     A, [CSD_wADC_Result + MSB]
    mov     [X+(CSD_waSnsResult+MSB)], A

    mov     A, [CSD_bSensorNum]
    call    CSD_wGetPortPin
    call    CSD_DisableSensor

    RAM_EPILOGUE RAM_USE_CLASS_3
    ret

.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_ScanAllSensors(void)
;
;  DESCRIPTION:
;    Scans all sensors to find their raw count values
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:    None.
;  RETURNS:      None
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16
;    functions.
;
 CSD_ScanAllSensors:
_CSD_ScanAllSensors:
   RAM_PROLOGUE RAM_USE_CLASS_4
   mov   A,CSD_TotalSensorCount                       ; Check if key value in range.
   dec   A
.ScanLoop:                                            ; Loop through all sensors and scan
   push  A
   call  CSD_ScanSensor
   pop   A
   dec   A
   jnc   .ScanLoop
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: CSD_wReadSensor(BYTE bSensor)
;
;  DESCRIPTION:
;     Returns the sensor scan value in A (LSB) and X (MSB)
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A = Sensor number
;  RETURNS:
;    Scan value of sensor LSB in A and MSB in X
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to preserve their values across calls to fastcall16
;    functions.
;
 CSD_wReadSensor:
_CSD_wReadSensor:
   RAM_PROLOGUE RAM_USE_CLASS_3
   RAM_SETPAGE_IDX >CSD_waSnsResult
   asl   A                                            ; Multiply by two since results are INTs
   mov   X,A
   mov   A,[X+(CSD_waSnsResult+LSB)]
   mov   X,[X+(CSD_waSnsResult+MSB)]
   RAM_EPILOGUE RAM_USE_CLASS_3
   ret
.ENDSECTION

