;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: USBUARTmacros.inc
;;   Version: 1.0, Updated on 2008/04/07 at 12:05:03
;;  Generated by PSoC Designer ???
;;
;;  DESCRIPTION: Macros supporting the USB user module interface
;;               for the enCore II family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2006. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

;--------------------------------------------------
; Constants for USBUART API's.
;--------------------------------------------------

;--------------------------------------------------
; MACROs for Debugging
; TODO: Remove for production
;--------------------------------------------------

MACRO GET_REG
IF TEST_BENCH
    mov     a,[@0]                           ; Get the simulated reg
ELSE
    mov     a,reg[@0]                        ; Get the real reg
ENDIF    
ENDM    

MACRO PUT_REG
IF TEST_BENCH
    mov     [@0],a                           ; Set the simulated reg
ELSE
    mov     reg[@0],a                        ; Set the real reg
ENDIF    
ENDM    

MACRO PUT_REG_CONST
IF TEST_BENCH
    mov     [@0],@1                          ; Set the simulated reg
ELSE
    mov     reg[@0],@1                       ; Set the real reg
ENDIF    
ENDM    

;--------------------------------------------------
; GET_WORD MACRO
;--------------------------------------------------
; Parameters:
;   None
; Register setup
;   A = ROM Source Address MSB 
;   X = ROM Source Address LSB 
MACRO   GET_WORD
	RAM_X_POINTS_TO_STACKPAGE	             ; Since called by interrupt we can call this
    PUSH A                              ; Quickly get a RAM temp
    PUSH A                              ; Save the source MSB
    ROMX                                ; Get the first byte
    PUSH X                              ; Save X
    MOV  X,SP                           ; Get SP, to index to the temp 
    MOV  [X - 3],A                      ; Save the first byte
    POP  X                              ; Get back the source LSB
    POP  A                              ; And the MSB
    INC  X                              ; Point to the second byte
    ADC  A, 0                           ; 
    ROMX                                ; Get the second byte
    MOV  X,A                            ; Save it in X
    POP  A                              ; And the first byte in A
    RAM_CHANGE_PAGE_MODE 00             ; Reset stack mode back
ENDM

;--------------------------------------------------
; NULL_PTR_CHECK MACRO
;--------------------------------------------------
; Parameters:
;   Address to jump to on a NULL Pointer
; Register setup
;   A = ROM Address MSB 
;   X = ROM Address LSB 
MACRO   NULL_PTR_CHECK
    SWAP    A, X                        ; LSB non-zero?
    JNZ     .ok                         ; Exit on non-zero
    SWAP    A, X                        ; MSB zero
    JZ      @0                          ; Jump to the null pointer handler
    JMP     .exit
.ok:
    SWAP    A, X                        ; Put them back
.exit:
ENDM

NULL_PTR:   EQU 0                       ; Null pointer value

;--------------------------------------------------
; Transfer Descriptor--Data Source
;--------------------------------------------------
USB_DS_ROM:                                      EQU 0x00
USB_DS_RAM:                                      EQU 0x01
USB_DS_RAM_CB:                                   EQU 0x02
USB_DS_RAM_MASK:                                 EQU 0x03

;--------------------------------------------------
; TRANSFER DESCRIPTOR MACROS
;--------------------------------------------------

;-----------------------------------------------
; TD_START_TABLE MACRO
;-----------------------------------------------
; Parameters:
;   @0 = Number of table entries
; Register setup
;   N/A (builds ROM data at assembly time)
;-----------------------------------------------
MACRO   TD_START_TABLE
    DB      ((@0) - 1)                 ; Number of table entries - 1
ENDM
;-----------------------------------------------
; TD_START_TABLE MACRO
;-----------------------------------------------
; Parameters:
;   @0 = Data source (USB_DATA_SRC_*)
;   @1 = Transfer size
;   @2 = Data source address
;   @3 = Transfer Completion Status Block Address
; Register setup
;   N/A (builds ROM data at assembly time)
;-----------------------------------------------
MACRO   TD_ENTRY
    DB  @0                             ; Data source (USB_DS_*)
    DW  @1                             ; Transfer size
    DW  @2                             ; Data source address
    DW  @3                             ; Transfer Completion Status Block Address
    DB  0xde                           ; Reserved 
ENDM
TD_ENTRY_SIZE:                         EQU 8
TD_START_SIZE:                         EQU 1
;-----------------------------------------------
; TD_INDEX_TO_OFFSET MACRO
;-----------------------------------------------
; Parameters:
;   @0 = RAM address of Index
; Register setup
;   A = DC (restored)
;   X = DC (not used)
;--------------------------------------------------
MACRO   TD_INDEX_TO_OFFSET
    PUSH    A                          ; Save a work register
    ASL     [@0]                       ; Index * 2
    ASL     [@0]                       ; Index * 4
    ASL     [@0]                       ; Index * 8
    POP     A                          ; Restore the work register
ENDM

;--------------------------------------------------
; LOOKUP TABLE MACROS
;--------------------------------------------------
;--------------------------------------------------
; LT_START
;--------------------------------------------------
; Start a lookup table
; Parameters:
;   @0 Table Size
; Register setup
;   N/A (builds ROM data at assembly time)
;--------------------------------------------------
MACRO LT_START
    DB      (@0)                       ; Table size
ENDM

;--------------------------------------------------
; LT_ENTRY
;--------------------------------------------------
; Insert a lookup table entry
; Parameters:
;   @0 Table entry 0
;   @1 Table entry 1
; Register setup
;   N/A (builds ROM data at assembly time)
;--------------------------------------------------
MACRO LT_ENTRY
    DW      (@0)                       ; Table entry
    DW      (@1)                       ; Table entry
ENDM
LT_ENTRY_SIZE:                         EQU 2
LT_START_SIZE:                         EQU 1

;-----------------------------------------------
; LT_INDEX_TO_OFFSET MACRO
;-----------------------------------------------
; Parameters:
;   @0 = RAM address of Index
; Register setup
;   A = DC (not used)
;   X = DC (not used)
;--------------------------------------------------
MACRO   LT_INDEX_TO_OFFSET
    ASL     [@0]                       ; Simply shift (mult by 2)
    ASL     [@0]                       ;              (mult by 4)
ENDM
;--------------------------------------------------
; DISPATCH Macros
;--------------------------------------------------
;--------------------------------------------------
; DISPATCHER MACRO
;--------------------------------------------------
; Dispatch through JACC Instruction
; Parameters:
;   @0 Address of the jump table
;   @1 Jump Table Size
;   @2 Address of the index out of range handler
; Register setup
;   A = Function Index
;--------------------------------------------------
MACRO DISPATCHER
    CMP   A,@1
    JNC   .dispatch_not_supported
    ASL   A
    JACC  @0
.dispatch_not_supported:
    LJMP  @2    
ENDM

;--------------------------------------------------
; USB Request Dispatch Functions, including overrides
;--------------------------------------------------
USB_NOT_SUPPORTED:  EQU 0x01
USB_UM_SUPPLIED:    EQU 0x02
USB_APP_SUPPLIED:   EQU 0x04
; end of file USBUART_macro.inc
