//*****************************************************************************
//*****************************************************************************
//  FILENAME: CSD.h
//  Version: 1.2, Updated on 2008/02/28 at 09:57:56
//  Generated by PSoC Designer ???
//
//  DESCRIPTION: CSD User Module C Language interface file for the 21x34 PSoC
//               family of devices
//-----------------------------------------------------------------------------
//  Copyright (c) Cypress Semiconductor 2006-2007. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************

#include <m8c.h>

//--------------------------------------------------
// Constants for CSD
//--------------------------------------------------

#define CSD_TotalSensorCount                      0x4
#define CSD_ButtonCount                           0x4
#define CSD_SliderCount                           0x0

#define CSD_BUTTONS_EXIST                         0x4
#define CSD_SLIDERS_EXIST                         0x0

//--------------------------------------------------
// Constants for Scan Speed values
//--------------------------------------------------
#define CSD_FAST_SPEED                            0x01
#define CSD_NORMAL_SPEED                          0x02
#define CSD_SLOW_SPEED                            0x03
#define CSD_SCANNING_SPEED                        0x2

//--------------------------------------------------
// Constants for Thresholds values
//--------------------------------------------------
#define CSD_FINGER_THRESHOLD                      0x28h
#define CSD_NOISE_THRESHOLD                       0x14h
#define CSD_BASELINE_UPDATE_THRESHOLD             0xc8h
#define CSD_HYSTERESIS                            0xa

//--------------------------------------------------
// Constants for Resolution values
//--------------------------------------------------
#define CSD_MIN_RESOLUTION                        9
#define CSD_MAX_RESOLUTION                        16
#define CSD_RESOLUTION                           0xc

//--------------------------------------------------
// Variables for CSD.
//--------------------------------------------------
extern BYTE CSD_bNoiseThreshold;
extern BYTE CSD_bNegativeNoiseThreshold;
extern BYTE CSD_bBaselineUpdateThreshold;
extern BYTE CSD_bHysteresis;
extern BYTE CSD_bDebounce;
extern BYTE CSD_bLowBaselineReset;

extern WORD CSD_waSnsResult[];
extern WORD CSD_waSnsBaseline[];
extern WORD CSD_waSnsDiff[];
extern BYTE CSD_baSnsOnMask[];

#if CSD_BUTTONS_EXIST
extern BYTE CSD_baBtnFThreshold[];
#endif

// Low Level scan API
#pragma fastcall16 CSD_Start
#pragma fastcall16 CSD_Stop
#pragma fastcall16 CSD_ScanSensor
#pragma fastcall16 CSD_ScanAllSensors
#pragma fastcall16 CSD_ClearSensors
#pragma fastcall16 CSD_wReadSensor
#pragma fastcall16 CSD_wGetPortPin
#pragma fastcall16 CSD_EnableSensor
#pragma fastcall16 CSD_DisableSensor
#pragma fastcall16 CSD_SetScanMode
#pragma fastcall16 CSD_SetRefValue

// High Level API
#pragma fastcall16 CSD_UpdateSensorBaseline
#pragma fastcall16 CSD_bIsSensorActive
#pragma fastcall16 CSD_bIsAnySensorActive
#pragma fastcall16 CSD_SetDefaultFingerThresholds
#pragma fastcall16 CSD_InitializeSensorBaseline
#pragma fastcall16 CSD_InitializeBaselines
#pragma fastcall16 CSD_UpdateAllBaselines
#pragma fastcall16 CSD_wGetCentroidPos

//-------------------------------------------------
// C prototypes of the CSD API.
//-------------------------------------------------

extern void CSD_Start(void);
extern void CSD_Stop(void);
extern void CSD_ScanSensor(BYTE bSensor);
extern void CSD_ScanAllSensors(void);
extern void CSD_ClearSensors(void);
extern WORD CSD_wReadSensor(BYTE bSensor);
extern WORD CSD_wGetPortPin(BYTE bSensor);
extern void CSD_EnableSensor(BYTE bMask, BYTE bPort);
extern void CSD_DisableSensor(BYTE bMask, BYTE bPort);
extern void CSD_SetScanMode(BYTE bSpeed, BYTE bResolution);
extern void CSD_SetRefValue(BYTE bRefValue);

//-------------------------------------------------
// High level functions
//-------------------------------------------------

extern void CSD_UpdateSensorBaseline(BYTE bSensorNum);
extern BYTE CSD_bIsSensorActive(BYTE bSensorNum);
extern BYTE CSD_bIsAnySensorActive(void);
extern void CSD_SetDefaultFingerThresholds(void);
extern void CSD_InitializeSensorBaseline(BYTE bSensorNum);
extern void CSD_InitializeBaselines(void);
extern void CSD_UpdateAllBaselines(void);
#if CSD_SLIDERS_EXIST
extern WORD CSD_wGetCentroidPos(BYTE bSnsGroup);
#endif

//-------------------------------------------------
// Register Addresses for CSD
//-------------------------------------------------
#pragma ioport  CSD_ACB_CONTROL0_REG:   0x075
BYTE            CSD_ACB_CONTROL0_REG;
#pragma ioport  CSD_ACB_CONTROL1_REG:   0x076
BYTE            CSD_ACB_CONTROL1_REG;
#pragma ioport  CSD_ACB_CONTROL2_REG:   0x077
BYTE            CSD_ACB_CONTROL2_REG;
#pragma ioport  CSD_ACB_CONTROL3_REG:   0x074
BYTE            CSD_ACB_CONTROL3_REG;

#pragma ioport  CSD_CNT_FUNC_REG:   0x120                  // CNT Function Register
BYTE            CSD_CNT_FUNC_REG;
#pragma ioport  CSD_CNT_IN_REG: 0x121                      // CNT Input Register
BYTE            CSD_CNT_IN_REG;
#pragma ioport  CSD_CNT_OUT_REG:    0x122                  // CNT Output Register
BYTE            CSD_CNT_OUT_REG;
#pragma ioport  CSD_CNT_COUNTER_REG:    0x020              // CNT Counter Register
BYTE            CSD_CNT_COUNTER_REG;
#pragma ioport  CSD_CNT_PERIOD_REG: 0x021                  // CNT Period Refister
BYTE            CSD_CNT_PERIOD_REG;
#pragma ioport  CSD_CNT_COMPARE_REG:    0x022              // CNT Compare Register
BYTE            CSD_CNT_COMPARE_REG;
#pragma ioport  CSD_CNT_CONTROL_REG:    0x023              // CNT Control Register
BYTE            CSD_CNT_CONTROL_REG;

#pragma ioport  CSD_PRS_FUNC_LSB_REG:   0x124              // PRS Function register LSB
BYTE            CSD_PRS_FUNC_LSB_REG;
#pragma ioport  CSD_PRS_FUNC_MSB_REG:   0x128              // PRS Function register MSB
BYTE            CSD_PRS_FUNC_MSB_REG;
#pragma ioport  CSD_PRS_IN_LSB_REG: 0x125                  // PRS Input register LSB
BYTE            CSD_PRS_IN_LSB_REG;
#pragma ioport  CSD_PRS_IN_MSB_REG: 0x129                  // PRS Input register MSB
BYTE            CSD_PRS_IN_MSB_REG;
#pragma ioport  CSD_PRS_OUT_LSB_REG:    0x126              // PRS Output register LSB
BYTE            CSD_PRS_OUT_LSB_REG;
#pragma ioport  CSD_PRS_OUT_MSB_REG:    0x12a              // PRS Output register MSB
BYTE            CSD_PRS_OUT_MSB_REG;
#pragma ioport  CSD_PRS_SHIFT_LSB_REG:  0x024              // PRS Shift register LSB
BYTE            CSD_PRS_SHIFT_LSB_REG;
#pragma ioport  CSD_PRS_SHIFT_MSB_REG:  0x028              // PRS Shift register MSB
BYTE            CSD_PRS_SHIFT_MSB_REG;
#pragma ioport  CSD_PRS_POLY_LSB_REG:   0x025              // PRS Polynomial register LSB
BYTE            CSD_PRS_POLY_LSB_REG;
#pragma ioport  CSD_PRS_POLY_MSB_REG:   0x029              // PRS Polynomial register MSB
BYTE            CSD_PRS_POLY_MSB_REG;
#pragma ioport  CSD_PRS_SEED_LSB_REG:   0x026              // PRS Seed register LSB
BYTE            CSD_PRS_SEED_LSB_REG;
#pragma ioport  CSD_PRS_SEED_MSB_REG:   0x02a              // PRS Seed register MSB
BYTE            CSD_PRS_SEED_MSB_REG;
#pragma ioport  CSD_PRS_CONTROL_LSB_REG:    0x027          // PRS Control register LSB
BYTE            CSD_PRS_CONTROL_LSB_REG;
#pragma ioport  CSD_PRS_CONTROL_MSB_REG:    0x02b          // PRS Control register MSB
BYTE            CSD_PRS_CONTROL_MSB_REG;
