/*************************************************************

   d s p _ k e r n e l . h

   Header file for the DSP Kernel

 *************************************************************/

#ifndef DSP_KERNEL_H
#define DSP_KERNEL_H

/* Definitions */

#define SAT_HIGH  30000 // Q15 High Saturation
#define SAT_LOW  -30000 // Q15 Low Saturation

/* External variable definitions */

// Function hooks
extern void (*sampleProcessingPtr)(q15_t,q15_t,q15_t*,q15_t*);
extern void (*blockProcessingPtr)(void);
extern void (*mainLoopPtr)(void);

// Counters for the saturation detection
extern volatile int32_t satCounter1;
extern volatile int32_t satCounter2;

// Pointers for block mode
//extern volatile int16_t *inp1;  // Pointer for channel 1 input
//extern volatile int16_t *inp2;  // Pointer for channel 2 input
//extern volatile int16_t *outp1; // Pointer for channel 1 output
//extern volatile int16_t *outp2; // Pointer for channel 2 output

// Block buffers as Q15 tyoes
extern volatile q15_t inbuff1[2*HBLOCK_SIZE];  // Input buffer for channel 1
extern volatile q15_t inbuff2[2*HBLOCK_SIZE];  // Input buffer for channel 2
extern volatile q15_t outbuff1[2*HBLOCK_SIZE]; // Output buffer for channel 1
extern volatile q15_t outbuff2[2*HBLOCK_SIZE]; // Output buffer for channel 2

// Pointers to Q15 objects for block mode
//volatile q15_t *inp1;  // Pointer for channel 1 input
//volatile q15_t *inp2;  // Pointer for channel 2 input
//volatile q15_t *outp1; // Pointer for channel 1 output
//volatile q15_t *outp2; // Pointer for channel 2 output

// Position in buffer for current block
extern volatile uint32_t blkStart;

// Binary semaphore for block mode
extern BinarySemaphore  blockSemaf;

/* Public functions */

void startDSP(void);        // Initialize and run the DSP kernel

q15_t pot1read(void);       // Read potentiometer 1
q15_t pot2read(void);       // Read potentiometer 2

#endif //DSP_KERNEL_H


