/*************************************************************

   c o n f i g u r a t i o n . h

   Firmware configuration header file

 *************************************************************/


/************ DSP Configuration ******************************

 The DSP configuration defines the main settings of the
 DSP Kernel

 If an ALIAS BW is not defined,
 clock won't be generate for this filter

 *************************************************************/

#define SAMPLE_FREQ    20000  // Sample frequency (in Hz)
#define ALIAS_BW1       8000  // Bandwidth for anti-alias input  filter (in Hz)
#define ALIAS_BW2       8000  // Bandwidth for anti-image output filter (in Hz)

//#define BLOCK_MODE            // Comment for sample to sample mode

// The following define has effect only in block mode
#define HBLOCK_SIZE    1024  // Number of samples to process by the block function
                             // It is half of the full buffer size
                             // In order to use FFT it has to be 1024

/******* Sample to Sample Processing Function ****************

 The sample to sample processing function will be executed
 for each sample
 It should be defined in processing.c and have a
 function prototype in processing.h
 This section has no effect in block mode

 *************************************************************/

#define PROC_FUNCTION identity



/********** Block mode Function ******************************

 The block function will be executed for each block
 It should be defined in processing.c and have a
 function prototype in processing.h
 This section has no effect in sample to sample mode

 *************************************************************/

#define BLOCK_FUNCTION blockIdentity
//#define BLOCK_FUNCTION blockFFT

/************ Loop Function ************************************

 The loop function will be executed after the DSP kernel starts
 The function shall never return
 Implement the low priority actions inside this function

 ***************************************************************/

#define LOOP_FUNCTION basicLoop
//#define LOOP_FUNCTION p3loop






