/***************************************************************

 D S P _ B o a r d _ 1 1 . h

 Description of DSP Board version 1.0

 v1.0 (26/ 6/2019)
 v1.1 (31/10/2019)

 Elements in this include file:

    - STM32F4 Disc-1 Board Peripherals

 ***************************************************************/

/************ PERIPHERALS ON STM32F4 DISCOVERY *****************/

/* Four active high LEDs on board                  */
/* Hal initialization in baseInit() configures the */
/* LEDs in output push-pull mode                   */

#define LEDS_PORT      GPIOD   // LEDs are on port D

#define GREEN_LED_PAD  12      // Green LED Pad  (Left)
#define ORANGE_LED_PAD 13      // Orange LED Pad (Up)
#define RED_LED_PAD    14      // Red LED Pad    (Right)
#define BLUE_LED_PAD   15      // Blue LED Pad   (Down)

#define GREEN_LED_BIT  (1<<12) // Green LED Bit  (Left)
#define ORANGE_LED_BIT (1<<13) // Orange LED Bit (Up)
#define RED_LED_BIT    (1<<14) // Red LED Bit    (Right)
#define BLUE_LED_BIT   (1<<15) // Blue LED Bit   (Down)

/* The board includes one user button                          */
/* There is a pull-down resistor so it is active at high level */
/* HAL initialization configures the button in input mode      */

#define BUTTON_PORT    GPIOA   // Button is on Port A
#define BUTTON_PAD     0       // Button Pad
#define BUTTON_BIT     1       // Button Bit

/* LIS3DSH  Accelerometer                                 */
/* It communicates using SPI channel #1                   */
/* Hal initialization configures SPI1 pads to communicate */
/* with the device.                                       */
/* It also configures the INT lines in input mode         */

#define SPI1_PORT       GPIOA
#define SPI1_SCK_PAD    5
#define SPI1_MOSI_PAD   7
#define SPI1_MISO_PAD   6

#define LIS_CS_PORT     GPIOE
#define LIS_CS_PAD      3
#define LIS_CS_BIT      (1<<3)

#define LIS_INT_PORT    GPIOE
#define LIS_INT1_PAD    0
#define LIS_INT2_PAD    1
#define LIS_INT1_BIT    (1)
#define LIS_INT2_BIT    (1<<1)

/* MP45DT02 Microphone                             */
/* It needs a clock input and generates signal     */
/* encoded in pulse density modulation (PDM)       */
/* The microphone can be read using I2S channel #2 */

#define MIC_CLK_PORT     GPIOB
#define MIC_CLK_PAD      10
#define MIC_CLK_BIT      (1<<10)

#define MIC_PDM_PORT     GPIOC
#define MIC_PDM_PAD      3
#define MIC_PDM_BIT      (1<<3)

/* PC3 can also be used to provide analog mono input at AIN4 */
/* In fact the mic output can be directly routed to AIN4     */
#define AUDIO_AIN4_PORT   GPIOC
#define AUDIO_AIN4_PAD    3
#define AUDIO_AIN4_BIT    (1<<3)

/* CS43L22 Audio DAC */
/* This device is an audio DAC with digital and analog    */
/* input that is connected to a 3.5mm earphone connection */
/* included in the board                                  */

// Reset line for the DAC is in PD4
#define AUDIO_RESET_PORT    GPIOD
#define AUDIO_RESET_PAD     4
#define AUDIO_RESET_BIT     (1<<4)

/* I2C channel #1 configuration port */
#define AUDIO_I2C1_PORT     GPIOB
#define AUDIO_I2C1_SCL_PAD  6
#define AUDIO_I2C1_SDA_PAD  9

/* I2S channel #3 provide digital audio input */
#define AUDIO_I2S3_PORT         GPIOC  // Main I2S3 port
#define AUDIO_I2S3_MCK_PAD      7      // Master clock
#define AUDIO_I2S3_SCK_PAD      10     // Serial clock
#define AUDIO_I2S3_SD_PAD       12     // Serial data

#define AUDIO_I2S3_LRCK_PORT    GPIOA   // WS (LR) Port
#define AUDIO_I2S3_LRCK_PAD     4       // WS (LR) Pad

/* PA4 can also be used to provide analog mono input at AIN1      */
/* That enables using the PA4 DAC output to generate analog sound */
/* but it cannot be done at the same time that I2S3 is operating  */
/* as PA4 is also used to generate the WS signal                  */
#define AUDIO_AIN1_PORT    GPIOA   // AIN1 DAC Port
#define AUDIO_AIN1_PAD     4       // AIN1 DAC Pad
#define AUDIO_AIN1_BIT     (1<<4)  // AIN1 DAC Bit

// Serial pins used
#define USART2_TX_PORT GPIOA
#define USART2_TX_PAD  2
#define USART2_TX_AF   7
#define USART2_RX_PORT GPIOA
#define USART2_RX_PAD  3
#define USART2_RX_AF   7


/************ PERIPHERALS ON TRS DSP BOARD ************************/

/* ADC Inputs */

#define ADC1_PORT  GPIOC
#define ADC1_PAD       1
#define ADC1_IN       11  // Available on ADCs 1,2,3

#define ADC2_PORT  GPIOB
#define ADC2_PAD       1
#define ADC2_IN        9  // Available on ADCs 1,2

/* Potentiometers */

#define POT1_PORT  GPIOC
#define POT1_PAD       0
#define POT1_IN       10  // Available on ADCs 1,2,3

#define POT2_PORT  GPIOC
#define POT2_PAD       2
#define POT2_IN       12  // Available on ADCs 1,2,3

/* DAC Outputs */

#define DAC_PORT    GPIOA   // DAC Port
#define DAC1_PAD        4   // DAC Output 1 Pad
#define DAC2_PAD        5   // DAC Output 2 Pad

/* Profiling pins */

#define PRO1_PORT        GPIOE
#define PRO1_PAD             3

#define PRO2_PORT        GPIOE
#define PRO2_PAD             5

#define PRO3_PORT        GPIOC
#define PRO3_PAD            13

#define PRO4_PORT        GPIOC
#define PRO4_PAD            15

/* Antialias filter clocks */

#define CLOCK1_PORT      GPIOA
#define CLOCK1_PAD           1
#define CLOCK1_AF            2
#define CLOCK1_CHANNEL       2
#define CLOCK1_DRV       PWMD5

#define CLOCK2_PORT      GPIOB
#define CLOCK2_PAD          11
#define CLOCK2_AF            1
#define CLOCK2_CHANNEL       4
#define CLOCK2_DRV       PWMD2

/* Push button pins */
#define SW1_PORT       GPIOD      // SW1 is on Port D
#define SW1_PAD            6      // Pad
#define SW1_BIT       (1<<6)      // Bit

#define SW2_PORT       GPIOD      // SW2 is on Port D
#define SW2_PAD            2      // Pad
#define SW2_BIT       (1<<2)      // Bit

#define SW3_PORT       GPIOC      // SW2 is on Port C
#define SW3_PAD           11      // Pad
#define SW3_BIT      (1<<11)      // Bit

#define SW4_PORT       GPIOC      // SW2 is on Port C
#define SW4_PAD            9      // Pad
#define SW4_BIT       (1<<9)      // Bit

/**************** LED PSEUDOFUNCTIONS *****************/

#define GREEN_ON    (LEDS_PORT->BSRR.H.set)   = BIT(GREEN_LED_PAD)
#define GREEN_OFF   (LEDS_PORT->BSRR.H.clear) = BIT(GREEN_LED_PAD)

#define ORANGE_ON   (LEDS_PORT->BSRR.H.set)   = BIT(ORANGE_LED_PAD)
#define ORANGE_OFF  (LEDS_PORT->BSRR.H.clear) = BIT(ORANGE_LED_PAD)

#define RED_ON      (LEDS_PORT->BSRR.H.set)   = BIT(RED_LED_PAD)
#define RED_OFF     (LEDS_PORT->BSRR.H.clear) = BIT(RED_LED_PAD)

#define BLUE_ON     (LEDS_PORT->BSRR.H.set)   = BIT(BLUE_LED_PAD)
#define BLUE_OFF    (LEDS_PORT->BSRR.H.clear) = BIT(BLUE_LED_PAD)

/**************** BUTTONS PSEUDOFUNCTIONS *****************/

// True if user button is pushed
#define USER_BUTTON_ACTIVE  ((BUTTON_PORT->IDR)&(BUTTON_BIT))

#define SW1_ACTIVE  (!((SW1_PORT->IDR)&(SW1_BIT)))
#define SW2_ACTIVE  (!((SW2_PORT->IDR)&(SW2_BIT)))
#define SW3_ACTIVE  (!((SW3_PORT->IDR)&(SW3_BIT)))
#define SW4_ACTIVE  (!((SW4_PORT->IDR)&(SW4_BIT)))

/**************** PROFILING PSEUDOFUNCTIONS *****************/

#define PRO1_SET   (PRO1_PORT->BSRR.H.set)   = BIT(PRO1_PAD)
#define PRO1_CLEAR (PRO1_PORT->BSRR.H.clear) = BIT(PRO1_PAD)
#define PRO2_SET   (PRO2_PORT->BSRR.H.set)   = BIT(PRO2_PAD)
#define PRO2_CLEAR (PRO2_PORT->BSRR.H.clear) = BIT(PRO2_PAD)
#define PRO3_SET   (PRO3_PORT->BSRR.H.set)   = BIT(PRO3_PAD)
#define PRO3_CLEAR (PRO3_PORT->BSRR.H.clear) = BIT(PRO3_PAD)
#define PRO4_SET   (PRO4_PORT->BSRR.H.set)   = BIT(PRO4_PAD)
#define PRO4_CLEAR (PRO4_PORT->BSRR.H.clear) = BIT(PRO4_PAD)

