/*
 uart6_tx.c
 Use of the serial port for debugging
 USART 6 TX will be used in async mode (UART)
 */

#include "Base.h"           // Basic definitions
#include "chprintf.h"	    // Printf module
#include "uart6_tx.h"    // This module header file

//  Serial port configuration
SerialConfig Serial6Config;



// Starts serial port 6
void uart6start(void)
 {
	// Starts seria port at 38400 Baud
	Serial6Config.speed = 38400;					//Beware documentation says "sc_speed"
	sdStart((SerialDriver *)&SD6,&Serial6Config);	//Configures and starts the driver. Parameters sdp: pointer to SerialDriver; config: serial driver configuration

	// Configures TX pin multiplexing
	palSetPadMode(DEBUG_PORT,DEBUG_TX_PIN, PAL_MODE_ALTERNATE(8));

	// Writes a message on serial port
	//(BaseSequentialStream *)
	chprintf(SDEBUG,"%sUART6 TX Started%s%s",BREAK,BREAK,BREAK);
 }

