/*
   main.c
   Main C source file
   Test for UART6_Tx
 */

#include "Base.h"           // Basic definitions
#include "chprintf.h"       // ChibiOS/RT chprintf function
#include "uart6_tx.h"       // Serial debug header file

// Serial debug TX test
// This function never returns
static void serialTXtest(void)
 {
 int32_t i=20;
 char *testString="This is a test string \r\n";
 char *pointer;

 // Test of chprintf
 chprintf(SDEBUG,"Test using chprintf%s",BREAK);

 // Test of chprintf with a numeric value
 chprintf(SDEBUG,"This is an integer number: %d%s",i,BREAK);

 // Test of low level character write

 // Set pointer to start of string
 pointer=testString;

 // Loop while final 0 not reached
 while ((*pointer)!=0)
        {
	    // Low level character print function
	    // We use infinite timeout (blocking operation)
	    chnPutTimeout(BASEDEBUG,*pointer,TIME_INFINITE);

	    // Increase string pointer
	    pointer++;
        }

 // Infinite string print loop

 i=1;
 chprintf(SDEBUG,"%s",BREAK);
 while (1)
  {
  chprintf(SDEBUG,"This message has been shown %d times%s",i++,BREAK);
  SLEEP_MS(1000);
  }
 }

int main(void)
 {
 // Global initializations
 baseInit();

 // Start the serial channel 6 TX
 uart6start();

 // Test the serial port (Never returns)
 serialTXtest();

 // Infinite loop
 while (1) {};

 // Main should never return
 // This line is included so that the compiler doesn't complain
 return 0;
 }

