/*
  GPT Timer file that provides a repetitive function call

  Timer 11 needs to be set in mcuconf.h to GPT mode

  #define STM32_GPT_USE_TIM11     TRUE // Use in repetitive calls

 */

// Include files

#include "ch.h"             // Main ChibiOS/RT include file
#include "hal.h"            // Main HAL include file
#include "timer.h"          // This module header file

/********************* GPT 11 *********************************/

// Timer GPT11 is configured to produce repetitive callback calls

// GPT11 configuration
static const GPTConfig gpt11cfg = {
  TIMER_CLOCK,     /* Timer clock */
  timerCallback,   /* Function Callback */
  0                /* Dier field */
};

/****************** Variables ********************************/

#define TIMER_ST_RESET  0  // Timer uninitialized
#define TIMER_ST_INIT   1  // Timer initialized
#define TIMER_ST_RUN    2  // Timer running

int32_t TimerStatus=TIMER_ST_RESET;   // Timer status

/****************** External functions ************************/


// Starts the timer operation
void timerStart()
 {
 if (TimerStatus==TIMER_ST_RUN)  // If timer is running
          {
	      gptStopTimer(&GPTD11); // Stop it
	      TimerStatus=TIMER_ST_INIT;
          }

 // Start the timer if needed
 if (TimerStatus==TIMER_ST_RESET)
          {
          gptStart(&GPTD11, &gpt11cfg);
          TimerStatus=TIMER_ST_INIT;
          }

 // Start in interval mode
 gptStartContinuous(&GPTD11,TIMER_TICKS);
 TimerStatus=TIMER_ST_RUN;
 }

// Stops the timer operation
void timerStop(void)
 {
 //Check if timer is running
 if (TimerStatus!=TIMER_ST_RUN) return;

 // Stop the timer
 gptStopTimer(&GPTD11);
 }


