/*
   main.c
   Main C source file
   Test for UART6_Tx

   History:
      2015/02/27 : First version
 */

#include "Base.h"           // Basic definitions
#include "timer.h"          // Timer definitions

void timerCallback(GPTDriver *gptp)
 {
 UNUSED(gptp); // Included so that the compiler doesn't complain

 static uint32_t counter=0;

 counter++;

 // Fancy line that lights the LEDS using binary code
 // The LEDS change each 256 function calls
 (LEDS_PORT->ODR)=((LEDS_PORT->ODR)&0x0FFF)|(((counter/256)%16)<<GREEN_LED_PAD);

 }


int main(void)
 {
 // Global initializations
 baseInit();

 while (1)
      {
      // Start the timer
      timerStart();

      SLEEP_MS(2000);

      // Stop the timer
      timerStop();

      SLEEP_MS(2000);

      }

 // Infinite loop although it cannot be reached
 while (1) {};

 // Main should never return
 // This line is included so that the compiler doesn't complain
 return 0;
 }

