/*
 sd_spi.h
 Header file
 Driver for SD card interface using SPI mode
 */

#ifndef _SD_SPI_TX
#define _SD_SPI_TX

/* I/O LINES DEFINITIONS

MCU   External Port 2 line   SD Card Line      SD Board    Cable color
----  --------------------   ------------     ----------   -----------
PD10  EXT2-1 : Card detect     *Detect           10         Orange
PB15  EXT2-2 : SPI2-MOSI       CMD / Din          3         Yellow + Red
PB13  EXT2-3 : SPI2-SCK        CLK / SCLK         6         Violet
PB14  EXT2-4 : SPI2-MISO       DAT0 / Dout        8         White + Red
PB12  EXT2-5 : NSS             DAT3 / CS          2         Pink
+3V   EXT2-6 : Vdd             VDD                5         Red + Brown
PC6   EXT2-8 : USART6-TX       ---               --         Blue
GND   EXT2-9 : GND             GND                4         Black
PA15  EXT2-11: W Protect       *Write            11         Grey

 */

#define DETECT_PORT  GPIOD
#define DETECT_PIN   10

#define WRITE_PORT   GPIOA
#define WRITE_PIN    15

#define SD_SPI_PORT  GPIOB
#define MOSI_PIN     15
#define SCLK_PIN     13
#define MISO_PIN     14
#define SD_CS_PIN    12

// Function prototypes

void sdDriverInit(void);
int32_t sdIsDetected(void);
int32_t sdIsWriteProtected(void);

#endif // sd_spi.h

