/*
 sd_spi.c
 Driver for SD card interface using SPI mode
 */

#include "Base.h"           // Basic definitions
#include "ff.h"             // Fat File System header file
#include "sd_spi.h"         // This module header file

// MMC Driver
MMCDriver MMCD1;

// FAT File System Object
FATFS MMC_FS;

// Maximum speed SPI configuration (18MHz, CPHA=0, CPOL=0, MSb first).
static SPIConfig hs_spicfg = {NULL, GPIOB, GPIOB_PIN12, 0};

// Low speed SPI configuration (281.250kHz, CPHA=0, CPOL=0, MSb first).
static SPIConfig ls_spicfg = {NULL, GPIOB, GPIOB_PIN12,SPI_CR1_BR_2 | SPI_CR1_BR_1};

// MMC/SD over SPI driver configuration.
static MMCConfig mmccfg = {&SPID2, &ls_spicfg, &hs_spicfg};

// Generic large buffer.
uint8_t fbuff[1024];

/*************** PUBLIC FUNCTIONS *********************/

// Initializes the driver
void sdDriverInit(void)
 {
 // Configure the I/O lines

 // Configure Card detect and Write Protect as normal inputs
 palSetPadMode(DETECT_PORT,DETECT_PIN,PAL_MODE_INPUT);
 palSetPadMode(WRITE_PORT,WRITE_PIN,PAL_MODE_INPUT);

 // Configures SPI2 Muxes
 palSetPadMode(SD_SPI_PORT,MOSI_PIN,PAL_MODE_ALTERNATE(5)|PAL_STM32_OSPEED_HIGHEST);
 palSetPadMode(SD_SPI_PORT,SCLK_PIN,PAL_MODE_ALTERNATE(5)|PAL_STM32_OSPEED_HIGHEST);
 palSetPadMode(SD_SPI_PORT,MISO_PIN,PAL_MODE_ALTERNATE(5)|PAL_STM32_OSPEED_HIGHEST);

 // Sets CS signal as open drain as the board provides a pull-up
 palSetPadMode(SD_SPI_PORT,SD_CS_PIN,PAL_MODE_OUTPUT_OPENDRAIN|PAL_STM32_OSPEED_HIGHEST);
 // Starts with card not selected
 SD_SPI_PORT->BSRR.H.set=BIT(SD_CS_PIN);

 //Initializes the MMC driver to work with SPI2.
 mmcObjectInit(&MMCD1);
 mmcStart(&MMCD1, &mmccfg);

 // Initialized the FAT File System functions
 }

// Test if the card is detected
// When Card is Detected the Detect line (PD10) reads "0"
//
// Return 1 if it is detected
//        0 if not detected
int32_t sdIsDetected(void)
 {
 if ((DETECT_PORT->IDR)&BIT(DETECT_PIN))
	         return 0;
            else
             return 1;
 }

// Test if the card is Write Protected
// When Card has Write enabled the Write Line (PA15) reads "0"
// When Card is Write protected the Write Line (PA15) reads "1"
// If no card is inserted it reads as Write Protected "1"
//
// Return 1 if card is Write Protected or not present
//        0 if card it is present and not Write Protected
int32_t sdIsWriteProtected(void)
 {
 if ((WRITE_PORT->IDR)&BIT(WRITE_PIN))
            return 1;
           else
            return 0;
 }

