/*
 Base.h
 Fitxer include principal
 Inclou:
    - Includes del HAL y del sistema operatiu
    - Definicions basiques de camps de bits
    - Definicions de la placa STM32F4 Discovery

 Dades adicionals:
    - La frequencia l'MCU es configura amb el PLL principal
      Les dades de configuracio es troben a mcuconf.h
      L'entrada al PLL es el relotge HSE de 8MHz
         fvco=fpll_in*PLLN/PLLM = 8MHz*336/8=336MHz
         HCLK=fpll_out=fvco/PLLP = 336MHz/2=168MHz
         fusb_sdio_rng=fvco/PLLQ = 336MHz/7=48MHz
    - La frequencia de relotge del bus APB1 depen de STM32_PPRE1
      El seu valor es STM32_PPRE1_DIV4 que correspon a
         HCLK/4 = 168MHz / 4 = 42 MHz
    - La frequencia de relotge del bus APB2 depen de STM32_PPRE2
      El seu valor es STM32_PPRE2_DIV2 que correspon a
         HCLK/2 = 168MHz / 2 = 84 MHz
    - La frequencia del relotge I2S s'obte del PLLI2S
      L'entrada d'aquest PLL es la matexa del PLL principal
         fvco=fpll_in*PLLI2SN/PLLM=8MHz*192/8=192MHz
         I2CCLK=fvco/PLLI2SR=192MHz/5=38.4MHz
*/

#ifndef _BASE_INCLUDE
#define _BASE_INCLUDE

// Altres includes necesaris

#include "ch.h"             // Include principal de ChibiOS
#include "hal.h"            // Include principal del HAL


/*************** Definicions del hardware inclos a la placa *************************/

// La placa te 4 leds accessibles al usuari
// Els leds son actius per nivell alt
#define LEDS_PORT      GPIOD   // Leds es troben al port D
#define GREEN_LED_PAD  12      // Pad del led Verd (Esquerra)
#define ORANGE_LED_PAD 13      // Pad del led Taronja (A dalt)
#define RED_LED_PAD    14      // Pad del led Vermell (Dreta)
#define BLUE_LED_PAD   15      // Pad del led Blau (A baix)

// La placa te un polsador d'usuari
// Te un pull-down per tant es actiu per nivell alt
#define BUTTON_PORT    GPIOA   // El polsador es troba al port A
#define BUTTON_PAD     0       // Pad del polsador

/************************ Altres Definicions ******************************************/

// Bits generics

#define BIT(n) (1<<(n))

// Bits en una paraula de 32 bits

#define BIT0   0x01
#define BIT1   0x02
#define BIT2   0x04
#define BIT3   0x08
#define BIT4   0x10
#define BIT5   0x20
#define BIT6   0x40
#define BIT7   0x80
#define BIT8   0x100
#define BIT9   0x200
#define BIT10  0x400
#define BIT11  0x800
#define BIT12  0x1000
#define BIT13  0x2000
#define BIT14  0x4000
#define BIT15  0x8000
#define BIT16  0x10000
#define BIT17  0x20000
#define BIT18  0x40000
#define BIT19  0x80000
#define BIT20  0x100000
#define BIT21  0x200000
#define BIT22  0x400000
#define BIT23  0x800000
#define BIT24  0x1000000
#define BIT25  0x2000000
#define BIT26  0x4000000
#define BIT27  0x8000000
#define BIT28  0x10000000
#define BIT29  0x20000000
#define BIT30  0x40000000
#define BIT31  0x80000000

// Definicions de bloqueig de ChibiOS

#define DISABLE  chSysLock()
#define ENABLE   chSysUnlock()

// Definiciones per retards

// Macro d'espera del nombre de microsegons
#define DELAY_US(x) gptDelayUs(x)

// Macro alternativa d'espera del nombre de microsegons
// Permet fer servir retards en un segon fil
#define DELAY_US2(x) gptDelayUs2(x)

// Macro per dormir el fil actual un nombre de milisegons
#define SLEEP_MS(x) chThdSleep(x)

/********************* PROTOTIPS DE FUNCIONES ******************/

// Inicialitzacio basica
// S'ha de cridar al principi de main( )
void baseInit(void);

// Prototip de la funcio de retard que fa servir GPT5
void gptDelayUs(uint32_t time);

// Prototip de la funcio de retard que fa servir GPT9
void gptDelayUs2(uint32_t time);

#endif // Base.h



