/*
 Base.c
 Funcions basiques
 */

#include "Base.h"           // Definicions Basiques

/********************* GPT 5 *********************************/

// El timer 5 (GPT5) es configura per realitzar retards curts


// Configura el timer 5 GPT5
static const GPTConfig gpt5cfg = {
  1000000,    /* Rellotge d'1MHz pel Timer 5 */
  NULL,       /* Sense Callback */
  0           /* Dier field */
};

// Funcio que retorna despres d'un temps
// La granularitat es de 10us
// El temps s'aproxima en passos de 10us per exces
//      time: Temps d'espera en microsegons
void gptDelayUs(uint32_t time)
 {
 uint32_t count;

 for(count=0;count<time;count+=10)
	 gptPolledDelay(&GPTD5,10);

 }

/********************* GPT 9 *********************************/

// El timer 9 (GPT9) es configura per realitzar retards curts
// de manera independent a GPT5
// S'han de fer servir dos temporitzadors independents
// per implementar retards en dos fils.

// Configura el timer 9 GPT5
static const GPTConfig gpt9cfg = {
  1000000,    /* Rellotge d'1MHz pel Timer 9 */
  NULL,       /* Sense Callback */
  0           /* Dier field */
};

// Funcio que retorna despres d'un temps
// La granularitat es de 10us
// El temps s'aproxima en passos de 10us per exces
//      time: Temps d'espera en microsegons
void gptDelayUs2(uint32_t time)
 {
 uint32_t count;

 for(count=0;count<time;count+=10)
	 gptPolledDelay(&GPTD9,10);

 }

/************** Inicialitzacio ****************************/

// Inicializacio general
void baseInit(void)
 {
 // Inicialitzacio del HAL
 halInit();

 // Inicializacio de l'RTOS Kernel
 chSysInit();

 // Inicialitza el temporitzador GPT 5
 gptStart(&GPTD5, &gpt5cfg);

 // Inicialitza el temporitzador GPT 9
  gptStart(&GPTD9, &gpt9cfg);
 }




