/*
   main.c
   Main C source file
   Test for harware profiling

   History:
      11/03/2015 : First version
 */

#define HPROFILE  // Activate Hardware Profiling

#include "Base.h"           // Basic definitions
#include "hprofile.h"       // Hardware Profile Header file

// Function that blinks the Green LED
// Parameters: NONE
// Never returns
void ledBlink(void)
 {
 while(1) // Infinite loop
   {
   // Turn ON Green LED
   (LEDS_PORT->BSRR.H.set)=BIT(GREEN_LED_PAD);

   HPROFILE_1_ON;
   // Wait 200ms
   SLEEP_MS(200);
   HPROFILE_1_OFF;

   // Turn OFF Green LED
   (LEDS_PORT->BSRR.H.clear)=BIT(GREEN_LED_PAD);

   // Wait 200ms
   SLEEP_MS(200);
   }
 }

// Check integer vs float operations
void integer_vs_float(void)
 {
 int32_t i;

 register float f32_a,f32_b,f32_c;
 volatile float f32_v;
 volatile int32_t  i32_a,i32_b,i32_c;
 volatile double f64_a,f64_b,f64_c;

 f32_a=7.0;
 f32_b=8.6;

 HPROFILE_1_ON;
 for(i=0;i<1000;i++)     // 1000 32 bit float multiplications
   {                     // Profiling gives 130us (7,8 MFLOPS) using the FPU
   f32_v=f32_a*f32_b;    // 7,8 MFLOPS
   }
 HPROFILE_1_OFF;

 i32_a=7;
 i32_b=8;

 HPROFILE_2_ON;
 for(i=0;i<1000;i++)    // 1000 32 bit integer multiplications
   {                    // Profiling gives 120us (don't depend on FPU usage)
   i32_c=i32_a*i32_b;   // 8,3 MIOPS
   }
 HPROFILE_2_OFF;

 HPROFILE_3_ON;
 for(i=0;i<1000;i++)    // 1000 64 bit float multiplications
   {                    // Profiling gives 2,1ms (don't depend on FPU usage)
   f64_c=f64_a*f64_b;   // 0,48 MFLOPS (16 times slower that 32 bit floats)
   }
 HPROFILE_3_OFF;

 f32_a=1.00;
 f32_b=0.99;
 HPROFILE_4_ON;
 for(i=0;i<1000;i++)     // 1000 32 bit float multiplications
   {                     // Profiling gives 49us (7,8 MFLOPS) using the FPU and -O2
   f32_a=f32_a*f32_b;    // 20 MFLOPS
   }
 f32_v=f32_a;
 HPROFILE_4_OFF;
 }

int main(void)
 {
 // Global initializations
 baseInit();

 // Init profile module
 HPROFILE_INIT;

 // Infinite loop
 while (1)
     {
	 integer_vs_float();
     };

 // Main should never return
 // This line is included so that the compiler doesn't complain
 return 0;
 }

