/*
 Hardware Profiling Module Header file
 */

// Check to avoid doble inclusion
#ifndef HPROFILE_HEADER
#define HPROFILE_HEADER

// GPIO Line definitions
#define HPROF1_PORT   GPIOC
#define HPROF1_PAD    15
#define HPROF2_PORT   GPIOC
#define HPROF2_PAD    13
#define HPROF3_PORT   GPIOE
#define HPROF3_PAD    5
#define HPROF4_PORT   GPIOB
#define HPROF4_PAD    7
#define HPROF5_PORT   GPIOB
#define HPROF5_PAD    5
#define HPROF6_PORT   GPIOA
#define HPROF6_PAD    8
#define HPROF7_PORT   GPIOC
#define HPROF7_PAD    9

#ifdef HPROFILE
/* Lines to include if HPROFILE is defined */

/* Function prototype */
void hprofileInit(void);

/* Function macros */
#define HPROFILE_INIT   hprofileInit()
#define HPROFILE_1_ON   (HPROF1_PORT->BSRR.H.set)=BIT(HPROF1_PAD)
#define HPROFILE_2_ON   (HPROF2_PORT->BSRR.H.set)=BIT(HPROF2_PAD)
#define HPROFILE_3_ON   (HPROF3_PORT->BSRR.H.set)=BIT(HPROF3_PAD)
#define HPROFILE_4_ON   (HPROF4_PORT->BSRR.H.set)=BIT(HPROF4_PAD)
#define HPROFILE_5_ON   (HPROF5_PORT->BSRR.H.set)=BIT(HPROF5_PAD)
#define HPROFILE_6_ON   (HPROF6_PORT->BSRR.H.set)=BIT(HPROF6_PAD)
#define HPROFILE_7_ON   (HPROF7_PORT->BSRR.H.set)=BIT(HPROF7_PAD)

#define HPROFILE_1_OFF  (HPROF1_PORT->BSRR.H.clear)=BIT(HPROF1_PAD)
#define HPROFILE_2_OFF  (HPROF2_PORT->BSRR.H.clear)=BIT(HPROF2_PAD)
#define HPROFILE_3_OFF  (HPROF3_PORT->BSRR.H.clear)=BIT(HPROF3_PAD)
#define HPROFILE_4_OFF  (HPROF4_PORT->BSRR.H.clear)=BIT(HPROF4_PAD)
#define HPROFILE_5_OFF  (HPROF5_PORT->BSRR.H.clear)=BIT(HPROF5_PAD)
#define HPROFILE_6_OFF  (HPROF6_PORT->BSRR.H.clear)=BIT(HPROF6_PAD)
#define HPROFILE_7_OFF  (HPROF7_PORT->BSRR.H.clear)=BIT(HPROF7_PAD)


#else  //HPROFILE
/* Lines to include if HPROFILE is not defined */

/* Null Function macros */
#define HPROFILE_INIT   /* */
#define HPROFILE_1_ON   /* */
#define HPROFILE_2_ON   /* */
#define HPROFILE_3_ON   /* */
#define HPROFILE_4_ON   /* */
#define HPROFILE_5_ON   /* */
#define HPROFILE_6_ON   /* */
#define HPROFILE_7_ON   /* */

#define HPROFILE_1_OFF  /* */
#define HPROFILE_2_OFF  /* */
#define HPROFILE_3_OFF  /* */
#define HPROFILE_4_OFF  /* */
#define HPROFILE_5_OFF  /* */
#define HPROFILE_6_OFF  /* */
#define HPROFILE_7_OFF  /* */

#endif //HPROFILE


#endif // HPROFILE_HEADER



