/*
 Hardware Profiling Module

 Uses EXT1 lines:

  1 GND
  2 +5V
  3 +3V
  4 NC - Alignment
  5 PC15 - PROF 1
  6 PC13 - PROF 2
  7 PE5  - PROF 3
  8 PB7  - PROF 4
  9 PB5  - PROF 5
 10 PA8  - PROF 6
 11 PC9  - PROF 7

There are 7 profiling lines PROF 1 to PROF 7

A function is defined to use profiling

Profiling is enabled only if #define HPROFILE is set before header
files #include directives

Three macros are defined for profiling

HPROFILE_INIT;        Initiates the profiling GPIOs
HPROFILE_1_ON;        Activate profile line 1
HPROFILE_1_OFF;       Deactivate profile line 1

The above macros don't do anything if the #define HPROFILE is not used

 */

#include "Base.h"           // Basic definitions
#include "hprofile.h"       // This Module Header file

/************************** PUBLIC FUNCTIONS ************************/

// Initialized the Hardware Profile GPIO Lines
void hprofileInit(void)
 {
 palSetPadMode(HPROF1_PORT,HPROF1_PAD,PAL_MODE_OUTPUT_PUSHPULL);
 palSetPadMode(HPROF2_PORT,HPROF2_PAD,PAL_MODE_OUTPUT_PUSHPULL);
 palSetPadMode(HPROF3_PORT,HPROF3_PAD,PAL_MODE_OUTPUT_PUSHPULL);
 palSetPadMode(HPROF4_PORT,HPROF4_PAD,PAL_MODE_OUTPUT_PUSHPULL);
 palSetPadMode(HPROF5_PORT,HPROF5_PAD,PAL_MODE_OUTPUT_PUSHPULL);
 palSetPadMode(HPROF6_PORT,HPROF6_PAD,PAL_MODE_OUTPUT_PUSHPULL);
 palSetPadMode(HPROF7_PORT,HPROF7_PAD,PAL_MODE_OUTPUT_PUSHPULL);
 }


