/*
 uart6_tx.h
 Header file
 Use of the serial port for debugging
 USART 6 TX will be used in async mode (UART)
 */

#ifndef _UART6_TX
#define _UART6_TX

// Hardware lines ------------------------------------------

// We will use PC6 at  CN6-8 (USART6-TX)
// Ground reference is CN6-9
// Pin multiplexing at PC6 should be AF8
// USART6 is activated in mcuconf.h

#define DEBUG_PORT     GPIOC
#define DEBUG_TX_PIN   6

// DEfinitions ------------------------------------------------

#define BREAK "\r\n"                        // Line break
#define SDEBUG (BaseSequentialStream*)&SD6  // Debug stream identifier
#define BASEDEBUG (BaseChannel *)&SD6       // Debug stream base channel cast

// Public functions prototypes ------------------------

// Starts UART6
void uart6start(void);

#endif // UART6_TX




