/*
 serialDebug.h
 Fichero de cabecera
 Rutinas para uso del puerto serie de depuracion
 */

#ifndef _SERIAL_DEBUG
#define _SERIAL_DEBUG

// Lineas de hardware ------------------------------------------

#define DEBUG_PORT     GPIOA
#define DEBUG_TX_PIN   2

// Definiciones ------------------------------------------------

#define BREAK "\r\n"                        // Salto de linea
#define SDEBUG (BaseSequentialStream*)&SD2  // Debug stream identier
#define BASEDEBUG (BaseChannel *)&SD2       // Debug stream base channel cast

// Prototipos de las funciones Publicas ------------------------

// Arranca el debug por puerto serie
void sDebugStart(void);

// Test para comprobar el funcionamiento del puerto de debug
// Escribe una cadena cada 100ms
void sDebugTest(void);

// Test de coma flotante
// Verificamos que podemos operar en coma flotante
// Los resultados se muestran en el canal de debug
void sDebugDoubleTest(void);

// Vuelca informacion de bloques y cuentas
void debugMetadata(void);

// Vuelca la ultima lectura
void debugRawDump(void);

#endif // serialDebug.h




