/*
 serialDebug.c
 Rutinas para uso del puerto serie de depuracion

 Pine empleados:
    PA2 (TX) conectar a linea RX de cable FTDI
    PA3 (RX) conectar a linea TX de cable FTDI


 */

#include "Base.h"           // Definiciones Basicas
#include "chprintf.h"	    // Modulo Printf
#include "serialDebug.h"    // Modulo de debug por puerto serie

//  Configuracion del puerto serie
SerialConfig Serial3Config;

// Test de coma flotante
// Verificamos que podemos operar en coma flotante
// Los resultados se muestran en el canal de debug
void sDebugDoubleTest(void)
 {
	// Test de numeros en coma flotante
	volatile double d1,d2,d3;

	d1=4.552;
	d2=3.623;
	d3=d1+d2;
	chprintf(SDEBUG,"%s%sTest de coma flotante %f + %f = %f%s%s"
			,BREAK,BREAK,d1,d2,d3,BREAK,BREAK);
 }


// Arranca el debug por puerto serie
void sDebugStart(void)
 {
	// Activa el puerto serie 3 a 9600 Baudios
	Serial3Config.speed = 38400;					//OJO! La documentacin dice sc_speed
	sdStart((SerialDriver *)&SD2,&Serial3Config);	//Configures and starts the driver. Parameters sdp: pointer to SerialDriver; config: serial driver configuration

	// Configura el pin TX y RX segun definiciones en serialDebug.h
	palSetPadMode(DEBUG_PORT,DEBUG_TX_PIN, PAL_MODE_ALTERNATE(7));	//This function programs a pad with the specified mode.Parameters: port identifier, pad number, pad mode

	// Escribe un mensaje en el puerto serie
	//(BaseSequentialStream *)
	chprintf(SDEBUG,"%s%sDSP_Test%s%s",BREAK,BREAK,BREAK);
	chprintf(SDEBUG,"Puerto serie de debug Activado%s",BREAK);
	chprintf(SDEBUG,"Arrancando el sistema...%s%s",BREAK,BREAK);
 }

// Test para comprobar el funcionamiento del puerto de debug
// Escribe una cadena cada 100ms
void sDebugTest(void)
 {
	while (1)
	{
		chprintf(SDEBUG,"Cadena de test%s",BREAK);
		SLEEP_MS(100);
	}
 }


