/*
   main.c
   DSP Test main source file

   This program configures the CMSIS DSP Library
   Uses it to print at UART6 TX:
              - A table of sin/cos from 0 to 360 deg

   Requires:
     uart6_tx Module

     Setting in mcuconf.h:
     #define STM32_SERIAL_USE_USART6             TRUE

     Adding to the DDEFS variable in the Makefile
     the content: -DCHPRINTF_USE_FLOAT=TRUE
     So that chprintf is able to use floats
 */

#include "Base.h"           // Basic definitions
#include "uart6_tx.h"       // Serial port 6 TX definitions
#include "chprintf.h"       // Console chprintf include file

#include "arm_math.h"       // Include for the DSP lib

// PI Constant
// float32_t is the proper variable to do hardware accelerated
// calculations
// Float is ok but it will be less portable
// Using double won't give any acceleration at all
const float32_t pi=3.14159;

// Print a sin/cos table
static void sin_cos_table(void)
 {
 int i;
 float32_t a,s,c;

 // Header for the table
 chprintf(SDEBUG,"%sSin/Cos table%s%s",BREAK,BREAK,BREAK);
 chprintf(SDEBUG,"  Angle     Sin     Cos%s",BREAK);

 // Angle loop
 for(i=0;i<=360;i++)
    {
	a=i*pi/180.0f;     // Convert from deg. to rad.
	s=arm_sin_f32(a);  // Fast sin library function
	c=arm_cos_f32(a);  // Fast cos library function

	// Print this line of the table
	chprintf(SDEBUG,"%7d %7f %7f %s",i,s,c,BREAK);
    }

 }

int main(void)
 {
 // Global initializations
 baseInit();

 // Start the serial channel 6 TX
 uart6start();

 // Serial header
 chprintf(SDEBUG,"DSP TEST PROJECT%s",BREAK);

 // Print a sin/cos table
 sin_cos_table();

 // Infinite loop so that main doesn't return
 while (1) {};

 // Main should never return
 // This line is included so that the compiler doesn't complain
 return 0;
 }

