/*
 ccm_debug.h
 Header file
 Use of the CCM Memory for debugging messages
 */

#ifndef _CCM_DEBUG
#define _CCM_DEBUG

// CCM Information

#define CCM_START  0x10000000 // Start of CCM memory
#define CCM_SIZE   0x10000    // CCM size if 64k

// Start of CCM as char pointer
#define CCM_CHAR   ((char*)CCM_START)

// Start of CCM as int32_t pointer
#define CCM_INT    ((int32_t*)CCM_START)

// Line size
#define CCM_LINESIZE 64

// External definitions
extern char (*ccmPointer);

// Public functions prototypes ------------------------

void ccmClear(void);
void ccmLine(void);
void ccmWrite(char *cad);

// Define functions -----------------------------------

// int ccmPrintf(const char *fmt, ...);
//
// Definition for the ccmPrintf function
// It operates in a similar way to printf
// The main difference is that line feeds are not processed
// Line jump is automatic in each function call
// to leave an empty line you can also use ccmLine
// Arguments:
//         fmt: String to format
//         ...: Variable number of arguments
// Returns the number of written chars
//
#define ccmPrintf(...) { chsnprintf(ccmPointer,CCM_LINESIZE, __VA_ARGS__ ); ccmLine(); }

// These definitions are compiled depending on the ACTIVATE_CCMDEBUG flag

#ifdef ACTIVATE_CCMDEBUG
#define CCMCLEAR()      ccmClear()
#define CCMLINE()       ccmLine()
#define CCMWRITE(x)     ccmWrite(x)
#define CCMPRINTF(...)  { chsnprintf(ccmPointer,CCM_LINESIZE, __VA_ARGS__ ); ccmLine(); }
#else
#define CCMCLEAR()      /* NOTHING */
#define CCMLINE()       /* NOTHING */
#define CCMWRITE(x)     /* NOTHING */
#define CCMPRINTF(...)  /* NOTHING */
#endif //ACTIVATE_CCMDEBUG

// So, functions:
// ccmClear() ccmLine() ccmWrite(x) and ccmPrintf(...)
// will always be compiled if present in the code
//
// but functions:
// CCMCLEAR() CCMLINE() CCMWRITE(x) and CCMPRINTF(...)
// will only be compiled if the ACTIVATE_CCMDEBUG is defined

#endif // ccm_debug.h




