/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.Marker;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.resources.ui.ResourcesUi;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "resource";

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getParentHandle(String handle, boolean allowChildBridgeHandles) {
        if (allowChildBridgeHandles) {
            return this.getParentHandle(handle);
        }
        IResource resource = (IResource)this.getObjectForHandle(handle);
        if (resource != null) {
            IContainer parent = resource.getParent();
            return this.getHandleIdentifier(parent);
        }
        return null;
    }

    public String getParentHandle(String handle) {
        IResource resource = (IResource)this.getObjectForHandle(handle);
        if (resource != null) {
            IContainer parent = resource.getParent();
            if (resource instanceof IFile) {
                for (String contentType : ContextCore.getChildContentTypes((String)CONTENT_TYPE)) {
                    AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)contentType);
                    Object adaptedParent = parentBridge.getAdaptedParent((Object)resource);
                    if (adaptedParent == null) continue;
                    return parentBridge.getHandleIdentifier(adaptedParent);
                }
            }
            return this.getHandleIdentifier(parent);
        }
        return null;
    }

    public List<String> getChildHandles(String handle) {
        Object object = this.getObjectForHandle(handle);
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                try {
                    if (container.isAccessible()) {
                        IResource[] children = container.members();
                        ArrayList<String> childHandles = new ArrayList<String>();
                        IResource[] iResourceArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource element = iResourceArray[n2];
                            String childHandle = this.getHandleIdentifier(element);
                            if (childHandle != null) {
                                childHandles.add(childHandle);
                            }
                            ++n2;
                        }
                        return childHandles;
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Could not get child", (Throwable)e));
                }
            } else {
                boolean cfr_ignored_0 = resource instanceof IFile;
            }
        }
        return Collections.emptyList();
    }

    public String getHandleIdentifier(Object object) {
        IAdaptable adaptable;
        Object adapter;
        if (object instanceof IProject) {
            String path = ((IResource)object).getFullPath().toPortableString();
            String javaCoreStylePath = "=" + path.substring(1);
            return javaCoreStylePath;
        }
        if (object instanceof IResource) {
            return ((IResource)object).getFullPath().toPortableString();
        }
        if (object instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)object).getAdapter(IResource.class)) instanceof IResource) {
            return ((IResource)adapter).getFullPath().toPortableString();
        }
        return null;
    }

    public Object getObjectForHandle(String handle) {
        if (handle == null) {
            return null;
        }
        Path path = new Path(handle);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (path.segmentCount() == 1) {
            String projectName = handle.substring(1);
            try {
                return workspace.getRoot().getProject(projectName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        if (path.segmentCount() > 1) {
            return workspace.getRoot().findMember((IPath)path);
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getName();
        }
        return "";
    }

    public boolean canBeLandmark(String handle) {
        Object element = this.getObjectForHandle(handle);
        return element instanceof IFile;
    }

    public boolean acceptsObject(Object object) {
        IAdaptable adaptable;
        Object adapter;
        if (object instanceof IResource || object instanceof IWorkingSet) {
            return true;
        }
        return object instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)object).getAdapter(IResource.class)) instanceof IResource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canFilter(Object element) {
        if (!(element instanceof IWorkingSet)) return true;
        try {
            IAdaptable[] elements;
            IWorkingSet workingSet = (IWorkingSet)element;
            IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
            int n = elements.length;
            int n2 = 0;
            while (true) {
                IInteractionElement interactionElement;
                if (n2 >= n) {
                    return true;
                }
                IAdaptable adaptable = iAdaptableArray[n2];
                AbstractContextStructureBridge elementBridge = ContextCore.getStructureBridge((Object)adaptable);
                String handle = elementBridge.getHandleIdentifier((Object)adaptable);
                if (handle != null && (interactionElement = ContextCore.getContextManager().getElement(handle)) != null && interactionElement.getInterest().isInteresting()) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDocument(String handle) {
        return this.getObjectForHandle(handle) instanceof IFile;
    }

    public String getHandleForOffsetInObject(Object object, int offset) {
        IResource markerResource;
        block7: {
            markerResource = null;
            try {
                if (object instanceof ConcreteMarker) {
                    markerResource = ((ConcreteMarker)object).getMarker().getResource();
                    break block7;
                }
                if (object instanceof Marker) {
                    markerResource = ((Marker)object).getResource();
                    break block7;
                }
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            if (markerResource instanceof IFile) {
                IFile file = (IFile)markerResource;
                return this.getHandleIdentifier(file);
            }
            return null;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Could not find element for: \"" + object + "\"", t));
            return null;
        }
    }

    public String getContentType(String elementHandle) {
        return this.getContentType();
    }

    @Deprecated
    public Set<IProject> getProjectsInActiveContext() {
        return ResourcesUi.getProjects(ContextCore.getContextManager().getActiveContext());
    }
}

