/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BasicExecutionOccurrence;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.LifelineCategories;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IImage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;

public class Lifeline
extends GraphNode {
    public static final String LIFELINE_TAG = "Lifeline";
    protected int fIndexInFrame = 0;
    protected Frame fFrame = null;
    protected int fEventOccurrence = 0;
    protected int fCategory = -1;
    protected boolean fHasTimeInfo = false;

    public Lifeline() {
        this.fPrefId = "PREF_LIFELINE";
    }

    @Override
    public int getX() {
        return 33 + (this.fIndexInFrame - 1) * Metrics.swimmingLaneWidth();
    }

    @Override
    public int getY() {
        return 23 + Metrics.getFrameFontHeigth() + Metrics.getLifelineHeaderFontHeigth() + 10 + 8;
    }

    @Override
    public int getWidth() {
        return Metrics.getLifelineWidth();
    }

    @Override
    public int getHeight() {
        return Metrics.getLifelineFontHeigth() + 28;
    }

    public void setCategory(int arrayIndex) {
        this.fCategory = arrayIndex;
    }

    public String getToolTipText() {
        LifelineCategories[] categories;
        if (this.fCategory >= 0 && this.fCategory < (categories = this.fFrame.getLifelineCategories()).length) {
            return String.valueOf(categories[this.fCategory].getName()) + " " + this.getName();
        }
        return "";
    }

    public int getExecOccurrenceDrawIndex() {
        if (!this.fHasChilden) {
            return 0;
        }
        if (this.fIndexes.get("Execution_Occ") != null) {
            return (Integer)this.fIndexes.get("Execution_Occ");
        }
        return 0;
    }

    protected void setFrame(Frame parentFrame) {
        this.fFrame = parentFrame;
        if (this.fHasTimeInfo) {
            this.fFrame.setHasTimeInfo(true);
        }
        if (this.fFrame.getMaxEventOccurrence() < this.getEventOccurrence() + 1) {
            this.fFrame.setMaxEventOccurrence(this.getEventOccurrence() + 1);
        }
    }

    protected Frame getFrame() {
        return this.fFrame;
    }

    protected void setIndex(int index) {
        this.fIndexInFrame = index;
    }

    public int getIndex() {
        return this.fIndexInFrame;
    }

    public void setCurrentEventOccurrence(int eventOcc) {
        if (this.fFrame != null && this.fFrame.getMaxEventOccurrence() < eventOcc) {
            this.fFrame.setMaxEventOccurrence(eventOcc);
        }
        this.fEventOccurrence = eventOcc;
    }

    public int getEventOccurrence() {
        return this.fEventOccurrence;
    }

    public int getNewEventOccurrence() {
        this.setCurrentEventOccurrence(this.fEventOccurrence + 1);
        return this.fEventOccurrence;
    }

    public void addExecution(BasicExecutionOccurrence exec) {
        exec.setLifeline(this);
        this.addNode(exec);
        if (this.fFrame != null && this.fFrame.getMaxEventOccurrence() < exec.fEndEventOccurrence) {
            this.fFrame.setMaxEventOccurrence(exec.fEndEventOccurrence);
        }
    }

    protected void setTimeInfo(boolean value) {
        this.fHasTimeInfo = value;
        if (this.fFrame != null && value) {
            this.fFrame.setHasTimeInfo(value);
        }
    }

    public boolean hasTimeInfo() {
        return this.fHasTimeInfo;
    }

    public List<GraphNode> getExecutions() {
        if (this.fHasChilden) {
            return (List)this.fNodes.get("Execution_Occ");
        }
        return new ArrayList<GraphNode>();
    }

    @Override
    public boolean contains(int xValue, int yValue) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.fFrame == null) {
            return false;
        }
        if (GraphNode.contains(x, y, width, height, xValue, yValue)) {
            return true;
        }
        if (GraphNode.contains(x + Metrics.getLifelineWidth() / 2 - 4, y + height, 8, (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.fFrame.getMaxEventOccurrence() + 20 - 4, xValue, yValue)) {
            return true;
        }
        height = Metrics.getLifelineFontHeigth() + 8;
        int hMargin = (30 - height) / 2;
        if (hMargin >= 2 && (this.fFrame.getVisibleAreaY() < y - height - hMargin ? GraphNode.contains(x - 22 + 1, y - height - hMargin, Metrics.swimmingLaneWidth() - 2, height + 1, xValue, yValue) : GraphNode.contains(x - 22 + 1, this.fFrame.getVisibleAreaY(), Metrics.swimmingLaneWidth() - 2, height, xValue, yValue))) {
            return true;
        }
        return this.getNodeAt(xValue, yValue) != null;
    }

    @Override
    public boolean isVisible(int vx, int vy, int vwidth, int vheight) {
        int x = this.getX();
        int width = this.getWidth();
        return x >= vx && x <= vx + vwidth || x + width >= vx && x <= vx;
    }

    protected void drawName(IGC context) {
        SDViewPref pref = SDViewPref.getInstance();
        int x = this.getX();
        int y = this.getY();
        int height = Metrics.getLifelineHeaderFontHeigth() + 8;
        int hMargin = 7;
        context.setLineStyle(context.getLineSolidStyle());
        context.setBackground(pref.getBackGroundColor("PREF_LIFELINE_HEADER"));
        context.setForeground(pref.getForeGroundColor("PREF_LIFELINE_HEADER"));
        context.setFont(pref.getFont("PREF_LIFELINE_HEADER"));
        if (hMargin >= 0) {
            if (this.fFrame.getVisibleAreaY() < y - height - hMargin) {
                context.fillRectangle(x - 22 + 1, y - height - hMargin, Metrics.swimmingLaneWidth() - 2, height);
                context.drawRectangle(x - 22 + 1, y - height - hMargin, Metrics.swimmingLaneWidth() - 2, height);
                context.setForeground(pref.getFontColor("PREF_LIFELINE_HEADER"));
                context.drawTextTruncatedCentred(this.getName(), x + 20 - 22 + 1, y - height - hMargin, Metrics.swimmingLaneWidth() - 40 - 2, height, true);
            } else {
                context.fillRectangle(x - 22 + 1, this.fFrame.getVisibleAreaY(), Metrics.swimmingLaneWidth() - 2, height);
                context.drawRectangle(x - 22 + 1, this.fFrame.getVisibleAreaY(), Metrics.swimmingLaneWidth() - 2, height);
                context.setForeground(pref.getFontColor("PREF_LIFELINE_HEADER"));
                context.drawTextTruncatedCentred(this.getName(), x - 22 + 20 + 1, this.fFrame.getVisibleAreaY(), Metrics.swimmingLaneWidth() - 40 - 2, height, true);
            }
        }
    }

    public void draw(IGC context, int x, int y) {
        IImage image;
        LifelineCategories[] categories;
        SDViewPref pref = SDViewPref.getInstance();
        context.setLineWidth(1);
        if (this.isSelected()) {
            if (pref.useGradienColor()) {
                context.setGradientColor(pref.getBackGroundColor("PREF_LIFELINE"));
            }
            context.setBackground(pref.getBackGroundColorSelection());
            context.setForeground(pref.getForeGroundColorSelection());
        } else {
            if (pref.useGradienColor()) {
                context.setGradientColor(pref.getBackGroundColor("PREF_LIFELINE"));
                context.setBackground(pref.getBackGroundColor("PREF_FRAME"));
            } else {
                context.setBackground(pref.getBackGroundColor("PREF_LIFELINE"));
            }
            context.setForeground(pref.getForeGroundColor("PREF_LIFELINE"));
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (pref.useGradienColor()) {
            context.fillGradientRectangle(x, y, width, height / 2 - 7, true);
            context.fillRectangle(x, y + height / 2 - 8, width, height / 2 - 5);
            context.fillGradientRectangle(x, y + height, width, -height / 2 + 6, true);
        } else {
            context.fillRectangle(x, y, width, height);
        }
        context.drawRectangle(x, y, width, height);
        if (this.fCategory >= 0 && this.fCategory < (categories = this.fFrame.getLifelineCategories()).length && (image = categories[this.fCategory].getImage()) != null) {
            context.drawImage(image, x, y, width, height);
        }
        IColor temp = context.getForeground();
        context.setFont(pref.getFont("PREF_LIFELINE"));
        context.setForeground(pref.getFontColor("PREF_LIFELINE"));
        context.drawTextTruncatedCentred(this.getName(), x + 20, y, Metrics.getLifelineWidth() - 40, height, true);
        context.setLineStyle(context.getLineDashStyle());
        context.setForeground(temp);
        int oldStyle = context.getLineStyle();
        int dashedLineEnd = y + height + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.fFrame.getMaxEventOccurrence() + 20;
        if (this.isSelected()) {
            context.setForeground(pref.getBackGroundColorSelection());
            context.setLineWidth(5);
            context.drawLine(x + Metrics.getLifelineWidth() / 2, y + height, x + Metrics.getLifelineWidth() / 2, dashedLineEnd - 4);
            context.setForeground(pref.getForeGroundColorSelection());
        }
        context.setLineWidth(1);
        context.drawLine(x + Metrics.getLifelineWidth() / 2, y + height, x + Metrics.getLifelineWidth() / 2, dashedLineEnd - 4);
        context.drawLine(x + Metrics.getLifelineWidth() / 2, y + height, x + Metrics.getLifelineWidth() / 2, dashedLineEnd - 4);
        context.setLineStyle(oldStyle);
        context.setLineStyle(context.getLineSolidStyle());
        if (this.hasFocus()) {
            this.drawFocus(context);
        }
        super.drawChildenNodes(context);
    }

    public void highlightExecOccurrenceRegion(IGC context, int startEvent, int nbEvent, IColor color) {
        IColor backupColor = context.getBackground();
        context.setBackground(color);
        int x = this.getX() + Metrics.getLifelineWidth() / 2 - 4;
        int y = this.getY() + this.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * startEvent;
        int width = 8;
        int height = (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * nbEvent;
        context.fillRectangle(x, y, width, height);
        context.setBackground(backupColor);
    }

    @Override
    public void draw(IGC context) {
        this.draw(context, this.getX(), this.getY());
    }

    @Override
    public String getArrayId() {
        return LIFELINE_TAG;
    }

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        return this.getX() > x - Metrics.swimmingLaneWidth();
    }

    @Override
    public GraphNode getNodeAt(int x, int y) {
        int vy = 0;
        int vh = 0;
        if (this.getFrame() == null) {
            return null;
        }
        vy = this.getFrame().getVisibleAreaY();
        vh = this.getFrame().getVisibleAreaHeight();
        if (this.getExecutions() == null) {
            return null;
        }
        int i = this.getExecOccurrenceDrawIndex();
        while (i < this.getExecutions().size()) {
            GraphNode node = this.getExecutions().get(i);
            if (node.getHeight() >= 0 ? node.getY() > vy + vh : node.getY() + node.getHeight() > vy + vh) break;
            if (node.contains(x, y)) {
                GraphNode internal = node.getNodeAt(x, y);
                if (internal != null) {
                    return internal;
                }
                return node;
            }
            ++i;
        }
        return null;
    }
}

