/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.ui.views.histogram.Histogram;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Canvas;

public class HistogramZoom
implements MouseWheelListener {
    private static final double ZOOM_FACTOR = 0.8;
    private final Histogram fHistogram;
    private final Canvas fCanvas;
    private long fAbsoluteStartTime;
    private long fAbsoluteEndTime;
    private final long fMinWindowSize;
    private long fRangeStartTime;
    private long fRangeDuration;
    private MouseScrollCounter fScrollCounter;

    public HistogramZoom(Histogram histogram, Canvas canvas, long start, long end) {
        this.fHistogram = histogram;
        this.fCanvas = canvas;
        this.fAbsoluteStartTime = start;
        this.fAbsoluteEndTime = end;
        this.fMinWindowSize = this.fCanvas.getBounds().x;
        this.fRangeStartTime = this.fAbsoluteStartTime;
        this.fRangeDuration = this.fAbsoluteStartTime + this.fMinWindowSize;
        canvas.addMouseWheelListener((MouseWheelListener)this);
    }

    public synchronized long getStartTime() {
        return this.fRangeStartTime;
    }

    public synchronized long getEndTime() {
        return this.fRangeStartTime + this.fRangeDuration;
    }

    public synchronized long getDuration() {
        return this.fRangeDuration;
    }

    public synchronized void stop() {
        if (this.fScrollCounter != null) {
            this.fScrollCounter.interrupt();
            this.fScrollCounter = null;
        }
    }

    public synchronized void setFullRange(long startTime, long endTime) {
        this.fAbsoluteStartTime = startTime;
        this.fAbsoluteEndTime = endTime;
    }

    public synchronized void setNewRange(long startTime, long duration) {
        long endTime;
        if (startTime < this.fAbsoluteStartTime) {
            startTime = this.fAbsoluteStartTime;
        }
        if ((endTime = startTime + duration) > this.fAbsoluteEndTime) {
            endTime = this.fAbsoluteEndTime;
            startTime = endTime - duration > this.fAbsoluteStartTime ? endTime - duration : this.fAbsoluteStartTime;
        }
        this.fRangeStartTime = startTime;
        this.fRangeDuration = endTime - startTime;
    }

    public synchronized void mouseScrolled(MouseEvent event) {
        if (this.fScrollCounter == null) {
            this.fScrollCounter = new MouseScrollCounter(this);
            this.fScrollCounter.start();
        }
        this.fScrollCounter.incrementMouseScroll(event.count);
    }

    private synchronized void zoom(int nbClicks) {
        this.fScrollCounter = null;
        long requestedRange = nbClicks > 0 ? Math.round(0.8 * (double)this.fRangeDuration) : (long)Math.ceil((double)this.fRangeDuration * 1.25);
        long requestedStart = this.validateStart(this.fRangeStartTime + (this.fRangeDuration - requestedRange) / 2L);
        long requestedEnd = this.validateEnd(requestedStart, requestedStart + requestedRange);
        requestedStart = this.validateStart(requestedEnd - requestedRange);
        this.fHistogram.updateTimeRange(requestedStart, requestedEnd);
    }

    private long validateStart(long start) {
        if (start < this.fAbsoluteStartTime) {
            start = this.fAbsoluteStartTime;
        }
        if (start > this.fAbsoluteEndTime) {
            start = this.fAbsoluteEndTime - this.fMinWindowSize;
        }
        return start;
    }

    private long validateEnd(long start, long end) {
        if (end > this.fAbsoluteEndTime) {
            end = this.fAbsoluteEndTime;
        }
        if (end < start + this.fMinWindowSize) {
            end = start + this.fMinWindowSize;
        }
        return end;
    }

    private static class MouseScrollCounter
    extends Thread {
        private static final long QUIET_TIME = 100L;
        private static final long POLLING_INTERVAL = 10L;
        private HistogramZoom fZoom = null;
        private long fLastPoolTime = 0L;
        private int nbScrollClick = 0;

        public MouseScrollCounter(HistogramZoom zoom) {
            this.fZoom = zoom;
            this.fLastPoolTime = System.currentTimeMillis();
        }

        public void incrementMouseScroll(int nbScrolls) {
            this.fLastPoolTime = System.currentTimeMillis();
            this.nbScrollClick += nbScrolls;
        }

        @Override
        public void run() {
            while (System.currentTimeMillis() - this.fLastPoolTime < 100L) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    return;
                }
            }
            if (!this.isInterrupted()) {
                this.fZoom.zoom(this.nbScrollClick);
            }
        }
    }
}

