/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectTraceTypeHandler
extends AbstractHandler {
    private static final String BUNDLE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.project.trace.select_trace_type.bundle";
    private static final String TYPE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.project.trace.select_trace_type.type";
    private static final String ICON_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.project.trace.select_trace_type.icon";
    private TreeSelection fSelection = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fSelection = null;
        if (selection instanceof TreeSelection) {
            this.fSelection = (TreeSelection)selection;
            for (Object element : this.fSelection) {
                if (element instanceof TmfTraceElement) continue;
                return false;
            }
        }
        return !selection.isEmpty();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        boolean ok = true;
        for (Object element : this.fSelection.toList()) {
            TmfTraceElement trace = (TmfTraceElement)element;
            IResource resource = (trace = trace.getElementUnderTraceFolder()).getResource();
            if (resource == null) continue;
            try {
                String bundleName = event.getParameter(BUNDLE_PARAMETER);
                String traceType = event.getParameter(TYPE_PARAMETER);
                String iconUrl = event.getParameter(ICON_PARAMETER);
                ok &= SelectTraceTypeHandler.propagateProperties(trace, bundleName, traceType, iconUrl);
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error selecting trace type for trace" + trace.getName(), e);
            }
        }
        ((ITmfProjectModelElement)this.fSelection.getFirstElement()).getProject().refresh();
        if (!ok) {
            MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1);
            mb.setText(Messages.SelectTraceTypeHandler_Title);
            mb.setMessage(Messages.SelectTraceTypeHandler_InvalidTraceType);
            mb.open();
        }
        return null;
    }

    private static boolean propagateProperties(TmfTraceElement trace, String bundleName, String traceType, String iconUrl) throws CoreException {
        IResource svResource = trace.getResource();
        String svBundleName = svResource.getPersistentProperty(TmfCommonConstants.TRACEBUNDLE);
        String svTraceType = svResource.getPersistentProperty(TmfCommonConstants.TRACETYPE);
        String svIconUrl = svResource.getPersistentProperty(TmfCommonConstants.TRACEICON);
        SelectTraceTypeHandler.setProperties(trace.getResource(), bundleName, traceType, iconUrl);
        trace.refreshTraceType();
        if (!SelectTraceTypeHandler.validateTraceType(trace)) {
            SelectTraceTypeHandler.setProperties(trace.getResource(), svBundleName, svTraceType, svIconUrl);
            trace.refreshTraceType();
            return false;
        }
        trace.refreshTraceType();
        if (trace.getParent() instanceof TmfTraceFolder) {
            TmfExperimentFolder experimentFolder = trace.getProject().getExperimentsFolder();
            for (ITmfProjectModelElement experiment : experimentFolder.getChildren()) {
                for (ITmfProjectModelElement child : experiment.getChildren()) {
                    TmfTraceElement linkedTrace;
                    if (!(child instanceof TmfTraceElement) || !(linkedTrace = (TmfTraceElement)child).equals(trace)) continue;
                    IResource resource = linkedTrace.getResource();
                    SelectTraceTypeHandler.setProperties(resource, bundleName, traceType, iconUrl);
                    linkedTrace.refreshTraceType();
                }
            }
        }
        return true;
    }

    private static void setProperties(IResource resource, String bundleName, String traceType, String iconUrl) throws CoreException {
        resource.setPersistentProperty(TmfCommonConstants.TRACEBUNDLE, bundleName);
        resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, traceType);
        resource.setPersistentProperty(TmfCommonConstants.TRACEICON, iconUrl);
    }

    private static boolean validateTraceType(TmfTraceElement trace) {
        IProject project = trace.getProject().getResource();
        ITmfTrace<?> tmfTrace = null;
        try {
            tmfTrace = trace.instantiateTrace();
            boolean bl = tmfTrace != null && tmfTrace.validate(project, trace.getLocation().getPath());
            return bl;
        }
        finally {
            if (tmfTrace != null) {
                tmfTrace.dispose();
            }
        }
    }
}

