/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ParameterizedBlock;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

public class TextBoxBlock
extends ParameterizedBlock {
    private final Pattern startPattern;
    private final Pattern endPattern;
    private final DocumentBuilder.BlockType blockType;
    private int blockLineCount = 0;
    private Matcher matcher;
    private String title;
    private boolean nesting = false;

    public TextBoxBlock(DocumentBuilder.BlockType blockType, String name) {
        this.blockType = blockType;
        this.startPattern = Pattern.compile("\\{" + name + "(?::([^\\}]*))?\\}(.*)");
        this.endPattern = Pattern.compile("(\\{" + name + "\\})(.*)");
    }

    public int processLineContent(String line, int offset) {
        int end = line.length();
        if (this.blockLineCount == 0) {
            this.setOptions(this.matcher.group(1));
            Attributes attributes = new Attributes();
            attributes.setTitle(this.title);
            offset = this.matcher.start(2);
            this.builder.beginBlock(this.blockType, attributes);
            this.nesting = true;
            end = offset;
        } else {
            boolean terminating = false;
            Matcher endMatcher = this.endPattern.matcher(line);
            if (offset < end) {
                if (offset > 0) {
                    endMatcher.region(offset, end);
                }
                if (endMatcher.find()) {
                    terminating = true;
                    end = endMatcher.start(2);
                } else {
                    end = offset;
                }
            }
            if (terminating) {
                this.setClosed(true);
            }
        }
        ++this.blockLineCount;
        return end == line.length() ? -1 : end;
    }

    public boolean beginNesting() {
        return this.nesting;
    }

    public int findCloseOffset(String line, int lineOffset) {
        Matcher endMatcher = this.endPattern.matcher(line);
        if (lineOffset != 0) {
            endMatcher.region(lineOffset, line.length());
        }
        if (endMatcher.find()) {
            return endMatcher.start();
        }
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.title = null;
        this.nesting = false;
        this.matcher = this.startPattern.matcher(line);
        if (lineOffset > 0) {
            this.matcher.region(lineOffset, line.length());
        }
        return this.matcher.matches();
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    protected void setOption(String key, String value) {
        if (key.equals("title")) {
            this.title = value;
        }
    }
}

