/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.piechart;

import org.eclipse.linuxtools.dataviewers.piechart.IColorsConstants;
import org.eclipse.linuxtools.dataviewers.piechart.PieChart;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.swtchart.ISeries;

public class PieChartPaintListener
implements PaintListener {
    private PieChart chart;
    private Control plotArea;
    private static final int X_GAP = 10;

    public PieChartPaintListener(PieChart chart, Control plotArea) {
        this.chart = chart;
        this.plotArea = plotArea;
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Rectangle bounds = this.plotArea == null ? gc.getClipping() : this.plotArea.getBounds();
        double[][] series = this.getPieSeriesArray();
        int width = (bounds.width - bounds.x) / series.length;
        int x = bounds.x;
        double[][] dArray = series;
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            double[] s = dArray[n2];
            this.drawPieChart(e, s, new Rectangle(x, bounds.y, width, bounds.height));
            x += width;
            ++n2;
        }
    }

    private void drawPieChart(PaintEvent e, double[] series, Rectangle bounds) {
        int nelemSeries = series.length;
        double sumTotal = 0.0;
        int i = 0;
        while (i < nelemSeries) {
            sumTotal += series[i];
            ++i;
        }
        GC gc = e.gc;
        gc.setLineWidth(1);
        int pieWidth = Math.min(bounds.width - 10, bounds.height);
        int pieX = bounds.x + (bounds.width - pieWidth) / 2;
        int pieY = bounds.y + (bounds.height - pieWidth) / 2;
        if (sumTotal == 0.0) {
            gc.drawOval(pieX, pieY, pieWidth, pieWidth);
        } else {
            double factor = 100.0 / sumTotal;
            int sweepAngle = 0;
            int incrementAngle = 0;
            int initialAngle = 90;
            int i2 = 0;
            while (i2 < nelemSeries) {
                gc.setBackground(new Color((Device)e.display, IColorsConstants.COLORS[i2]));
                if (i2 == nelemSeries - 1) {
                    sweepAngle = 360 - incrementAngle;
                } else {
                    double angle = series[i2] * factor * 3.6;
                    sweepAngle = (int)Math.round(angle);
                }
                gc.fillArc(pieX, pieY, pieWidth, pieWidth, initialAngle, -sweepAngle);
                gc.drawArc(pieX, pieY, pieWidth, pieWidth, initialAngle, -sweepAngle);
                incrementAngle += sweepAngle;
                initialAngle += -sweepAngle;
                ++i2;
            }
        }
    }

    private double[][] getPieSeriesArray() {
        ISeries[] series = this.chart.getSeriesSet().getSeries();
        if (series == null || series.length == 0) {
            return new double[0][0];
        }
        double[][] result = new double[series[0].getXSeries().length][series.length];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[i].length) {
                double[] d = series[j].getXSeries();
                result[i][j] = d != null && d.length > 0 ? d[i] : 0.0;
                ++j;
            }
            ++i;
        }
        return result;
    }
}

