/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public abstract class CLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected ICElement getContext(ILaunchConfiguration config, String platform) {
        IFile file;
        IEditorInput input;
        IEditorPart part;
        ICElement ce;
        IStructuredSelection ss;
        ISelection selection;
        String projectName = null;
        String programName = null;
        IWorkbenchPage page = LaunchUIPlugin.getActivePage();
        Object obj = null;
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
            programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
            if (programName != null) {
                programName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programName);
            }
        }
        catch (CoreException coreException) {}
        if (projectName != null && !projectName.equals("")) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                obj = cProject;
            }
        } else if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            obj = ss.getFirstElement();
        }
        if (obj instanceof IResource) {
            ce = CoreModel.getDefault().create((IResource)obj);
            if (ce == null) {
                IProject pro = ((IResource)obj).getProject();
                ce = CoreModel.getDefault().create(pro);
            }
            obj = ce;
        }
        if (obj instanceof ICElement) {
            if (platform != null && !platform.equals("*")) {
                try {
                    String projectPlatform;
                    ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(obj.getCProject().getProject(), false);
                    if (descriptor != null && !(projectPlatform = descriptor.getPlatform()).equals(platform) && !projectPlatform.equals("*")) {
                        obj = null;
                    }
                }
                catch (CoreException coreException) {}
            }
            if (obj != null) {
                if (programName == null || programName.equals("")) {
                    return obj;
                }
                ce = obj;
                IProject project = (IProject)ce.getCProject().getResource();
                IPath programFile = project.getFile(programName).getLocation();
                ce = CCorePlugin.getDefault().getCoreModel().create(programFile);
                if (ce != null && ce.exists()) {
                    return ce;
                }
                return obj;
            }
        }
        if (page != null && (part = page.getActiveEditor()) != null && (input = part.getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            ICElement ce2 = CoreModel.getDefault().create(file);
            if (ce2 == null) {
                IProject pro = file.getProject();
                ce2 = CoreModel.getDefault().create(pro);
            }
            return ce2;
        }
        return null;
    }

    protected void initializeCProject(ICElement cElement, ILaunchConfigurationWorkingCopy config) {
        ICProject cProject = cElement.getCProject();
        String name = null;
        if (cProject != null && cProject.exists()) {
            name = cProject.getElementName();
            config.setMappedResources(new IResource[]{cProject.getProject()});
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(cProject.getProject());
            String buildConfigID = projDes.getActiveConfiguration().getId();
            config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfigID);
        }
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", name);
    }

    protected String getPlatform(ILaunchConfiguration config) {
        String platform = Platform.getOS();
        try {
            return config.getAttribute("org.eclipse.cdt.launch.PLATFFORM", platform);
        }
        catch (CoreException coreException) {
            return platform;
        }
    }

    protected Button createVariablesButton(Composite parent, String label, final Text textField) {
        Button variablesButton = this.createPushButton(parent, label, null);
        variablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CLaunchConfigurationTab.this.handleVariablesButtonSelected(textField);
            }
        });
        return variablesButton;
    }

    private void handleVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.insert(variable);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }
}

