/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.newui;

import java.io.File;
import org.eclipse.cdt.core.settings.model.ACPathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;

public class LanguageSettingsImages {
    public static Image getImage(int kind, int flags, boolean isProjectRelative) {
        String imageKey = LanguageSettingsImages.getImageKey(kind, flags, isProjectRelative);
        if (imageKey != null) {
            return CDTSharedImages.getImage(imageKey);
        }
        return null;
    }

    public static Image getImage(ICLanguageSettingEntry entry, ICConfigurationDescription cfgDescription) {
        IProject project;
        ICProjectDescription prjDescription;
        String projectName = null;
        if (cfgDescription != null && (prjDescription = cfgDescription.getProjectDescription()) != null && (project = prjDescription.getProject()) != null) {
            projectName = project.getName();
        }
        return LanguageSettingsImages.getImage(entry, projectName, cfgDescription);
    }

    public static String getImageKey(int kind, int flag, boolean isProjectRelative) {
        String imageKey = null;
        boolean isWorkspacePath = (flag & 8) != 0;
        boolean isBuiltin = (flag & 1) != 0;
        boolean isFramework = (flag & 0x40) != 0;
        switch (kind) {
            case 1: {
                if (isWorkspacePath) {
                    if (isProjectRelative) {
                        imageKey = "icons/obj16/hfolder_prj.gif";
                        break;
                    }
                    imageKey = "icons/obj16/wsp_includefolder.gif";
                    break;
                }
                if (isFramework) {
                    imageKey = "icons/obj16/frameworks.png";
                    break;
                }
                if (isBuiltin) {
                    imageKey = "icons/obj16/fldr_sys_obj.gif";
                    break;
                }
                imageKey = "icons/obj16/hfolder_obj.gif";
                break;
            }
            case 2: {
                imageKey = "icons/obj16/h_file_obj.gif";
                break;
            }
            case 4: {
                imageKey = "icons/obj16/define_obj.gif";
                break;
            }
            case 8: {
                imageKey = "icons/obj16/macros_file.gif";
                break;
            }
            case 16: {
                imageKey = "icons/obj16/fldr_lib_obj.gif";
                break;
            }
            case 32: {
                imageKey = "icons/obj16/lib_obj.gif";
            }
        }
        if (imageKey == null) {
            imageKey = "icons/obj16/unknown_type_obj.gif";
        }
        return imageKey;
    }

    private static Image getImage(ICLanguageSettingEntry entry, String projectName, ICConfigurationDescription cfgDescription) {
        int kind = entry.getKind();
        int flags = entry.getFlags();
        boolean isWorkspacePath = (flags & 8) != 0;
        String path = entry.getName();
        boolean isProjectRelative = projectName != null && isWorkspacePath && path.startsWith(String.valueOf('/') + projectName + '/');
        String imageKey = LanguageSettingsImages.getImageKey(kind, flags, isProjectRelative);
        if (imageKey != null) {
            if ((flags & 0x20) != 0) {
                return CDTSharedImages.getImageOverlaid(imageKey, "icons/ovr16/inactive_co.gif", 2);
            }
            if (entry instanceof ACPathEntry) {
                String overlayKey = null;
                IStatus status = LanguageSettingsImages.getStatus(entry, cfgDescription);
                switch (status.getSeverity()) {
                    case 4: {
                        overlayKey = "icons/ovr16/error_co.gif";
                        break;
                    }
                    case 2: {
                        overlayKey = "icons/ovr16/warning_co.gif";
                        break;
                    }
                    case 1: {
                        overlayKey = "icons/ovr16/warning_co.gif";
                    }
                }
                return CDTSharedImages.getImageOverlaid(imageKey, overlayKey, 2);
            }
            return CDTSharedImages.getImage(imageKey);
        }
        return null;
    }

    private static boolean isLocationOk(ACPathEntry entry) {
        boolean isWorkspacePath;
        boolean exists = true;
        boolean bl = isWorkspacePath = (entry.getFlags() & 8) != 0;
        if (isWorkspacePath) {
            Path path = new Path(entry.getValue());
            IResource rc = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            exists = rc != null && rc.isAccessible();
        } else {
            String pathname = entry.getName();
            File file = new File(pathname);
            exists = file.exists();
        }
        return exists;
    }

    public static IStatus getStatus(ICLanguageSettingEntry entry, ICConfigurationDescription cfgDescription) {
        if (entry instanceof ACPathEntry) {
            ACPathEntry acEntry;
            String acEntryName;
            Path path;
            ICLanguageSettingEntry[] entries;
            if (!entry.isResolved() && (entries = CDataUtil.resolveEntries((ICLanguageSettingEntry[])new ICLanguageSettingEntry[]{entry}, (ICConfigurationDescription)cfgDescription)) != null && entries.length > 0) {
                entry = entries[0];
            }
            if (!(path = new Path(acEntryName = (acEntry = (ACPathEntry)entry).getName())).isAbsolute()) {
                return new Status(1, "org.eclipse.cdt.ui", Messages.LanguageSettingsImages_UsingRelativePathsNotRecommended);
            }
            if (!LanguageSettingsImages.isLocationOk(acEntry)) {
                if (acEntry.isFile()) {
                    return new Status(2, "org.eclipse.cdt.ui", Messages.LanguageSettingsImages_FileDoesNotExist);
                }
                return new Status(2, "org.eclipse.cdt.ui", Messages.LanguageSettingsImages_FolderDoesNotExist);
            }
        }
        return Status.OK_STATUS;
    }
}

