/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlighting;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingPresenter;
import org.eclipse.cdt.internal.ui.editor.SemanticToken;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class SemanticHighlightingReconciler
implements ICReconcilingListener {
    private CEditor fEditor;
    protected SemanticHighlightingPresenter fPresenter;
    protected SemanticHighlighting[] fSemanticHighlightings;
    private SemanticHighlightingManager.HighlightingStyle[] fHighlightings;
    protected List<SemanticHighlightingManager.HighlightedPosition> fAddedPositions = new ArrayList<SemanticHighlightingManager.HighlightedPosition>();
    protected List<SemanticHighlightingManager.HighlightedPosition> fRemovedPositions = new ArrayList<SemanticHighlightingManager.HighlightedPosition>();
    protected int fNOfRemovedPositions;
    private Job fJob;
    private final Object fJobLock = new Object();
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    protected SemanticHighlightingPresenter fJobPresenter;
    protected SemanticHighlighting[] fJobSemanticHighlightings;
    private SemanticHighlightingManager.HighlightingStyle[] fJobHighlightings;

    @Override
    public void aboutToBeReconciled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            if (this.fIsReconciling) {
                return;
            }
            this.fIsReconciling = true;
        }
        this.fJobPresenter = this.fPresenter;
        this.fJobSemanticHighlightings = this.fSemanticHighlightings;
        this.fJobHighlightings = this.fHighlightings;
        try {
            block23: {
                block22: {
                    if (this.fJobPresenter == null || this.fJobSemanticHighlightings == null || this.fJobHighlightings == null) break block22;
                    this.fJobPresenter.setCanceled(progressMonitor != null && progressMonitor.isCanceled());
                    if (ast != null && !this.fJobPresenter.isCanceled()) break block23;
                }
                this.fJobPresenter = null;
                this.fJobSemanticHighlightings = null;
                this.fJobHighlightings = null;
                Object object2 = this.fReconcileLock;
                synchronized (object2) {
                    this.fIsReconciling = false;
                    return;
                }
            }
            PositionCollector collector = new PositionCollector(this.requiresImplicitNames());
            this.startReconcilingPositions();
            if (!this.fJobPresenter.isCanceled()) {
                this.reconcilePositions(ast, collector);
            }
            TextPresentation textPresentation = null;
            if (!this.fJobPresenter.isCanceled()) {
                textPresentation = this.fJobPresenter.createPresentation(this.fAddedPositions, this.fRemovedPositions);
            }
            if (!this.fJobPresenter.isCanceled()) {
                this.updatePresentation(textPresentation, this.fAddedPositions, this.fRemovedPositions);
            }
            this.stopReconcilingPositions();
        }
        catch (Throwable throwable) {
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            Object object3 = this.fReconcileLock;
            synchronized (object3) {
                this.fIsReconciling = false;
                throw throwable;
            }
        }
        this.fJobPresenter = null;
        this.fJobSemanticHighlightings = null;
        this.fJobHighlightings = null;
        Object object4 = this.fReconcileLock;
        synchronized (object4) {
            this.fIsReconciling = false;
            return;
        }
    }

    private boolean requiresImplicitNames() {
        int i = 0;
        while (i < this.fSemanticHighlightings.length) {
            SemanticHighlighting sh = this.fSemanticHighlightings[i];
            if (sh.requiresImplicitNames() && this.fHighlightings[i].isEnabled()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void startReconcilingPositions() {
        this.fJobPresenter.addAllPositions(this.fRemovedPositions);
        this.fNOfRemovedPositions = this.fRemovedPositions.size();
    }

    private void reconcilePositions(IASTTranslationUnit ast, PositionCollector visitor) {
        ast.accept((ASTVisitor)visitor);
        List<SemanticHighlightingManager.HighlightedPosition> oldPositions = this.fRemovedPositions;
        ArrayList<SemanticHighlightingManager.HighlightedPosition> newPositions = new ArrayList<SemanticHighlightingManager.HighlightedPosition>(this.fNOfRemovedPositions);
        int i = 0;
        int n = oldPositions.size();
        while (i < n) {
            SemanticHighlightingManager.HighlightedPosition current = oldPositions.get(i);
            if (current != null) {
                newPositions.add(current);
            }
            ++i;
        }
        this.fRemovedPositions = newPositions;
        Collections.sort(this.fAddedPositions, new Comparator<Position>(){

            @Override
            public int compare(Position p1, Position p2) {
                return p1.getOffset() - p2.getOffset();
            }
        });
    }

    protected void updatePresentation(TextPresentation textPresentation, List<SemanticHighlightingManager.HighlightedPosition> addedPositions, List<SemanticHighlightingManager.HighlightedPosition> removedPositions) {
        Runnable runnable = this.fJobPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        CEditor editor = this.fEditor;
        if (editor == null) {
            return;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    protected void stopReconcilingPositions() {
        this.fRemovedPositions.clear();
        this.fNOfRemovedPositions = 0;
        this.fAddedPositions.clear();
    }

    public void install(CEditor editor, ISourceViewer sourceViewer, SemanticHighlightingPresenter presenter, SemanticHighlighting[] semanticHighlightings, SemanticHighlightingManager.HighlightingStyle[] highlightings) {
        this.fPresenter = presenter;
        this.fSemanticHighlightings = semanticHighlightings;
        this.fHighlightings = highlightings;
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fEditor.addReconcileListener(this);
        }
    }

    public void uninstall() {
        if (this.fPresenter != null) {
            this.fPresenter.setCanceled(true);
        }
        if (this.fEditor != null) {
            this.fEditor.removeReconcileListener(this);
            this.fEditor = null;
        }
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
        this.fPresenter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        IWorkingCopy element = this.fEditor.getInputCElement();
        Object object = this.fJobLock;
        synchronized (object) {
            final Job oldJob = this.fJob;
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
            if (element != null) {
                this.fJob = new Job(CEditorMessages.SemanticHighlighting_job, (ICElement)element){
                    private final /* synthetic */ ICElement val$element;
                    {
                        this.val$element = iCElement;
                        super($anonymous0);
                    }

                    protected IStatus run(final IProgressMonitor monitor) {
                        if (oldJob != null) {
                            try {
                                oldJob.join();
                            }
                            catch (InterruptedException e) {
                                CUIPlugin.log(e);
                                return Status.CANCEL_STATUS;
                            }
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        final 2 me = this;
                        ASTProvider astProvider = CUIPlugin.getDefault().getASTProvider();
                        IStatus status = astProvider.runOnAST(this.val$element, ASTProvider.WAIT_IF_OPEN, monitor, new ASTCache.ASTRunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                                SemanticHighlightingReconciler.this.reconciled(ast, true, monitor);
                                Object object = SemanticHighlightingReconciler.this.fJobLock;
                                synchronized (object) {
                                    if (SemanticHighlightingReconciler.this.fJob == me) {
                                        SemanticHighlightingReconciler.this.fJob = null;
                                    }
                                }
                                return Status.OK_STATUS;
                            }
                        });
                        return status;
                    }
                };
                this.fJob.setPriority(20);
                this.fJob.schedule();
            }
        }
    }

    public void refresh() {
        this.scheduleJob();
    }

    private class PositionCollector
    extends ASTVisitor {
        private SemanticToken fToken = new SemanticToken();
        private int fMinLocation = -1;

        public PositionCollector(boolean visitImplicitNames) {
            this.shouldVisitTranslationUnit = true;
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarators = true;
            this.shouldVisitNamespaces = true;
            this.shouldVisitImplicitNames = visitImplicitNames;
            this.shouldVisitImplicitNameAlternates = visitImplicitNames;
        }

        public int visit(IASTTranslationUnit tu) {
            IASTPreprocessorMacroExpansion[] macroExps;
            IASTPreprocessorMacroDefinition[] macroDefs;
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = macroDefs = tu.getMacroDefinitions();
            int n = macroDefs.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPreprocessorMacroDefinition macroDef = iASTPreprocessorMacroDefinitionArray[n2];
                if (macroDef.isPartOfTranslationUnitFile()) {
                    this.visitNode((IASTNode)macroDef.getName());
                }
                ++n2;
            }
            this.fMinLocation = -1;
            IASTPreprocessorMacroExpansion[] iASTPreprocessorMacroExpansionArray = macroExps = tu.getMacroExpansions();
            int n3 = macroExps.length;
            n = 0;
            while (n < n3) {
                IASTPreprocessorMacroExpansion macroExp = iASTPreprocessorMacroExpansionArray[n];
                if (macroExp.isPartOfTranslationUnitFile()) {
                    IASTName[] nestedMacroRefs;
                    IASTName macroRef = macroExp.getMacroReference();
                    this.visitNode((IASTNode)macroRef);
                    IASTName[] iASTNameArray = nestedMacroRefs = macroExp.getNestedMacroReferences();
                    int n4 = nestedMacroRefs.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IASTName nestedMacroRef = iASTNameArray[n5];
                        this.visitNode((IASTNode)nestedMacroRef);
                        ++n5;
                    }
                }
                ++n;
            }
            this.fMinLocation = -1;
            return super.visit(tu);
        }

        public int visit(IASTDeclaration declaration) {
            if (!declaration.isPartOfTranslationUnitFile()) {
                return 1;
            }
            return 3;
        }

        public int leave(IASTDeclaration declaration) {
            return 3;
        }

        public int visit(ICPPASTNamespaceDefinition namespace) {
            if (!namespace.isPartOfTranslationUnitFile()) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTDeclarator declarator) {
            return 3;
        }

        public int visit(IASTStatement statement) {
            return 3;
        }

        public int visit(IASTName name) {
            if (this.visitNode((IASTNode)name)) {
                return 1;
            }
            return 3;
        }

        private boolean visitNode(IASTNode node) {
            boolean consumed = false;
            this.fToken.update(node);
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length;
            while (i < n) {
                SemanticHighlighting semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                if (SemanticHighlightingReconciler.this.fJobHighlightings[i].isEnabled() && semanticHighlighting.consumes(this.fToken)) {
                    if (node instanceof IASTName) {
                        this.addNameLocation((IASTName)node, SemanticHighlightingReconciler.this.fJobHighlightings[i]);
                    } else {
                        this.addNodeLocation((IASTNodeLocation)node.getFileLocation(), SemanticHighlightingReconciler.this.fJobHighlightings[i]);
                    }
                    consumed = true;
                    break;
                }
                ++i;
            }
            this.fToken.clear();
            return consumed;
        }

        private void addNameLocation(IASTName name, SemanticHighlightingManager.HighlightingStyle highlightingStyle) {
            IASTImageLocation imageLocation = name.getImageLocation();
            if (imageLocation != null) {
                int offset;
                if (imageLocation.getLocationKind() != 2 && (offset = imageLocation.getNodeOffset()) >= this.fMinLocation) {
                    int length = imageLocation.getNodeLength();
                    if (offset >= 0 && length > 0) {
                        this.fMinLocation = offset + length;
                        this.addPosition(offset, length, highlightingStyle);
                    }
                }
            } else {
                IASTNodeLocation[] nodeLocations = name.getNodeLocations();
                if (nodeLocations.length == 1 && !(nodeLocations[0] instanceof IASTMacroExpansionLocation)) {
                    this.addNodeLocation(nodeLocations[0], highlightingStyle);
                }
            }
        }

        private void addNodeLocation(IASTNodeLocation nodeLocation, SemanticHighlightingManager.HighlightingStyle highlighting) {
            if (nodeLocation == null) {
                return;
            }
            int offset = nodeLocation.getNodeOffset();
            if (offset >= this.fMinLocation) {
                int length = nodeLocation.getNodeLength();
                if (offset > -1 && length > 0) {
                    this.fMinLocation = offset + length;
                    this.addPosition(offset, length, highlighting);
                }
            }
        }

        private void addPosition(int offset, int length, SemanticHighlightingManager.HighlightingStyle highlighting) {
            boolean isExisting = false;
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                SemanticHighlightingManager.HighlightedPosition position = SemanticHighlightingReconciler.this.fRemovedPositions.get(i);
                if (position != null && position.isEqual(offset, length, highlighting)) {
                    isExisting = true;
                    SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    --SemanticHighlightingReconciler.this.fNOfRemovedPositions;
                    break;
                }
                ++i;
            }
            if (!isExisting) {
                SemanticHighlightingManager.HighlightedPosition position = SemanticHighlightingReconciler.this.fJobPresenter.createHighlightedPosition(offset, length, highlighting);
                SemanticHighlightingReconciler.this.fAddedPositions.add(position);
            }
        }
    }
}

