/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.server;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.server.ConnectionEstablisher;
import org.eclipse.dstore.core.util.Receiver;

public class ServerReceiver
extends Receiver {
    private DataElement _log;
    private int _maxLog = 20;
    private int _logIndex = 0;
    private ConnectionEstablisher _connection;

    public ServerReceiver(Socket socket, ConnectionEstablisher connection) {
        super(socket, connection.getDataStore());
        this._connection = connection;
        this._log = this._dataStore.getLogRoot();
    }

    public void handleDocument(DataElement documentObject) {
        int a = 0;
        while (a < documentObject.getNestedSize()) {
            DataElement rootOutput = documentObject.get(a);
            List logged = this._log.getNestedData();
            if (logged == null) {
                this._log.addNestedData(rootOutput, false);
                ++this._logIndex;
            } else {
                if (this._logIndex > this._maxLog) {
                    this._logIndex = 0;
                }
                if (logged.size() > this._logIndex) {
                    logged.set(this._logIndex, rootOutput);
                } else {
                    logged.add(this._logIndex, rootOutput);
                }
                ++this._logIndex;
            }
            if (rootOutput.getName().equals("C_EXIT")) {
                this.finish();
            } else {
                this._dataStore.command(rootOutput);
            }
            ++a;
        }
    }

    public void finish() {
        this._dataStore.setConnected(false);
        super.finish();
        this._connection.finished(this);
        try {
            this.socket().close();
        }
        catch (IOException e) {
            if (this._dataStore.getClient() != null) {
                this._dataStore.getClient().getLogger().logError(this.getClass().toString(), e.toString(), e);
            }
            System.out.println(e);
        }
    }

    public void handleError(Throwable e) {
        if (this._dataStore.getClient() != null) {
            this._dataStore.getClient().getLogger().logError(this.getClass().toString(), e.toString(), e);
        }
        System.out.println("RECEIVER ERROR");
        e.printStackTrace();
        System.out.println(e);
        this._connection.finished(this);
        try {
            this.socket().close();
        }
        catch (IOException IOe) {
            System.out.println(IOe);
        }
    }
}

