/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.viewer;

import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DocumentAnnotationUpdate;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualDocument;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementAnnotationProvider;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementAnnotationUpdate;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentPresentation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.progress.UIJob;

public class DocumentAnnotationProvider {
    private VirtualDocument fDocument;

    public DocumentAnnotationProvider(VirtualDocument document) {
        this.fDocument = document;
    }

    public void dispose() {
        this.fDocument = null;
    }

    public void update(Object parent, Object[] elements, IDocumentPresentation context) {
        IDocumentElementAnnotationProvider annotationProvider = this.getAnnotationAdapter(parent);
        if (annotationProvider != null) {
            Object root = this.getDocument().getContentProvider().getRoot();
            Object base = this.getDocument().getContentProvider().getBase();
            IDocumentElementAnnotationUpdate[] updates = new DocumentAnnotationUpdate[elements.length];
            int i = 0;
            while (i < elements.length) {
                updates[i] = new DocumentAnnotationUpdate(this, context, root, base, elements[i], i);
                ++i;
            }
            annotationProvider.update(updates);
        }
    }

    public void update(Object parent, Object element, int index, IDocumentPresentation context) {
        IDocumentElementAnnotationProvider annotationProvider = this.getAnnotationAdapter(element);
        if (annotationProvider != null) {
            Object root = this.getDocument().getContentProvider().getRoot();
            Object base = this.getDocument().getContentProvider().getBase();
            annotationProvider.update(new DocumentAnnotationUpdate[]{new DocumentAnnotationUpdate(this, context, root, base, element, index)});
        }
    }

    public void completed(DocumentAnnotationUpdate update) {
        if (update.isCanceled()) {
            return;
        }
        final int index = update.getIndex();
        final Annotation[] annotations = update.getAnnotations();
        UIJob uiJob = new UIJob("Add annotations"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                VirtualDocument document = DocumentAnnotationProvider.this.getDocument();
                if (document != null) {
                    DocumentAnnotationProvider.this.getDocument().updateAnnotations(index, annotations);
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.schedule();
    }

    protected IDocumentElementAnnotationProvider getAnnotationAdapter(Object element) {
        IDocumentElementAnnotationProvider adapter = null;
        if (element instanceof IDocumentElementAnnotationProvider) {
            adapter = (IDocumentElementAnnotationProvider)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapter = (IDocumentElementAnnotationProvider)adaptable.getAdapter(IDocumentElementAnnotationProvider.class);
        }
        return adapter;
    }

    protected VirtualDocument getDocument() {
        return this.fDocument;
    }
}

