/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDIDebugger;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.cdt.debug.internal.core.CDebugAdapter;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DebugConfiguration
implements ICDebugConfiguration {
    private IConfigurationElement fElement;
    private HashSet fModes;
    private HashSet fCPUs;
    private String[] fCoreExt;

    public DebugConfiguration(IConfigurationElement element) {
        this.fElement = element;
    }

    private IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    @Override
    public ICDebugger getDebugger() throws CoreException {
        Object debugger = this.getConfigurationElement().createExecutableExtension("class");
        if (debugger instanceof ICDebugger) {
            return (ICDebugger)debugger;
        }
        throw new CoreException((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), -1, InternalDebugCoreMessages.getString("DebugConfiguration.0"), null));
    }

    @Override
    public ICDIDebugger createDebugger() throws CoreException {
        Object debugger = this.getConfigurationElement().createExecutableExtension("class");
        if (debugger instanceof ICDIDebugger) {
            return (ICDIDebugger)debugger;
        }
        return new CDebugAdapter((ICDebugger)debugger);
    }

    @Override
    public String getName() {
        String name = this.getConfigurationElement().getAttribute("name");
        return name != null ? name : "";
    }

    @Override
    public String getID() {
        return this.getConfigurationElement().getAttribute("id");
    }

    @Override
    public String getPlatform() {
        String platform = this.getConfigurationElement().getAttribute("platform");
        if (platform == null) {
            return "*";
        }
        return platform;
    }

    @Override
    public String[] getCPUList() {
        return this.getCPUs().toArray(new String[0]);
    }

    @Override
    public String[] getModeList() {
        return this.getModes().toArray(new String[0]);
    }

    @Override
    public boolean supportsMode(String mode) {
        return this.getModes().contains(mode);
    }

    @Override
    public boolean supportsCPU(String cpu) {
        String nativeCPU = Platform.getOSArch();
        boolean ret = false;
        if (nativeCPU.startsWith(cpu) || nativeCPU.equalsIgnoreCase("powerpc") && (cpu.equalsIgnoreCase("ppc") || cpu.equalsIgnoreCase("xcoff32") || cpu.equalsIgnoreCase("xcoff64"))) {
            ret = this.getCPUs().contains("native");
        }
        return ret || this.getCPUs().contains(cpu) || this.getCPUs().contains("*");
    }

    protected Set getModes() {
        if (this.fModes == null) {
            String modes = this.getConfigurationElement().getAttribute("modes");
            if (modes == null) {
                return new HashSet(0);
            }
            StringTokenizer tokenizer = new StringTokenizer(modes, ",");
            this.fModes = new HashSet(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.fModes.add(tokenizer.nextToken().trim());
            }
        }
        return this.fModes;
    }

    protected Set getCPUs() {
        if (this.fCPUs == null) {
            String cpus = this.getConfigurationElement().getAttribute("cpu");
            if (cpus == null) {
                this.fCPUs = new HashSet(1);
                this.fCPUs.add("native");
            } else {
                String nativeCPU = Platform.getOSArch();
                StringTokenizer tokenizer = new StringTokenizer(cpus, ",");
                this.fCPUs = new HashSet(tokenizer.countTokens());
                while (tokenizer.hasMoreTokens()) {
                    String cpu = tokenizer.nextToken().trim();
                    this.fCPUs.add(cpu);
                    if (!nativeCPU.startsWith(cpu)) continue;
                    this.fCPUs.add("native");
                }
            }
        }
        return this.fCPUs;
    }

    @Override
    public String[] getCoreFileExtensions() {
        if (this.fCoreExt == null) {
            ArrayList<String> exts = new ArrayList<String>();
            String cexts = this.getConfigurationElement().getAttribute("coreFileFilter");
            if (cexts != null) {
                StringTokenizer tokenizer = new StringTokenizer(cexts, ",");
                while (tokenizer.hasMoreTokens()) {
                    String ext = tokenizer.nextToken().trim();
                    exts.add(ext);
                }
            }
            exts.add("*");
            this.fCoreExt = exts.toArray(new String[exts.size()]);
        }
        return this.fCoreExt;
    }

    @Override
    public String[] getSupportedBuildConfigPatterns() {
        IConfigurationElement[] patternElems = this.fElement.getChildren("buildIdPattern");
        String[] patterns = new String[patternElems.length];
        int i = 0;
        while (i < patternElems.length) {
            patterns[i] = patternElems[i].getAttribute("pattern");
            ++i;
        }
        return patterns;
    }
}

