/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static final BigInteger Max8Bit = BigInteger.valueOf(127L).add(BigInteger.ONE);
    public static final BigInteger Max16Bit = BigInteger.valueOf(32767L).add(BigInteger.ONE);
    public static final BigInteger Max32Bit = BigInteger.valueOf(Integer.MAX_VALUE).add(BigInteger.ONE);
    public static final BigInteger Max64Bit = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);
    public static final int Arch8Bit = 8;
    public static final int Arch16Bit = 16;
    public static final int Arch32Bit = 32;
    public static final int Arch64Bit = 64;

    public static long convertbig2little(long value) {
        long a = value >> 24;
        long b = (value & 0xFFFFFFFF00FF0000L) >> 8;
        long c = (value & 0xFFFFFFFF0000FF00L) << 8;
        long d = (value & 0xFFFFFFFF000000FFL) << 24;
        return a | b | c | d;
    }

    private static Matcher getLineMatcher(String fulltext) {
        String patternStr = "^(.*)$";
        Pattern pattern = Pattern.compile(patternStr, 8);
        return pattern.matcher(fulltext);
    }

    public static String getTextLine(int number, String fulltext) {
        Matcher matcher = Utils.getLineMatcher(fulltext);
        int i = 1;
        while (i <= number) {
            if (matcher.find() && i == number) {
                return matcher.group(1);
            }
            ++i;
        }
        return "";
    }

    public static String getFirstNotEmptyTextLine(String fulltext) {
        Matcher matcher = Utils.getLineMatcher(fulltext);
        while (matcher.find()) {
            if (matcher.group(1).equals("")) continue;
            return matcher.group(1);
        }
        return "";
    }

    public static int countTextLines(String fulltext) {
        int i = 0;
        Matcher matcher = Utils.getLineMatcher(fulltext);
        while (matcher.find()) {
            ++i;
        }
        return i;
    }

    public static int getBitFromValue(int bitnr, long value) {
        return (int)((value >> bitnr) % 2L);
    }

    public static String longtobinarystring(long wert, int bits) {
        StringBuilder text = new StringBuilder();
        int i = bits;
        while (i > 0) {
            text.append(Math.abs(wert % 2L));
            wert /= 2L;
            --i;
        }
        text.reverse();
        return text.toString();
    }

    public static String longtoHexString(long wert, int bits) {
        int hexdigits = bits / 4;
        if (bits % 4 != 0) {
            ++hexdigits;
        }
        StringBuilder hex = new StringBuilder();
        hex.append("0x");
        String x = Long.toHexString(wert);
        int missingLen = hexdigits - x.length();
        int i = 0;
        while (i < missingLen) {
            hex.append('0');
            ++i;
        }
        hex.append(x.toUpperCase());
        return hex.toString();
    }

    public static BigInteger makeUnsigned(BigInteger signed, int bitdepth) {
        BigInteger unsigned = signed;
        if (signed == null) {
            return unsigned;
        }
        if (signed.compareTo(BigInteger.ZERO) < 0) {
            BigInteger MaxSignedValue;
            switch (bitdepth) {
                case 8: {
                    MaxSignedValue = Max8Bit;
                    break;
                }
                case 16: {
                    MaxSignedValue = Max16Bit;
                    break;
                }
                case 32: {
                    MaxSignedValue = Max32Bit;
                    break;
                }
                case 64: {
                    MaxSignedValue = Max64Bit;
                    break;
                }
                default: {
                    MaxSignedValue = Max32Bit;
                }
            }
            unsigned = MaxSignedValue.add(MaxSignedValue.add(signed));
        }
        return unsigned;
    }
}

