/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.cdt.embsysregview.views.Interpretation;
import org.eclipse.cdt.embsysregview.views.TreeField;
import org.eclipse.cdt.embsysregview.views.Utils;

public class Interpretations {
    private ArrayList<Interpretation> interpretations = new ArrayList();
    private TreeField treeField;

    public void setTreeField(TreeField treeField) {
        this.treeField = treeField;
    }

    public void addInterpretation(long value, String interpretation) {
        this.interpretations.add(new Interpretation(value, interpretation));
    }

    public String getInterpretation(long value) {
        for (Interpretation i : this.interpretations) {
            if (i.getValue() != value) continue;
            return i.getInterpretation();
        }
        return "";
    }

    public long getValue(String interpretation) {
        for (Interpretation i : this.interpretations) {
            if (!i.getInterpretation().equals(interpretation)) continue;
            return i.getValue();
        }
        return -1L;
    }

    public String[] getInterpretations() {
        Iterator<Interpretation> it = this.interpretations.iterator();
        int j = 1;
        String[] ret = new String[this.interpretations.size() + 1];
        ret[0] = Utils.longtoHexString(this.treeField.getValue(), this.treeField.getBitLength());
        while (it.hasNext()) {
            Interpretation i = it.next();
            ret[j] = i.getInterpretation();
            ++j;
        }
        return ret;
    }

    public void sort() {
        Collections.sort(this.interpretations);
    }

    public boolean containsKey(long value) {
        for (Interpretation i : this.interpretations) {
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean hasInterpretations() {
        return !this.interpretations.isEmpty();
    }
}

