/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.MIDataReadMemory;
import org.eclipse.cdt.debug.mi.core.command.MIDataWriteMemory;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataWriteMemoryInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.embsysregview.views.Utils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.DebugUITools;

public class GDBSessionTranslator {
    public static int maxWaitTimeInInMilliseconds = 5000;

    public static Object getSession() {
        return GDBSessionTranslator.getSession(DebugUITools.getDebugContext());
    }

    public static Object getSession(Object context) {
        Object session = null;
        if (context != null) {
            Target miTarget;
            if (context instanceof DsfSession || context instanceof MISession) {
                session = context;
            }
            if (context instanceof IProcess) {
                context = ((IProcess)context).getLaunch();
            }
            if (context instanceof GdbLaunch) {
                session = ((GdbLaunch)context).getSession();
            } else if (context instanceof IDMVMContext) {
                IDMContext dmc = ((IDMVMContext)context).getDMContext();
                if (dmc == null) {
                    return null;
                }
                session = DsfSession.getSession((String)dmc.getSessionId());
            } else if ((context instanceof CDebugElement || context instanceof AbstractCLaunchDelegate.CLaunch) && (miTarget = GDBSessionTranslator.getMiTarget(GDBSessionTranslator.getCDebugTarget(context))) != null) {
                session = miTarget.getMISession();
            }
        }
        if (session != null && GDBSessionTranslator.isSessionTerminated(session)) {
            return null;
        }
        return session;
    }

    public static Target getMiTarget(CDebugTarget debugtarget) {
        ICDITarget mitarget;
        if (debugtarget == null) {
            return null;
        }
        ICDISession cdiSession = debugtarget.getCDISession();
        if (cdiSession != null && (mitarget = debugtarget.getCDITarget()) != null && mitarget instanceof Target) {
            return (Target)mitarget;
        }
        return null;
    }

    public static boolean isSessionTerminated(Object session) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch l = launches[i];
            if (session == GDBSessionTranslator.getSession(l)) {
                return l.isTerminated();
            }
            ++i;
        }
        return true;
    }

    public static Object getSession(ILaunch launch) {
        if (launch != null) {
            Target miTarget;
            CDebugTarget target;
            if (launch instanceof GdbLaunch) {
                return ((GdbLaunch)launch).getSession();
            }
            if (launch instanceof AbstractCLaunchDelegate.CLaunch && (target = GDBSessionTranslator.getCDebugTarget(launch)) != null && (miTarget = GDBSessionTranslator.getMiTarget(target)) != null) {
                return miTarget.getMISession();
            }
        }
        return null;
    }

    public static CDebugTarget getCDebugTarget(Object context) {
        IDebugTarget target = null;
        if (context == null) {
            return null;
        }
        if (context instanceof IProcess) {
            context = ((IProcess)context).getLaunch();
        }
        if (context instanceof AbstractCLaunchDelegate.CLaunch) {
            target = ((AbstractCLaunchDelegate.CLaunch)context).getDebugTarget();
        } else if (context instanceof CDebugElement) {
            target = ((CDebugElement)context).getDebugTarget();
        }
        if (target == null) {
            return null;
        }
        if (target instanceof CDebugTarget) {
            return (CDebugTarget)target;
        }
        return null;
    }

    public static int writeMemory(Object session, String address, String value, int iByteCount) throws TimeoutException {
        if (session == null) {
            return -1;
        }
        if (session instanceof MISession) {
            return GDBSessionTranslator.writeMemory((MISession)session, address, value, iByteCount);
        }
        if (session instanceof DsfSession) {
            return GDBSessionTranslator.writeMemory((DsfSession)session, address, value, iByteCount, maxWaitTimeInInMilliseconds);
        }
        return -1;
    }

    public static int writeMemory(String address, String value, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.writeMemory(GDBSessionTranslator.getSession(), address, value, iByteCount);
    }

    public static int writeMemory(Object session, long address, long value, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.writeMemory(session, Long.toString(address), "0x" + Long.toHexString(value), iByteCount);
    }

    public static int writeMemory(long address, long value, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.writeMemory(GDBSessionTranslator.getSession(), address, value, iByteCount);
    }

    public static long readMemory(Object session, String address, int iByteCount) throws TimeoutException {
        if (session == null) {
            return -1L;
        }
        if (session instanceof MISession) {
            return GDBSessionTranslator.readMemory((MISession)session, address, iByteCount);
        }
        if (session instanceof DsfSession) {
            return GDBSessionTranslator.readMemory((DsfSession)session, address, iByteCount, maxWaitTimeInInMilliseconds);
        }
        return -1L;
    }

    public static long readMemory(String address, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.readMemory(GDBSessionTranslator.getSession(), address, iByteCount);
    }

    public static long readMemory(Object session, long address, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.readMemory(session, Long.toString(address), iByteCount);
    }

    public static long readMemory(long address, int iByteCount) throws TimeoutException {
        return GDBSessionTranslator.readMemory(GDBSessionTranslator.getSession(), address, iByteCount);
    }

    public static int writeMemory(MISession session, String address, String value, int iByteCount) {
        int ret;
        try {
            int format = value.contains("x") ? 0 : 3;
            MIDataWriteMemory commandDataWriteMemory = session.getCommandFactory().createMIDataWriteMemory(0L, address, format, iByteCount, value);
            session.postCommand((Command)commandDataWriteMemory);
            ret = !commandDataWriteMemory.getMIOutput().getMIResultRecord().getResultClass().matches("error") ? iByteCount : -1;
        }
        catch (MIException mIException) {
            ret = -1;
        }
        return ret;
    }

    public static long readMemory(MISession session, String address, int iByteCount) {
        long ret = -1L;
        try {
            MIDataReadMemory commandDataReadMemory = session.getCommandFactory().createMIDataReadMemory(0L, address, 0, iByteCount, 1, 1, null);
            session.postCommand((Command)commandDataReadMemory);
            ret = !commandDataReadMemory.getMIOutput().getMIResultRecord().getResultClass().matches("error") ? commandDataReadMemory.getMIDataReadMemoryInfo().getMemories()[0].getData()[0] : -1L;
        }
        catch (MIException mIException) {
            ret = -1L;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static int writeMemory(DsfSession session, String address, String value, int iByteCount, int maximumTimeToWait) throws TimeoutException {
        if (!session.isActive()) {
            return -1;
        }
        ret = -1;
        tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), session.getId());
        fGdb = (IGDBControl)tracker.getService(IGDBControl.class);
        if (fGdb == null) {
            return -1;
        }
        factory = fGdb.getCommandFactory();
        format = value.contains("x") != false ? 0 : 3;
        info_wm = factory.createMIDataWriteMemory((IDMContext)fGdb.getContext(), 0L, address, format, iByteCount, value);
        query = new Query<MIDataWriteMemoryInfo>(){

            protected void execute(final DataRequestMonitor<MIDataWriteMemoryInfo> rm) {
                fGdb.queueCommand(info_wm, (DataRequestMonitor)new DataRequestMonitor<MIDataWriteMemoryInfo>((Executor)fGdb.getExecutor(), null){

                    protected void handleCompleted() {
                        rm.setData((Object)((MIDataWriteMemoryInfo)this.getData()));
                        rm.done();
                    }
                });
            }
        };
        ImmediateExecutor.getInstance().execute((Runnable)query);
        data = null;
        try {
            try {
                data = (MIDataWriteMemoryInfo)query.get((long)maximumTimeToWait, TimeUnit.MILLISECONDS);
                if (data.isError()) {
                    data = null;
                }
                ret = data != null ? iByteCount : -1;
            }
            catch (InterruptedException v0) {
                tracker.dispose();
            }
            catch (ExecutionException v1) {
                ** try [egrp 2[TRYBLOCK] [4 : 172->173)] { 
lbl26:
                // 1 sources

                tracker.dispose();
            }
            catch (TimeoutException v2) {
                message = "writeMemory - failed, ErrorMessage: waiting time of " + maximumTimeToWait + " ms passed";
                throw new TimeoutException(message);
lbl-1000:
                // 2 sources

                {
                    catch (Throwable var14_14) {
                        throw var14_14;
                    }
                }
            }
        }
        finally {
            tracker.dispose();
        }
        return ret;
    }

    public static long readMemory(DsfSession session, String address, int iByteCount, int maximumTimeToWait) throws TimeoutException {
        long ret;
        block20: {
            if (!session.isActive()) {
                return -1L;
            }
            ret = -1L;
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), session.getId());
            final IGDBControl fGdb = (IGDBControl)tracker.getService(IGDBControl.class);
            if (fGdb == null) {
                return -1L;
            }
            CommandFactory factory = fGdb.getCommandFactory();
            final ICommand info_rm = factory.createMIDataReadMemory((IDMContext)fGdb.getContext(), 0L, address, 0, 1, 1, iByteCount, null);
            Query<MIDataReadMemoryInfo> query = new Query<MIDataReadMemoryInfo>(){

                protected void execute(final DataRequestMonitor<MIDataReadMemoryInfo> rm) {
                    fGdb.queueCommand(info_rm, (DataRequestMonitor)new DataRequestMonitor<MIDataReadMemoryInfo>((Executor)fGdb.getExecutor(), null){

                        protected void handleCompleted() {
                            rm.setData((Object)((MIDataReadMemoryInfo)this.getData()));
                            rm.done();
                        }
                    });
                }
            };
            ImmediateExecutor.getInstance().execute((Runnable)query);
            MIDataReadMemoryInfo data = null;
            try {
                data = (MIDataReadMemoryInfo)query.get((long)maximumTimeToWait, TimeUnit.MILLISECONDS);
                if (data.isError()) {
                    data = null;
                }
                if (data == null) break block20;
                MIInfo info = GDBSessionTranslator.postCLICommand(session, "show endian", maximumTimeToWait);
                if (info == null) {
                    return -1L;
                }
                try {
                    boolean endianessknown = true;
                    boolean isBigEndian = info.getMIOutput().toString().contains("big endian");
                    boolean isLittleEndian = info.getMIOutput().toString().contains("little endian");
                    if (!isBigEndian && !isLittleEndian || isBigEndian && isLittleEndian) {
                        endianessknown = false;
                    }
                    MemoryByte[] bytes = data.getMIMemoryBlock();
                    if (endianessknown) {
                        int i;
                        byte[] arraybytes = new byte[bytes.length];
                        if (!isBigEndian) {
                            i = 0;
                            while (i < bytes.length) {
                                arraybytes[i] = bytes[bytes.length - 1 - i].getValue();
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < bytes.length) {
                                arraybytes[i] = bytes[i].getValue();
                                ++i;
                            }
                        }
                        BigInteger big = new BigInteger(arraybytes);
                        big = Utils.makeUnsigned(big, 32);
                        ret = new Long(big.toString());
                        break block20;
                    }
                    ret = -1L;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException timeoutException) {
                    String message = "readMemory - failed, ErrorMessage: waiting time of " + maximumTimeToWait + " ms passed";
                    throw new TimeoutException(message);
                }
            }
            finally {
                tracker.dispose();
            }
        }
        return ret;
    }

    public static MIInfo postCLICommand(DsfSession session, String cLICommand, int maximumTimeToWait) throws TimeoutException {
        if (!session.isActive()) {
            throw new TimeoutException("Session is terminated");
        }
        DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), session.getId());
        IGDBControl fGdb = (IGDBControl)tracker.getService(IGDBControl.class);
        if (fGdb == null) {
            return null;
        }
        CLICommand info = new CLICommand((IDMContext)fGdb.getContext(), cLICommand);
        return GDBSessionTranslator.executeQuery((ICommand<MIInfo>)info, "postCLICommand", "cLICommand=" + cLICommand, session, tracker, fGdb, maximumTimeToWait);
    }

    private static MIInfo executeQuery(final ICommand<MIInfo> command, String functionName, String details, DsfSession session, DsfServicesTracker tracker, final IGDBControl fGdb, int maximumTimeToWait) throws TimeoutException {
        Query<MIInfo> query = new Query<MIInfo>(){

            protected void execute(final DataRequestMonitor<MIInfo> rm) {
                fGdb.queueCommand(command, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)fGdb.getExecutor(), null){

                    protected void handleCompleted() {
                        rm.setData((Object)((MIInfo)this.getData()));
                        rm.done();
                    }
                });
            }
        };
        ImmediateExecutor.getInstance().execute((Runnable)query);
        MIInfo data = null;
        try {
            data = (MIInfo)query.get((long)maximumTimeToWait, TimeUnit.MILLISECONDS);
            if (data.isError()) {
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {
            String message = String.valueOf(functionName) + " - failed, ErrorMessage: waiting time of " + maximumTimeToWait + " ms passed";
            throw new TimeoutException(message);
        }
        finally {
            tracker.dispose();
        }
        return data;
    }
}

