/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataReadMemory;
import org.eclipse.cdt.debug.mi.core.command.MIDataWriteMemory;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIMemory;
import org.eclipse.cdt.embsysregview.views.GDBInterface;
import org.eclipse.cdt.embsysregview.views.IGDBInterfaceSuspendListener;
import org.eclipse.cdt.embsysregview.views.IGDBInterfaceTerminateListener;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;

public class GDBInterfaceStandard
extends GDBInterface
implements IDebugEventSetListener {
    private MISession miSession = null;
    private List<IGDBInterfaceSuspendListener> suspendListener = new ArrayList<IGDBInterfaceSuspendListener>();
    private List<IGDBInterfaceTerminateListener> terminateListener = new ArrayList<IGDBInterfaceTerminateListener>();

    public GDBInterfaceStandard() {
        if (!this.hasActiveDebugSession()) {
            this.init();
        }
    }

    @Override
    public void addSuspendListener(IGDBInterfaceSuspendListener listener) {
        this.suspendListener.add(listener);
    }

    @Override
    public void addterminateListener(IGDBInterfaceTerminateListener listener) {
        this.terminateListener.add(listener);
    }

    @Override
    public void dispose() {
        this.miSession = null;
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    private void init() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    @Override
    public boolean hasActiveDebugSession() {
        return this.miSession != null;
    }

    @Override
    public long readMemory(long laddress, int iByteCount) {
        if (!this.hasActiveDebugSession()) {
            return -1L;
        }
        long value = -1L;
        CommandFactory factory = this.miSession.getCommandFactory();
        MIDataReadMemory mem = factory.createMIDataReadMemory(0L, Long.toString(laddress), 0, iByteCount, 1, 1, null);
        try {
            this.miSession.postCommand((Command)mem);
            MIDataReadMemoryInfo info = mem.getMIDataReadMemoryInfo();
            if (info != null) {
                MIMemory[] memories = info.getMemories();
                long[] val = memories[0].getData();
                value = val[0];
            }
        }
        catch (MIException mIException) {}
        return value;
    }

    @Override
    public int writeMemory(long laddress, long lvalue, int iByteCount) {
        if (!this.hasActiveDebugSession()) {
            return 0;
        }
        CommandFactory factory = this.miSession.getCommandFactory();
        String value = "0x" + Long.toHexString(lvalue);
        String address = Long.toString(laddress);
        MIDataWriteMemory mw = factory.createMIDataWriteMemory(0L, address, 0, iByteCount, value);
        try {
            this.miSession.postCommand((Command)mw);
            MIInfo info = mw.getMIInfo();
        }
        catch (MIException mIException) {}
        return iByteCount;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            if (event.getKind() == 2 && source instanceof CDebugTarget) {
                System.out.println("DebugEvent " + event.toString());
                CDebugTarget debugTarget = (CDebugTarget)source;
                ICDISession cdiSession = debugTarget.getCDISession();
                ICDITarget[] targets = cdiSession.getTargets();
                ICDITarget cdiTarget = null;
                int i = 0;
                while (i < targets.length) {
                    ICDITarget cdiTargetCandidate = targets[i];
                    if (cdiTargetCandidate instanceof Target) {
                        cdiTarget = cdiTargetCandidate;
                        break;
                    }
                    ++i;
                }
                if (cdiTarget != null) {
                    Target miTarget = (Target)cdiTarget;
                    this.miSession = miTarget.getMISession();
                }
                for (IGDBInterfaceSuspendListener listener : this.suspendListener) {
                    listener.gdbSuspendListener();
                }
            }
            if (event.getKind() == 8) {
                for (IGDBInterfaceTerminateListener listener : this.terminateListener) {
                    listener.gdbTerminateListener();
                }
            }
            ++n2;
        }
    }
}

