/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.embsysregview.views.GDBEventProvider;
import org.eclipse.cdt.embsysregview.views.GDBInterface;
import org.eclipse.cdt.embsysregview.views.GDBSessionTranslator;
import org.eclipse.cdt.embsysregview.views.IGDBInterfaceSuspendListener;
import org.eclipse.cdt.embsysregview.views.IGDBInterfaceTerminateListener;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;

public class GDBEventListener
extends GDBInterface
implements IDebugEventSetListener {
    private Object currentSession = null;
    private GDBEventProvider provider = null;
    private List<IGDBInterfaceSuspendListener> suspendListener = new ArrayList<IGDBInterfaceSuspendListener>();
    private List<IGDBInterfaceTerminateListener> terminateListener = new ArrayList<IGDBInterfaceTerminateListener>();

    public GDBEventListener() {
        if (!this.hasActiveDebugSession()) {
            this.init();
        }
    }

    @Override
    public void addSuspendListener(IGDBInterfaceSuspendListener listener) {
        this.suspendListener.add(listener);
    }

    @Override
    public void addterminateListener(IGDBInterfaceTerminateListener listener) {
        this.terminateListener.add(listener);
    }

    @Override
    public void dispose() {
        this.currentSession = null;
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.provider.dispose();
        this.provider = null;
    }

    private void init() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.provider = new GDBEventProvider();
    }

    @Override
    public boolean hasActiveDebugSession() {
        return this.currentSession != null;
    }

    @Override
    public long readMemory(long laddress, int iByteCount) {
        try {
            return GDBSessionTranslator.readMemory(this.currentSession, laddress, iByteCount);
        }
        catch (TimeoutException e) {
            System.out.println(e);
            return -1L;
        }
    }

    @Override
    public int writeMemory(long laddress, long lvalue, int iByteCount) {
        try {
            return GDBSessionTranslator.writeMemory(this.currentSession, laddress, lvalue, iByteCount);
        }
        catch (TimeoutException e) {
            System.out.println(e);
            return -1;
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            Object sourceSession = null;
            Object currentSession = GDBSessionTranslator.getSession();
            sourceSession = source instanceof GDBEventProvider.DebugContextChangedDebugEvent ? ((GDBEventProvider.DebugContextChangedDebugEvent)source).getSession() : (source instanceof GDBEventProvider.DsfSessionDebugEvent ? ((GDBEventProvider.DsfSessionDebugEvent)source).getSession() : GDBSessionTranslator.getSession(source));
            if (currentSession != this.currentSession) {
                this.currentSession = currentSession;
                if (this.currentSession != null) {
                    for (IGDBInterfaceSuspendListener iGDBInterfaceSuspendListener : this.suspendListener) {
                        iGDBInterfaceSuspendListener.gdbSuspendListener();
                    }
                } else {
                    for (IGDBInterfaceTerminateListener iGDBInterfaceTerminateListener : this.terminateListener) {
                        iGDBInterfaceTerminateListener.gdbTerminateListener();
                    }
                }
            }
            if (sourceSession == null || sourceSession != currentSession) {
                return;
            }
            if (event.getKind() == 2) {
                for (IGDBInterfaceSuspendListener iGDBInterfaceSuspendListener : this.suspendListener) {
                    iGDBInterfaceSuspendListener.gdbSuspendListener();
                }
            }
            if (event.getKind() == 8) {
                for (IGDBInterfaceTerminateListener iGDBInterfaceTerminateListener : this.terminateListener) {
                    iGDBInterfaceTerminateListener.gdbTerminateListener();
                }
            }
            ++n2;
        }
    }
}

