/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.views;

import java.net.URL;
import java.text.ParseException;
import net.miginfocom.swt.MigLayout;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.parser.RegisterXMLParser;
import org.eclipse.cdt.embsysregview.preferences.PreferencePageEmbSys;
import org.eclipse.cdt.embsysregview.preferences.PreferencePageEmbSysBehavior;
import org.eclipse.cdt.embsysregview.views.BinaryButtonsCellEditor;
import org.eclipse.cdt.embsysregview.views.GDBEventListener;
import org.eclipse.cdt.embsysregview.views.GDBInterface;
import org.eclipse.cdt.embsysregview.views.HexCellEditorValidator;
import org.eclipse.cdt.embsysregview.views.IGDBInterfaceSuspendListener;
import org.eclipse.cdt.embsysregview.views.IGDBInterfaceTerminateListener;
import org.eclipse.cdt.embsysregview.views.TreeElement;
import org.eclipse.cdt.embsysregview.views.TreeField;
import org.eclipse.cdt.embsysregview.views.TreeGroup;
import org.eclipse.cdt.embsysregview.views.TreeParent;
import org.eclipse.cdt.embsysregview.views.TreeRegister;
import org.eclipse.cdt.embsysregview.views.TreeRegisterGroup;
import org.eclipse.cdt.embsysregview.views.Utils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.jdom.JDOMException;
import org.osgi.framework.Bundle;

public class EmbSysRegView
extends ViewPart
implements IGDBInterfaceSuspendListener,
IGDBInterfaceTerminateListener {
    protected TreeViewer viewer;
    private TreeParent invisibleRoot;
    private Label infoLabel;
    private Button configButton;
    private Composite header;
    private Action doubleClickAction;
    private Image selectedImage;
    private Image unselectedImage;
    private Image selectedFieldImage;
    private Image unselectedFieldImage;
    private Image infoImage;
    private Image interpretationImage;
    private Image configButtonImage;
    public static GDBInterface GDBi;
    private TreeElement currentEditedElement = null;

    public EmbSysRegView() {
        GDBi = new GDBEventListener();
        GDBi.addSuspendListener(this);
        GDBi.addterminateListener(this);
    }

    private void updateInfoLabel() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String store_architecture = store.getString("architecture");
        String store_vendor = store.getString("vendor");
        String store_chip = store.getString("chip");
        String store_board = store.getString("board");
        if (this.invisibleRoot == null || !this.invisibleRoot.hasChildren()) {
            this.infoLabel.setText("ERROR: Please select a chip using the preference page (c++/Debug/EmbSys Register View)");
        } else if (store_board == "") {
            this.infoLabel.setText("Arch: " + store_architecture + "  Vendor: " + store_vendor + "  Chip: " + store_chip);
        } else {
            this.infoLabel.setText("Arch: " + store_architecture + "  Vendor: " + store_vendor + "  Chip: " + store_chip + "  Board: " + store_board);
        }
    }

    public void createPartControl(final Composite parent) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.cdt.embsysregview");
        URL fileURL = bundle.getEntry("icons/selected_register.png");
        URL fileURL2 = bundle.getEntry("icons/unselected_register.png");
        URL fileURL3 = bundle.getEntry("icons/selected_field.png");
        URL fileURL4 = bundle.getEntry("icons/unselected_field.png");
        URL fileURL5 = bundle.getEntry("icons/info.png");
        URL fileURL6 = bundle.getEntry("icons/interpretation.png");
        URL fileURL7 = bundle.getEntry("icons/config.png");
        try {
            this.selectedImage = new Image((Device)parent.getDisplay(), fileURL.openStream());
            this.unselectedImage = new Image((Device)parent.getDisplay(), fileURL2.openStream());
            this.selectedFieldImage = new Image((Device)parent.getDisplay(), fileURL3.openStream());
            this.unselectedFieldImage = new Image((Device)parent.getDisplay(), fileURL4.openStream());
            this.infoImage = new Image((Device)parent.getDisplay(), fileURL5.openStream());
            this.interpretationImage = new Image((Device)parent.getDisplay(), fileURL6.openStream());
            this.configButtonImage = new Image((Device)parent.getDisplay(), fileURL7.openStream());
        }
        catch (Exception exception) {
            this.selectedImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
            this.unselectedImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
            this.selectedFieldImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
            this.unselectedFieldImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
            this.infoImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
            this.interpretationImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
            this.configButtonImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
        }
        parent.setLayout((Layout)new MigLayout("fill", "", ""));
        this.header = new Composite(parent, 0);
        this.header.setLayoutData((Object)"dock north,height 16px,width 100%,wmin 0,hmin 16,gap 0 0 -5 0");
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginLeft = -1;
        rowLayout.marginRight = 0;
        rowLayout.marginTop = -1;
        rowLayout.marginBottom = 0;
        rowLayout.fill = true;
        rowLayout.wrap = false;
        rowLayout.spacing = 5;
        this.header.setLayout((Layout)rowLayout);
        this.configButton = new Button(this.header, 0x800000);
        this.configButton.setImage(this.configButtonImage);
        this.configButton.setSize(17, 17);
        RowData data = new RowData();
        data.width = 17;
        data.height = 17;
        this.configButton.setLayoutData((Object)data);
        this.configButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                PreferencePageEmbSys page = new PreferencePageEmbSys();
                page.setTitle("EmbSysRegView");
                PreferencePageEmbSysBehavior page2 = new PreferencePageEmbSysBehavior();
                page2.setTitle("Behavior");
                PreferenceManager mgr = new PreferenceManager();
                PreferenceNode node = new PreferenceNode("1", (IPreferencePage)page);
                node.add((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)page2));
                mgr.addToRoot((IPreferenceNode)node);
                PreferenceDialog dialog = new PreferenceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), mgr);
                dialog.create();
                dialog.setMessage(page.getTitle());
                dialog.open();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.infoLabel = new Label(this.header, 0);
        this.viewer = new TreeViewer(parent, 66304);
        this.viewer.getControl().setLayoutData((Object)"height 100%,width 100%,hmin 0,wmin 0");
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setHeaderVisible(true);
        TreeViewerColumn column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(250);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Register");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Color getForeground(Object element) {
                if (element instanceof TreeRegister && ((TreeRegister)element).isRetrievalActive()) {
                    return parent.getShell().getDisplay().getSystemColor(6);
                }
                if (element instanceof TreeField && ((TreeRegister)((TreeField)element).getParent()).isRetrievalActive()) {
                    return parent.getShell().getDisplay().getSystemColor(6);
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof TreeField) {
                    byte bitOffset = ((TreeField)element).getBitOffset();
                    byte bitLength = ((TreeField)element).getBitLength();
                    if (bitLength == 1) {
                        return String.valueOf(element.toString()) + " (bit " + String.valueOf(bitOffset) + ")";
                    }
                    return String.valueOf(element.toString()) + " (bits " + String.valueOf(bitOffset) + "-" + String.valueOf(bitOffset + bitLength - 1) + ")";
                }
                return element.toString();
            }

            public Image getImage(Object obj) {
                if (obj instanceof TreeParent && obj instanceof TreeRegister) {
                    if (((TreeRegister)obj).isRetrievalActive()) {
                        return EmbSysRegView.this.selectedImage;
                    }
                    return EmbSysRegView.this.unselectedImage;
                }
                if (obj instanceof TreeField) {
                    if (((TreeRegister)((TreeField)obj).getParent()).isRetrievalActive()) {
                        return EmbSysRegView.this.selectedFieldImage;
                    }
                    return EmbSysRegView.this.unselectedFieldImage;
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
        });
        column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Hex");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Color getForeground(Object element) {
                if (element instanceof TreeRegister && !((TreeRegister)element).isWriteOnly() && ((TreeRegister)element).hasValueChanged()) {
                    return parent.getShell().getDisplay().getSystemColor(3);
                }
                if (element instanceof TreeField && !((TreeRegister)((TreeField)element).getParent()).isWriteOnly() && ((TreeField)element).hasValueChanged()) {
                    return parent.getShell().getDisplay().getSystemColor(3);
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof TreeGroup) {
                    return "";
                }
                if (element instanceof TreeRegisterGroup) {
                    return "";
                }
                if (element instanceof TreeRegister) {
                    if (((TreeRegister)element).getValue() == -1L) {
                        return "";
                    }
                    if (((TreeRegister)element).isWriteOnly()) {
                        return "- write only -";
                    }
                    return Utils.longtoHexString(((TreeRegister)element).getValue(), ((TreeRegister)element).getBitSize());
                }
                if (element instanceof TreeField) {
                    if (((TreeRegister)((TreeField)element).getParent()).getValue() == -1L) {
                        return "";
                    }
                    if (((TreeRegister)((TreeField)element).getParent()).isWriteOnly()) {
                        return "- write only -";
                    }
                    return Utils.longtoHexString(((TreeField)element).getValue(), ((TreeField)element).getBitLength());
                }
                return element.toString();
            }
        });
        final TextCellEditor textCellEditor = new TextCellEditor((Composite)this.viewer.getTree());
        textCellEditor.setValidator((ICellEditorValidator)new HexCellEditorValidator(this.viewer));
        final ComboBoxCellEditor comboBoxCellEditor = new ComboBoxCellEditor((Composite)this.viewer.getTree(), new String[0], 0);
        comboBoxCellEditor.setValidator((ICellEditorValidator)new HexCellEditorValidator(this.viewer));
        ((CCombo)comboBoxCellEditor.getControl()).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ((CCombo)comboBoxCellEditor.getControl()).getSelectionIndex();
                TreeElement obj = EmbSysRegView.this.currentEditedElement;
                if (obj instanceof TreeField) {
                    long value = -1L;
                    if (selectionIndex != -1) {
                        value = ((TreeField)obj).getInterpretations().getValue(((CCombo)comboBoxCellEditor.getControl()).getItem(selectionIndex));
                    } else {
                        String svalue = ((CCombo)comboBoxCellEditor.getControl()).getText();
                        if (svalue.startsWith("0x")) {
                            value = Long.valueOf(svalue.substring(2, svalue.length()), 16);
                        }
                    }
                    if (value != -1L) {
                        ((TreeField)obj).setValue(value);
                    }
                }
                if (((TreeRegister)obj.getParent()).isWriteOnly()) {
                    EmbSysRegView.this.updateTreeFields(EmbSysRegView.this.invisibleRoot);
                }
                EmbSysRegView.this.viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        comboBoxCellEditor.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                int selectionIndex = ((CCombo)comboBoxCellEditor.getControl()).getSelectionIndex();
                TreeElement obj = EmbSysRegView.this.currentEditedElement;
                if (obj instanceof TreeField) {
                    long value = -1L;
                    if (selectionIndex != -1) {
                        value = ((TreeField)obj).getInterpretations().getValue(((CCombo)comboBoxCellEditor.getControl()).getItem(selectionIndex));
                    } else {
                        String svalue = ((CCombo)comboBoxCellEditor.getControl()).getText();
                        if (svalue.startsWith("0x")) {
                            value = Long.valueOf(svalue.substring(2, svalue.length()), 16);
                        }
                    }
                    if (value != -1L) {
                        ((TreeField)obj).setValue(value);
                    }
                }
                if (((TreeRegister)obj.getParent()).isWriteOnly()) {
                    EmbSysRegView.this.updateTreeFields(EmbSysRegView.this.invisibleRoot);
                }
                EmbSysRegView.this.viewer.refresh();
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        });
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            protected boolean canEdit(Object element) {
                if (element instanceof TreeField && (((TreeRegister)((TreeField)element).getParent()).isReadWrite() || ((TreeRegister)((TreeField)element).getParent()).isWriteOnly())) {
                    return true;
                }
                return element instanceof TreeRegister && (((TreeRegister)element).isReadWrite() || ((TreeRegister)element).isWriteOnly());
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof TreeField && ((TreeField)element).hasInterpretations()) {
                    comboBoxCellEditor.setItems(((TreeField)element).getInterpretations().getInterpretations());
                    IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                    int store_combolength = store.getInt("combolength");
                    if (store_combolength > 0) {
                        ((CCombo)comboBoxCellEditor.getControl()).setVisibleItemCount(store_combolength);
                    }
                    EmbSysRegView.this.currentEditedElement = (TreeElement)element;
                    return comboBoxCellEditor;
                }
                return textCellEditor;
            }

            protected Object getValue(Object element) {
                if (element instanceof TreeField && ((TreeField)element).hasInterpretations()) {
                    return new Integer((int)((TreeField)element).getValue());
                }
                if (element instanceof TreeField && ((TreeField)element).getValue() != -1L) {
                    return Utils.longtoHexString(((TreeField)element).getValue(), ((TreeField)element).getBitLength());
                }
                if (element instanceof TreeRegister && ((TreeRegister)element).getValue() != -1L) {
                    return Utils.longtoHexString(((TreeRegister)element).getValue(), ((TreeRegister)element).getBitSize());
                }
                return null;
            }

            protected void setValue(Object element, Object value) {
                if (value == null) {
                    return;
                }
                if (value instanceof String) {
                    String svalue;
                    if (element instanceof TreeRegister && ((String)value).startsWith("0x")) {
                        svalue = (String)value;
                        long lvalue = Long.valueOf(svalue.substring(2, svalue.length()), 16);
                        TreeRegister treeRegister = (TreeRegister)element;
                        if (treeRegister.getValue() != -1L && treeRegister.getValue() != lvalue) {
                            treeRegister.setAndWriteValue(lvalue);
                            if (((TreeRegister)element).isWriteOnly()) {
                                EmbSysRegView.this.updateTreeFields(EmbSysRegView.this.invisibleRoot);
                            }
                            EmbSysRegView.this.viewer.refresh();
                        }
                    }
                    if (element instanceof TreeField && ((String)value).startsWith("0x")) {
                        svalue = (String)value;
                        long fvalue = Long.valueOf(svalue.substring(2, svalue.length()), 16);
                        TreeField treeField = (TreeField)element;
                        if (treeField.getValue() != -1L && treeField.getValue() != fvalue) {
                            TreeRegister treeRegister = (TreeRegister)treeField.getParent();
                            long rvalue = treeRegister.getValue();
                            byte bitLength = treeField.getBitLength();
                            byte bitOffset = treeField.getBitOffset();
                            long mask = 0xFFFFFFFFL >> 32 - bitLength << bitOffset;
                            rvalue &= mask ^ 0xFFFFFFFFFFFFFFFFL;
                            fvalue <<= bitOffset;
                            treeRegister.setAndWriteValue(rvalue |= (fvalue &= mask));
                            if (((TreeRegister)((TreeField)element).getParent()).isWriteOnly()) {
                                EmbSysRegView.this.updateTreeFields(EmbSysRegView.this.invisibleRoot);
                            }
                            EmbSysRegView.this.viewer.refresh((Object)treeRegister);
                        }
                    }
                }
            }
        });
        column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Bin");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Color getForeground(Object element) {
                if (element instanceof TreeRegister && !((TreeRegister)element).isWriteOnly() && ((TreeRegister)element).hasValueChanged()) {
                    return parent.getShell().getDisplay().getSystemColor(3);
                }
                if (element instanceof TreeField && !((TreeRegister)((TreeField)element).getParent()).isWriteOnly() && ((TreeField)element).hasValueChanged()) {
                    return parent.getShell().getDisplay().getSystemColor(3);
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof TreeGroup) {
                    return "";
                }
                if (element instanceof TreeRegisterGroup) {
                    return "";
                }
                if (element instanceof TreeRegister) {
                    if (((TreeRegister)element).getValue() == -1L) {
                        return "";
                    }
                    if (((TreeRegister)element).isWriteOnly()) {
                        return "------------- write only -------------";
                    }
                    return Utils.longtobinarystring(((TreeRegister)element).getValue(), ((TreeRegister)element).getBitSize());
                }
                if (element instanceof TreeField) {
                    if (((TreeRegister)((TreeField)element).getParent()).getValue() == -1L) {
                        return "";
                    }
                    if (((TreeRegister)((TreeField)element).getParent()).isWriteOnly()) {
                        return "------------- write only -------------";
                    }
                    return Utils.longtobinarystring(((TreeField)element).getValue(), ((TreeField)element).getBitLength());
                }
                return element.toString();
            }
        });
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            protected boolean canEdit(Object element) {
                if (element instanceof TreeField && (((TreeRegister)((TreeField)element).getParent()).isReadWrite() || ((TreeRegister)((TreeField)element).getParent()).isWriteOnly())) {
                    return true;
                }
                return element instanceof TreeRegister && (((TreeRegister)element).isReadWrite() || ((TreeRegister)element).isWriteOnly());
            }

            protected CellEditor getCellEditor(Object element) {
                return new BinaryButtonsCellEditor((Composite)EmbSysRegView.this.viewer.getTree(), EmbSysRegView.this.viewer);
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected void setValue(Object element, Object value) {
                EmbSysRegView.this.viewer.refresh(element);
            }
        });
        column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Reset");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TreeGroup) {
                    return "";
                }
                if (element instanceof TreeRegisterGroup) {
                    return "";
                }
                if (element instanceof TreeRegister) {
                    return Utils.longtoHexString(((TreeRegister)element).getResetValue(), ((TreeRegister)element).getBitSize());
                }
                if (element instanceof TreeField) {
                    return "";
                }
                return "";
            }
        });
        column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setAlignment(0x1000000);
        column.getColumn().setWidth(50);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Access");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TreeGroup) {
                    return "";
                }
                if (element instanceof TreeRegisterGroup) {
                    return "";
                }
                if (element instanceof TreeRegister) {
                    return ((TreeRegister)element).getType().toUpperCase();
                }
                if (element instanceof TreeField) {
                    return "";
                }
                return "";
            }
        });
        column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Address");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TreeGroup) {
                    return "";
                }
                if (element instanceof TreeRegisterGroup) {
                    return "";
                }
                if (element instanceof TreeRegister) {
                    return Utils.longtoHexString(((TreeRegister)element).getRegisterAddress(), 32);
                }
                if (element instanceof TreeField) {
                    return "";
                }
                return "";
            }
        });
        column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(300);
        column.getColumn().setMoveable(false);
        column.getColumn().setText("Description");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        column.setLabelProvider(new CellLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof TreeRegister) {
                    if (Utils.countTextLines(((TreeRegister)element).getDescription()) > 1) {
                        return ((TreeRegister)element).getDescription();
                    }
                    return null;
                }
                if (element instanceof TreeField) {
                    if (Utils.countTextLines(((TreeField)element).getDescription()) > 1 || ((TreeField)element).hasInterpretation()) {
                        return ((TreeField)element).getDescription();
                    }
                    return null;
                }
                return null;
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 200;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 0;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof TreeGroup) {
                    cell.setText(((TreeGroup)element).getDescription());
                }
                if (element instanceof TreeRegisterGroup) {
                    cell.setText(((TreeRegisterGroup)element).getDescription());
                }
                if (element instanceof TreeRegister) {
                    cell.setText(Utils.getFirstNotEmptyTextLine(((TreeRegister)element).getDescription()).trim());
                }
                if (element instanceof TreeField) {
                    if (((TreeField)element).hasInterpretation()) {
                        cell.setText(((TreeField)element).getInterpretation());
                        cell.setImage(EmbSysRegView.this.interpretationImage);
                    } else {
                        cell.setText(Utils.getFirstNotEmptyTextLine(((TreeField)element).getDescription()).trim());
                        if (Utils.countTextLines(((TreeField)element).getDescription()) > 1) {
                            cell.setImage(EmbSysRegView.this.infoImage);
                        }
                    }
                }
            }
        });
        this.doubleClickAction = new Action(){

            public void run() {
                TreeField treeField;
                TreeRegister treeRegister;
                TreeRegister treeRegister2;
                ISelection selection = EmbSysRegView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                int selectedColumn = -1;
                Tree tree = EmbSysRegView.this.viewer.getTree();
                Point pt = tree.toControl(Display.getCurrent().getCursorLocation());
                EmbSysRegView.this.viewer.getTree().getColumnCount();
                int i = 0;
                while (i < tree.getColumnCount()) {
                    TreeItem item = tree.getItem(pt);
                    if (item != null && item.getBounds(i).contains(pt)) {
                        selectedColumn = i;
                    }
                    ++i;
                }
                if (obj instanceof TreeRegisterGroup && selectedColumn == 0) {
                    TreeElement[] treeElements;
                    TreeRegisterGroup treeRegisterGroup = (TreeRegisterGroup)obj;
                    TreeElement[] treeElementArray = treeElements = treeRegisterGroup.getChildren();
                    int n = treeElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeElement treeElement = treeElementArray[n2];
                        TreeRegister treeRegister3 = (TreeRegister)treeElement;
                        if (!treeRegister3.isWriteOnly()) {
                            treeRegister3.toggleRetrieval();
                            treeRegister3.readValue();
                        }
                        ++n2;
                    }
                    EmbSysRegView.this.viewer.refresh(obj);
                }
                if (obj instanceof TreeRegister && selectedColumn == 0 && !(treeRegister2 = (TreeRegister)obj).isWriteOnly()) {
                    treeRegister2.toggleRetrieval();
                    treeRegister2.readValue();
                    EmbSysRegView.this.viewer.refresh(obj);
                }
                if (obj instanceof TreeField && selectedColumn == 0 && !(treeRegister = (TreeRegister)(treeField = (TreeField)obj).getParent()).isWriteOnly()) {
                    treeRegister.toggleRetrieval();
                    treeRegister.readValue();
                    EmbSysRegView.this.viewer.refresh((Object)treeField.getParent());
                }
            }
        };
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EmbSysRegView.this.doubleClickAction.run();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.updateInfoLabel();
        this.viewer.setInput((Object)this.invisibleRoot);
    }

    public void dispose() {
        GDBi.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void updateTreeFields(TreeElement element) {
        if (element instanceof TreeRegister) {
            ((TreeRegister)element).readValue();
        } else if (element instanceof TreeParent && ((TreeParent)element).hasChildren()) {
            TreeParent pelement = (TreeParent)element;
            TreeElement[] treeElementArray = pelement.getChildren();
            int n = treeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeElement telement = treeElementArray[n2];
                this.updateTreeFields(telement);
                ++n2;
            }
        }
    }

    private void clearTreeFields(TreeElement element) {
        if (element instanceof TreeRegister) {
            ((TreeRegister)element).clearValue();
        } else if (element instanceof TreeParent && ((TreeParent)element).hasChildren()) {
            TreeParent pelement = (TreeParent)element;
            TreeElement[] treeElementArray = pelement.getChildren();
            int n = treeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeElement telement = treeElementArray[n2];
                this.clearTreeFields(telement);
                ++n2;
            }
        }
    }

    @Override
    public void gdbTerminateListener() {
        this.clearTreeFields(this.invisibleRoot);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EmbSysRegView.this.viewer.refresh();
            }
        });
    }

    @Override
    public void gdbSuspendListener() {
        this.updateTreeFields(this.invisibleRoot);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EmbSysRegView.this.viewer.refresh();
            }
        });
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        public ViewContentProvider() {
            this.initialize();
            Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("architecture") || event.getProperty().equals("vendor") || event.getProperty().equals("chip") || event.getProperty().equals("board")) {
                        ViewContentProvider.this.initialize();
                        ((ViewContentProvider)ViewContentProvider.this).EmbSysRegView.this.viewer.setInput((Object)EmbSysRegView.this.invisibleRoot);
                        ((ViewContentProvider)ViewContentProvider.this).EmbSysRegView.this.viewer.refresh();
                        EmbSysRegView.this.updateInfoLabel();
                    }
                }
            });
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(EmbSysRegView.this.getViewSite())) {
                if (EmbSysRegView.this.invisibleRoot == null) {
                    this.initialize();
                }
                return this.getChildren(EmbSysRegView.this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeElement) {
                return ((TreeElement)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }

        private void initialize() {
            EmbSysRegView.this.invisibleRoot = new TreeParent("", "");
            try {
                EmbSysRegView.this.invisibleRoot = new RegisterXMLParser().LoadXML();
            }
            catch (JDOMException jDOMException) {
            }
            catch (ParseException parseException) {}
        }
    }
}

