/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import net.miginfocom.swt.MigLayout;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class PreferencePageEmbSys
extends PreferencePage
implements IWorkbenchPreferencePage {
    Combo architecture;
    Combo vendor;
    Combo chip;
    Combo board;
    Text descriptionText;

    public PreferencePageEmbSys() {
        this.noDefaultAndApplyButton();
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("A Periperal Register View for embedded system");
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.chip != null && this.architecture != null && this.vendor != null && this.chip != null && this.board != null) {
            if (this.chip.getSelectionIndex() == -1) {
                return false;
            }
            IPreferenceStore store = this.getPreferenceStore();
            if (this.architecture.getSelectionIndex() != -1) {
                store.setValue("architecture", this.architecture.getItem(this.architecture.getSelectionIndex()));
            } else {
                store.setValue("architecture", "");
            }
            if (this.vendor.getSelectionIndex() != -1) {
                store.setValue("vendor", this.vendor.getItem(this.vendor.getSelectionIndex()));
            } else {
                store.setValue("vendor", "");
            }
            if (this.chip.getSelectionIndex() != -1) {
                store.setValue("chip", this.chip.getItem(this.chip.getSelectionIndex()));
            } else {
                store.setValue("chip", "");
            }
            if (this.board.getSelectionIndex() != -1) {
                store.setValue("board", this.board.getItem(this.board.getSelectionIndex()));
            } else {
                store.setValue("board", "");
            }
            return this.architecture.getSelectionIndex() != -1 && this.vendor.getSelectionIndex() != -1 && this.chip.getSelectionIndex() != -1;
        }
        return true;
    }

    private List<String> getDirList(String path, String pattern) {
        ArrayList<String> dirList = new ArrayList<String>();
        Enumeration entries = Platform.getBundle((String)"org.eclipse.cdt.embsysregview").findEntries(path, pattern, false);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL entry = (URL)entries.nextElement();
                File x = new File(entry.getFile());
                try {
                    String filename = x.getCanonicalFile().getName();
                    if (filename.startsWith(".")) continue;
                    dirList.add(filename);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return dirList;
    }

    private void restoreStoredSettings() {
        IPreferenceStore store = this.getPreferenceStore();
        String store_architecture = store.getString("architecture");
        String store_vendor = store.getString("vendor");
        String store_chip = store.getString("chip");
        String store_board = store.getString("board");
        int index = this.architecture.indexOf(store_architecture);
        if (index != -1) {
            this.architecture.select(index);
            this.fillVendor(store_architecture);
            this.vendor.setEnabled(true);
            index = this.vendor.indexOf(store_vendor);
            if (index != -1) {
                this.vendor.select(index);
                this.fillChip(store_architecture, store_vendor);
                this.chip.setEnabled(true);
                index = this.chip.indexOf(store_chip);
                if (index != -1) {
                    this.chip.select(index);
                    this.fillBoard(store_architecture, store_vendor, store_chip);
                    index = this.board.indexOf(store_board);
                    if (index != -1) {
                        this.board.select(index);
                    }
                }
            } else {
                this.vendor.setText("");
            }
        } else {
            this.architecture.setText("");
        }
    }

    private void fillArchitecture() {
        for (String entry : this.getDirList("data", "*")) {
            this.architecture.add(entry);
        }
        this.restoreStoredSettings();
    }

    private void fillVendor(String selectedArchitecture) {
        this.chip.setEnabled(false);
        this.board.setEnabled(false);
        this.vendor.setEnabled(true);
        this.chip.setText("");
        this.board.setText("");
        this.vendor.removeAll();
        this.chip.removeAll();
        this.board.removeAll();
        for (String entry : this.getDirList("data/" + selectedArchitecture, "*")) {
            this.vendor.add(entry);
        }
        this.vendor.setText("");
        this.descriptionText.setText("");
    }

    private void fillChip(String selectedArchitecture, String selectedVendor) {
        this.board.setEnabled(false);
        this.board.setText("");
        this.chip.setEnabled(true);
        this.chip.removeAll();
        this.board.removeAll();
        for (String entry : this.getDirList("data/" + selectedArchitecture + "/" + selectedVendor, "*.xml")) {
            this.chip.add(entry.substring(0, entry.length() - 4));
        }
        this.chip.setText("");
        this.descriptionText.setText("");
    }

    private void fillBoard(String selectedArchitecture, String selectedVendor, String selectedChip) {
        this.board.removeAll();
        this.board.add("---  none ---");
        SAXBuilder builder = new SAXBuilder();
        builder.setValidation(false);
        Bundle bundle = Platform.getBundle((String)"org.eclipse.cdt.embsysregview");
        URL fileURL = bundle.getEntry("data/" + selectedArchitecture + "/" + selectedVendor + "/" + selectedChip + ".xml");
        boolean containsBoards = false;
        try {
            Document doc = builder.build(fileURL);
            Element root = doc.getRootElement();
            if (root.getName() != "device") {
                List grouplist = root.getChildren("boards");
                for (Element group : grouplist) {
                    List boardlist = group.getChildren();
                    for (Element boardElement : boardlist) {
                        containsBoards = true;
                        Attribute attr_bname = boardElement.getAttribute("id");
                        String bname = attr_bname != null ? attr_bname.getValue() : "-1";
                        this.board.add(bname);
                    }
                }
                Element chip_description = root.getChild("chip_description");
                if (chip_description != null) {
                    this.descriptionText.setText(chip_description.getText());
                }
            } else {
                Element chip_description = root.getChild("description");
                if (chip_description != null) {
                    this.descriptionText.setText(chip_description.getText());
                }
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (containsBoards) {
            this.board.setEnabled(true);
        } else {
            this.board.setEnabled(false);
        }
        if (this.board.getItemCount() > 0) {
            this.board.setText(this.board.getItem(0));
        } else {
            this.board.setText("");
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Composite left = new Composite(composite, 0);
        Composite right = new Composite(composite, 0);
        MigLayout migLayout = new MigLayout("fill", "[180,grow 0][fill,grow]", "top");
        composite.setLayout((Layout)migLayout);
        left.setLayoutData((Object)"width 100:180:180");
        left.setLayout((Layout)new GridLayout(1, false));
        right.setLayoutData((Object)"grow,hmin 0,wmin 0");
        right.setLayout((Layout)new FillLayout());
        Label architectureLabel = new Label(left, 16384);
        architectureLabel.setText("Architecture:");
        this.architecture = new Combo(left, 12);
        this.architecture.setVisibleItemCount(10);
        this.architecture.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label vendorLabel = new Label(left, 16384);
        vendorLabel.setText("Vendor:");
        this.vendor = new Combo(left, 12);
        this.vendor.setVisibleItemCount(10);
        this.vendor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label chipLabel = new Label(left, 16384);
        chipLabel.setText("Chip:");
        this.chip = new Combo(left, 12);
        this.chip.setVisibleItemCount(20);
        this.chip.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label boardLabel = new Label(left, 16384);
        boardLabel.setText("Board:");
        this.board = new Combo(left, 12);
        this.board.setVisibleItemCount(10);
        this.board.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group descriptionGroup = new Group(right, 0);
        descriptionGroup.setText("Chip description");
        descriptionGroup.setLayout((Layout)new MigLayout("fill"));
        this.descriptionText = new Text((Composite)descriptionGroup, 842);
        this.descriptionText.setLayoutData((Object)"height 100%,width 100%,hmin 0,wmin 400");
        this.descriptionText.setText("");
        FontData[] fD = this.descriptionText.getFont().getFontData();
        fD[0].setName("Lucida Console");
        Font f = new Font((Device)Display.getCurrent(), fD[0]);
        this.descriptionText.setFont(f);
        this.architecture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferencePageEmbSys.this.fillVendor(PreferencePageEmbSys.this.architecture.getItem(PreferencePageEmbSys.this.architecture.getSelectionIndex()));
            }
        });
        this.vendor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferencePageEmbSys.this.fillChip(PreferencePageEmbSys.this.architecture.getItem(PreferencePageEmbSys.this.architecture.getSelectionIndex()), PreferencePageEmbSys.this.vendor.getItem(PreferencePageEmbSys.this.vendor.getSelectionIndex()));
            }
        });
        this.chip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferencePageEmbSys.this.fillBoard(PreferencePageEmbSys.this.architecture.getItem(PreferencePageEmbSys.this.architecture.getSelectionIndex()), PreferencePageEmbSys.this.vendor.getItem(PreferencePageEmbSys.this.vendor.getSelectionIndex()), PreferencePageEmbSys.this.chip.getItem(PreferencePageEmbSys.this.chip.getSelectionIndex()));
            }
        });
        this.architecture.setSize(500, 30);
        this.vendor.setSize(500, 30);
        this.vendor.setEnabled(false);
        this.chip.setSize(500, 30);
        this.chip.setEnabled(false);
        this.board.setSize(500, 30);
        this.board.setEnabled(false);
        this.fillArchitecture();
        parent.pack();
        return composite;
    }
}

