/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.embsysregview.parser;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.List;
import org.eclipse.cdt.embsysregview.Activator;
import org.eclipse.cdt.embsysregview.views.Interpretations;
import org.eclipse.cdt.embsysregview.views.TreeElement;
import org.eclipse.cdt.embsysregview.views.TreeField;
import org.eclipse.cdt.embsysregview.views.TreeGroup;
import org.eclipse.cdt.embsysregview.views.TreeParent;
import org.eclipse.cdt.embsysregview.views.TreeRegister;
import org.eclipse.cdt.embsysregview.views.TreeRegisterGroup;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class RegisterXMLParser {
    private String store_board;

    private Document OpenXML() throws JDOMException, IOException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.cdt.embsysregview");
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String store_architecture = store.getString("architecture");
        String store_vendor = store.getString("vendor");
        String store_chip = store.getString("chip");
        this.store_board = store.getString("board");
        URL fileURL = bundle.getEntry("data/" + store_architecture + "/" + store_vendor + "/" + store_chip + ".xml");
        SAXBuilder builder = new SAXBuilder();
        builder.setValidation(false);
        return builder.build(fileURL);
    }

    public TreeParent LoadXML() throws ParseException, DataConversionException {
        Document doc;
        TreeParent tempRoot = new TreeParent("", "");
        try {
            doc = this.OpenXML();
        }
        catch (Exception exception) {
            return tempRoot;
        }
        Element root = doc.getRootElement();
        if (root.getName() == "device") {
            return this.ParseSVD(root, tempRoot);
        }
        return this.ParseXML(root, tempRoot);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TreeParent ParseSVD(Element root, TreeParent tempRoot) throws ParseException, DataConversionException {
        TreeElement oldTreeGroup = null;
        Element peripherals = root.getChild("peripherals");
        if (peripherals == null) return tempRoot;
        List grouplist = peripherals.getChildren("peripheral");
        for (Element group : grouplist) {
            Element registers;
            TreeElement obj_group;
            Element attr_gname = group.getChild("name");
            if (attr_gname == null) {
                throw new ParseException("peripheral requires name", 1);
            }
            String gname = attr_gname.getValue();
            Element element_baseAddress = group.getChild("baseAddress");
            if (element_baseAddress == null) {
                throw new ParseException("peripheral requires baseAddress", 1);
            }
            String baseAddress = element_baseAddress.getValue();
            Element attr_gdescription = group.getChild("description");
            String gdescription = attr_gdescription != null ? attr_gdescription.getValue() : "";
            String expression = "_?[0-9]+$";
            String uniqgroup = gname.replaceAll(expression, "");
            if (oldTreeGroup != null && oldTreeGroup.getName().equals(uniqgroup)) {
                obj_group = oldTreeGroup;
            } else {
                obj_group = new TreeGroup(uniqgroup, gdescription);
                tempRoot.addChild(obj_group);
                oldTreeGroup = obj_group;
            }
            TreeRegisterGroup obj_registergroup = new TreeRegisterGroup(gname, gdescription);
            ((TreeParent)obj_group).addChild(obj_registergroup);
            Attribute attr_derivedFrom = group.getAttribute("derivedFrom");
            if (attr_derivedFrom != null) {
                String derivedFrom = attr_derivedFrom.getValue();
                Element linkedperipherals = root.getChild("peripherals");
                if (linkedperipherals != null) {
                    List linkedgrouplist = linkedperipherals.getChildren("peripheral");
                    for (Element linkedgroup : linkedgrouplist) {
                        Element attr_lname = linkedgroup.getChild("name");
                        if (attr_lname == null || !attr_lname.getValue().equals(derivedFrom)) continue;
                        group = linkedgroup;
                    }
                }
            }
            if ((registers = group.getChild("registers")) == null) continue;
            List registerlist = registers.getChildren("register");
            for (Element register : registerlist) {
                Element attr_rname = register.getChild("name");
                if (attr_rname == null) {
                    throw new ParseException("register requires name", 1);
                }
                String rname = attr_rname.getValue();
                Element attr_rdescription = register.getChild("description");
                String rdescription = attr_rdescription != null ? attr_rdescription.getValue() : "";
                Element attr_roffsetaddress = register.getChild("addressOffset");
                if (attr_roffsetaddress == null) throw new ParseException("register requires address", 1);
                long raddress = attr_roffsetaddress.getValue().startsWith("0x") ? Long.parseLong(attr_roffsetaddress.getValue().substring(2), 16) : Long.parseLong(attr_roffsetaddress.getValue());
                Element attr_rresetvalue = register.getChild("resetValue");
                long rresetvalue = attr_rresetvalue != null && attr_rresetvalue.getValue() != "" ? (attr_rresetvalue.getValue().startsWith("0x") ? Long.parseLong(attr_rresetvalue.getValue().substring(2), 16) : Long.parseLong(attr_rresetvalue.getValue())) : 0L;
                Element attr_raccess = register.getChild("access");
                String raccess = attr_raccess != null ? attr_raccess.getValue() : "RO";
                raccess = raccess.equals("read-write") ? "RW" : raccess;
                raccess = raccess.equals("write-only") ? "WO" : raccess;
                raccess = raccess.equals("read-only") ? "RO" : raccess;
                raccess = raccess.equals("read-write") ? "RW" : raccess;
                Element attr_rsize = register.getChild("size");
                int rsize = attr_rsize != null ? (attr_rsize.getValue().startsWith("0x") ? Integer.parseInt(attr_rsize.getValue().substring(2), 16) / 8 : Integer.parseInt(attr_rsize.getValue()) / 8) : 4;
                long lbaseAddress = Long.parseLong(baseAddress.substring(2), 16);
                TreeRegister obj_register = new TreeRegister(rname, rdescription, lbaseAddress + raddress, rresetvalue, raccess, rsize);
                System.out.println("Register: " + rname + " " + rdescription + " " + lbaseAddress + " " + raddress + " " + rresetvalue + " " + raccess + " " + rsize);
                obj_registergroup.addChild(obj_register);
                Element fields_element = register.getChild("fields");
                if (fields_element == null) continue;
                List fieldlist = fields_element.getChildren("field");
                for (Element field : fieldlist) {
                    byte fbitlength;
                    byte fbitoffset;
                    Element attr_fname = field.getChild("name");
                    if (attr_fname == null) {
                        throw new ParseException("field requires name", 1);
                    }
                    String fname = attr_fname.getValue();
                    Element attr_fdescription = field.getChild("description");
                    String fdescription = attr_fdescription != null ? attr_fdescription.getValue() : "";
                    Element attr_fbitoffset = field.getChild("bitOffset");
                    if (attr_fbitoffset != null) {
                        fbitoffset = Byte.parseByte(attr_fbitoffset.getValue());
                        Element attr_fbitlength = field.getChild("bitWidth");
                        if (attr_fbitlength == null) throw new ParseException("field requires bitlength", 1);
                        fbitlength = Byte.parseByte(attr_fbitlength.getValue());
                    } else {
                        Element attr_fbitrange = field.getChild("bitRange");
                        if (attr_fbitrange != null) {
                            String range_string = attr_fbitrange.getValue();
                            String range = range_string.substring(1, range_string.length() - 1);
                            String[] rangeArray = range.split(":");
                            fbitoffset = Byte.valueOf(rangeArray[0]);
                            fbitlength = (byte)(Byte.valueOf(rangeArray[0]) - Byte.valueOf(rangeArray[1]) + 1);
                        } else {
                            Element element_lsb = field.getChild("lsb");
                            Element element_msb = field.getChild("msb");
                            if (element_lsb == null || element_msb == null) throw new ParseException("field requires some sort of start-end bit marker", 1);
                            fbitoffset = Byte.valueOf(element_lsb.getValue());
                            fbitlength = (byte)(Byte.valueOf(element_msb.getValue()) - Byte.valueOf(element_lsb.getValue()));
                        }
                    }
                    Interpretations interpretations = new Interpretations();
                    Element enumeratedValues = field.getChild("enumeratedValues");
                    if (enumeratedValues == null) continue;
                    List interpretationlist = enumeratedValues.getChildren("enumeratedValue");
                    for (Element interpretation : interpretationlist) {
                        Element attr_key = interpretation.getChild("value");
                        if (attr_key == null) throw new ParseException("enumeratedValue requires value", 1);
                        long key = attr_key.getValue().startsWith("0x") ? Long.valueOf(attr_key.getValue().substring(2), 16).longValue() : Long.valueOf(attr_key.getValue()).longValue();
                        Element attr_name = interpretation.getChild("name");
                        if (attr_name == null) {
                            throw new ParseException("enumeratedValue requires name", 1);
                        }
                        String name = attr_name.getValue();
                        Element attr_text = interpretation.getChild("description");
                        String text = attr_text != null ? attr_text.getValue() : name;
                        interpretations.addInterpretation(key, String.valueOf(name) + ": " + text);
                    }
                    System.out.println("Field: " + fname + " " + fdescription + " " + fbitoffset + " " + fbitlength + " " + interpretations);
                    TreeField obj_field = new TreeField(fname, fdescription, fbitoffset, fbitlength, interpretations);
                    interpretations.setTreeField(obj_field);
                    obj_register.addChild(obj_field);
                }
            }
        }
        return tempRoot;
    }

    private TreeParent ParseXML(Element root, TreeParent tempRoot) throws ParseException, DataConversionException {
        List grouplist = root.getChildren("group");
        for (Element group : grouplist) {
            Attribute attr_gname = group.getAttribute("name");
            if (attr_gname == null) {
                throw new ParseException("group requires name", 1);
            }
            String gname = attr_gname.getValue();
            Attribute attr_gdescription = group.getAttribute("description");
            String gdescription = attr_gname != null ? attr_gdescription.getValue() : "";
            TreeGroup obj_group = new TreeGroup(gname, gdescription);
            tempRoot.addChild(obj_group);
            List registergrouplist = group.getChildren();
            for (Element registergroup : registergrouplist) {
                Attribute attr_rgname = registergroup.getAttribute("name");
                if (attr_rgname == null) {
                    throw new ParseException("registergroup requires name", 1);
                }
                String rgname = attr_rgname.getValue();
                Attribute attr_rgdescription = registergroup.getAttribute("description");
                String rgdescription = attr_rgdescription != null ? attr_rgdescription.getValue() : "";
                TreeRegisterGroup obj_registergroup = new TreeRegisterGroup(rgname, rgdescription);
                obj_group.addChild(obj_registergroup);
                List registerlist = registergroup.getChildren();
                for (Element register : registerlist) {
                    Attribute attr_rname = register.getAttribute("name");
                    if (attr_rgname == null) {
                        throw new ParseException("register requires name", 1);
                    }
                    String rname = attr_rname.getValue();
                    Attribute attr_rdescription = register.getAttribute("description");
                    String rdescription = attr_rdescription != null ? attr_rdescription.getValue() : "";
                    Attribute attr_roffsetaddress = register.getAttribute("address");
                    if (attr_roffsetaddress == null) {
                        throw new ParseException("register requires address", 1);
                    }
                    long raddress = Long.parseLong(attr_roffsetaddress.getValue().substring(2), 16);
                    Attribute attr_rresetvalue = register.getAttribute("resetvalue");
                    long rresetvalue = attr_rresetvalue != null && attr_rresetvalue.getValue() != "" ? Long.parseLong(attr_rresetvalue.getValue().substring(2), 16) : 0L;
                    Attribute attr_raccess = register.getAttribute("access");
                    String raccess = attr_raccess != null ? attr_raccess.getValue() : "RO";
                    Attribute attr_rsize = register.getAttribute("size");
                    int rsize = attr_rsize != null ? Integer.parseInt(attr_rsize.getValue()) : 4;
                    TreeRegister obj_register = new TreeRegister(rname, rdescription, raddress, rresetvalue, raccess, rsize);
                    obj_registergroup.addChild(obj_register);
                    Element register_description = register.getChild("description");
                    if (register_description != null) {
                        rdescription = register_description.getText();
                        obj_register.setDescription(rdescription);
                    }
                    List fieldlist = register.getChildren("field");
                    for (Element field : fieldlist) {
                        Attribute attr_fboard_id = field.getAttribute("board_id");
                        String fboard_id = attr_fboard_id != null ? attr_fboard_id.getValue() : "";
                        if (!fboard_id.equals("") && !fboard_id.equals(this.store_board)) continue;
                        Attribute attr_fname = field.getAttribute("name");
                        if (attr_fname == null) {
                            throw new ParseException("field requires name", 1);
                        }
                        String fname = attr_fname.getValue();
                        Attribute attr_fdescription = field.getAttribute("description");
                        String fdescription = attr_fdescription != null ? attr_fdescription.getValue() : "";
                        Attribute attr_fbitoffset = field.getAttribute("bitoffset");
                        if (attr_fbitoffset == null) {
                            throw new ParseException("field requires bitoffset", 1);
                        }
                        byte fbitoffset = Byte.parseByte(attr_fbitoffset.getValue());
                        Attribute attr_fbitlength = field.getAttribute("bitlength");
                        if (attr_fbitlength == null) {
                            throw new ParseException("field requires bitlength", 1);
                        }
                        byte fbitlength = Byte.parseByte(attr_fbitlength.getValue());
                        Element field_description = field.getChild("description");
                        if (field_description != null) {
                            fdescription = field_description.getText();
                        }
                        Interpretations interpretations = new Interpretations();
                        List interpretationlist = field.getChildren("interpretation");
                        for (Element interpretation : interpretationlist) {
                            long key;
                            Attribute attr_key = interpretation.getAttribute("key");
                            if (attr_key != null) {
                                String skey = attr_key.getValue();
                                key = skey.startsWith("0x") ? Long.parseLong(skey.substring(2), 16) : Long.parseLong(skey);
                            } else {
                                throw new ParseException("interpretation requires key", 1);
                            }
                            Attribute attr_text = interpretation.getAttribute("text");
                            if (attr_text == null) {
                                throw new ParseException("interpretation requires text", 1);
                            }
                            String text = attr_text.getValue();
                            interpretations.addInterpretation(key, text);
                        }
                        TreeField obj_field = new TreeField(fname, fdescription, fbitoffset, fbitlength, interpretations);
                        interpretations.setTreeField(obj_field);
                        obj_register.addChild(obj_field);
                    }
                }
            }
        }
        return tempRoot;
    }
}

