/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.ISessionInfo;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TargetNodeComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionComponent;

public class TraceSessionGroup
extends TraceControlComponent {
    public static final String TRACE_SESSIONS_ICON_FILE = "icons/obj16/sessions.gif";

    public TraceSessionGroup(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(TRACE_SESSIONS_ICON_FILE);
    }

    public TargetNodeComponent getTargetNode() {
        return (TargetNodeComponent)this.getParent();
    }

    public void getSessionsFromNode() throws ExecutionException {
        this.getSessionsFromNode((IProgressMonitor)new NullProgressMonitor());
    }

    public void getSessionsFromNode(IProgressMonitor monitor) throws ExecutionException {
        String[] sessionNames = this.getControlService().getSessionNames(monitor);
        int i = 0;
        while (i < sessionNames.length) {
            TraceSessionComponent session = new TraceSessionComponent(sessionNames[i], this);
            this.addChild(session);
            session.getConfigurationFromNode(monitor);
            ++i;
        }
    }

    public void createSession(String sessionName, String sessionPath) throws ExecutionException {
        this.createSession(sessionName, sessionPath, (IProgressMonitor)new NullProgressMonitor());
    }

    public void createSession(String sessionName, String sessionPath, IProgressMonitor monitor) throws ExecutionException {
        ISessionInfo sessionInfo = this.getControlService().createSession(sessionName, sessionPath, monitor);
        if (sessionInfo != null) {
            TraceSessionComponent session = new TraceSessionComponent(sessionInfo.getName(), this);
            this.addChild(session);
            session.getConfigurationFromNode(monitor);
        }
    }

    public void destroySession(TraceSessionComponent session) throws ExecutionException {
        this.destroySession(session, (IProgressMonitor)new NullProgressMonitor());
    }

    public void destroySession(TraceSessionComponent session, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().destroySession(session.getName(), monitor);
        session.removeAllChildren();
        this.removeChild(session);
    }
}

