/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui;

import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.rpm.ui.BuildType;
import org.eclipse.linuxtools.internal.rpm.ui.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.RpmConsole;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.osgi.framework.FrameworkUtil;

public class RPMExportOperation
extends Job {
    private IProgressMonitor monitor;
    private RPMProject rpmProject;
    private BuildType exportType;

    public RPMExportOperation(RPMProject rpmProject, BuildType exportType) {
        super(Messages.getString("RPMExportWizard.0"));
        this.rpmProject = rpmProject;
        this.exportType = exportType;
    }

    public IStatus run(IProgressMonitor progressMonitor) {
        int totalWork = 2;
        this.monitor = progressMonitor;
        this.monitor.beginTask(Messages.getString("RPMExportOperation.Starting"), totalWork);
        this.monitor.worked(1);
        BuildThread bt = new BuildThread(this.exportType, this.rpmProject);
        bt.start();
        while (bt.getState() != Thread.State.TERMINATED) {
            if (!this.monitor.isCanceled()) continue;
            bt.interrupt();
            return Status.CANCEL_STATUS;
        }
        this.monitor.worked(1);
        this.monitor.done();
        if (bt.getResult() != null) {
            return bt.getResult();
        }
        return Status.OK_STATUS;
    }

    private IOConsole findConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if ("rpmbuild".equals(existing[i].getName())) {
                return (RpmConsole)existing[i];
            }
            ++i;
        }
        RpmConsole myConsole = new RpmConsole(this.rpmProject);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private class BuildThread
    extends Thread {
        BuildType exportType;
        RPMProject rpmProject;
        IStatus result = null;

        public BuildThread(BuildType exportType, RPMProject rpmProject) {
            this.exportType = exportType;
            this.rpmProject = rpmProject;
        }

        public void run() {
            IOConsole myConsole = RPMExportOperation.this.findConsole();
            IOConsoleOutputStream out = myConsole.newOutputStream();
            myConsole.clearConsole();
            myConsole.activate();
            switch (this.exportType) {
                case ALL: {
                    try {
                        RPMExportOperation.this.monitor.setTaskName(Messages.getString("RPMExportOperation.Executing_RPM_Export"));
                        this.result = this.rpmProject.buildAll((OutputStream)out);
                    }
                    catch (CoreException e) {
                        this.result = new Status(4, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), e.getMessage(), (Throwable)e);
                    }
                    break;
                }
                case BINARY: {
                    RPMExportOperation.this.monitor.setTaskName(Messages.getString("RPMExportOperation.Executing_RPM_Export"));
                    try {
                        this.result = this.rpmProject.buildBinaryRPM((OutputStream)out);
                    }
                    catch (CoreException e) {
                        this.result = new Status(4, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), e.getMessage(), (Throwable)e);
                    }
                    break;
                }
                case SOURCE: {
                    RPMExportOperation.this.monitor.setTaskName(Messages.getString("RPMExportOperation.Executing_SRPM_Export"));
                    try {
                        this.result = this.rpmProject.buildSourceRPM((OutputStream)out);
                        break;
                    }
                    catch (CoreException e) {
                        this.result = new Status(4, FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        public IStatus getResult() {
            return this.result;
        }
    }
}

