/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.WorkbenchJob;

public class NewMakeProjFromExistingPage
extends WizardPage {
    Text projectName;
    Text location;
    Button langc;
    Button langcpp;
    IWorkspaceRoot root;
    List tcList;
    Map<String, IToolChain> tcMap = new HashMap<String, IToolChain>();
    boolean projectNameSetByUser;

    protected NewMakeProjFromExistingPage() {
        super(Messages.NewMakeProjFromExistingPage_0);
        this.setTitle(Messages.NewMakeProjFromExistingPage_1);
        this.setDescription(Messages.NewMakeProjFromExistingPage_2);
        this.root = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addProjectNameSelector(comp);
        this.addSourceSelector(comp);
        this.addLanguageSelector(comp);
        this.addToolchainSelector(comp);
        this.setControl((Control)comp);
    }

    public void addProjectNameSelector(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.NewMakeProjFromExistingPage_3);
        this.projectName = new Text((Composite)group, 2048);
        this.projectName.setLayoutData((Object)new GridData(4, 4, true, true));
        this.projectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMakeProjFromExistingPage.this.validatePage();
                if (NewMakeProjFromExistingPage.this.getProjectName().isEmpty()) {
                    NewMakeProjFromExistingPage.this.projectNameSetByUser = false;
                }
            }
        });
        this.projectName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                NewMakeProjFromExistingPage.this.projectNameSetByUser = true;
            }
        });
    }

    protected void validatePage() {
        String msg = null;
        boolean complete = true;
        String name = this.getProjectName();
        if (name.isEmpty()) {
            complete = false;
        } else {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 4);
            if (!status.isOK()) {
                msg = status.getMessage();
            } else {
                IProject project = this.root.getProject(name);
                if (project.exists()) {
                    msg = Messages.NewMakeProjFromExistingPage_4;
                }
            }
        }
        if (msg == null) {
            String loc = this.getLocation();
            if (loc.isEmpty()) {
                complete = false;
            } else {
                final File file = new File(loc);
                if (file.isDirectory()) {
                    if (!this.projectNameSetByUser && !name.equals(file.getName())) {
                        WorkbenchJob wjob = new WorkbenchJob("update project name"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (!NewMakeProjFromExistingPage.this.projectName.isDisposed()) {
                                    NewMakeProjFromExistingPage.this.projectName.setText(file.getName());
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        wjob.setSystem(true);
                        wjob.schedule();
                    }
                } else {
                    msg = Messages.NewMakeProjFromExistingPage_8;
                }
            }
        }
        this.setErrorMessage(msg);
        this.setPageComplete(msg == null && complete);
    }

    @Deprecated
    public void validateProjectName() {
        this.validatePage();
    }

    public void addSourceSelector(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.NewMakeProjFromExistingPage_5);
        this.location = new Text((Composite)group, 2048);
        this.location.setLayoutData((Object)new GridData(4, 4, true, true));
        this.location.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMakeProjFromExistingPage.this.validatePage();
            }
        });
        this.validatePage();
        Button browse = new Button((Composite)group, 0);
        browse.setLayoutData((Object)new GridData(4, 4, false, true));
        browse.setText(Messages.NewMakeProjFromExistingPage_6);
        browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(NewMakeProjFromExistingPage.this.location.getShell());
                dialog.setMessage(Messages.NewMakeProjFromExistingPage_7);
                String dir = dialog.open();
                if (dir != null) {
                    NewMakeProjFromExistingPage.this.location.setText(dir);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Deprecated
    void validateSource() {
        this.validatePage();
    }

    public void addLanguageSelector(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.NewMakeProjFromExistingPage_9);
        this.langc = new Button((Composite)group, 32);
        this.langc.setText("C");
        this.langc.setSelection(true);
        this.langcpp = new Button((Composite)group, 32);
        this.langcpp.setText("C++");
        this.langcpp.setSelection(true);
    }

    public void addToolchainSelector(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(Messages.NewMakeProjFromExistingPage_10);
        this.tcList = new List((Composite)group, 2564);
        GridData gd = new GridData(4, 4, true, true);
        this.updateTcMap(false);
        gd.heightHint = this.tcList.getItemHeight() * (1 + Math.max(Math.min(this.tcMap.size(), 15), 5));
        this.tcList.setLayoutData((Object)gd);
        this.tcList.add(Messages.NewMakeProjFromExistingPage_11);
        final Button supportedOnly = new Button((Composite)group, 32);
        supportedOnly.setSelection(false);
        supportedOnly.setText(Messages.NewMakeProjFromExistingPage_show_only_supported);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        supportedOnly.setLayoutData((Object)gd);
        supportedOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewMakeProjFromExistingPage.this.updateTcWidget(supportedOnly.getSelection());
            }
        });
        supportedOnly.setSelection(true);
        this.updateTcWidget(true);
    }

    private void updateTcWidget(boolean supportedOnly) {
        this.updateTcMap(supportedOnly);
        ArrayList<String> names = new ArrayList<String>(this.tcMap.keySet());
        Collections.sort(names);
        this.tcList.removeAll();
        this.tcList.add(Messages.NewMakeProjFromExistingPage_11);
        for (String name : names) {
            this.tcList.add(name);
        }
        this.tcList.setSelection(0);
    }

    private void updateTcMap(boolean supportedOnly) {
        IToolChain[] toolChains;
        this.tcMap.clear();
        IToolChain[] iToolChainArray = toolChains = ManagedBuildManager.getRealToolChains();
        int n = toolChains.length;
        int n2 = 0;
        while (n2 < n) {
            IToolChain toolChain = iToolChainArray[n2];
            if (!toolChain.isAbstract() && !toolChain.isSystemObject() && (!supportedOnly || toolChain.isSupported() && ManagedBuildManager.isPlatformOk((IToolChain)toolChain))) {
                this.tcMap.put(toolChain.getUniqueRealName(), toolChain);
            }
            ++n2;
        }
    }

    public String getProjectName() {
        return this.projectName.getText().trim();
    }

    public String getLocation() {
        return this.location.getText().trim();
    }

    public boolean isC() {
        return this.langc.getSelection();
    }

    public boolean isCPP() {
        return this.langcpp.getSelection();
    }

    public IToolChain getToolChain() {
        String[] selection = this.tcList.getSelection();
        return selection.length != 0 ? this.tcMap.get(selection[0]) : null;
    }
}

